/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.CodeBlockGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ModifierListGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public class AnonymousFromMapGenerator {
    private AnonymousFromMapGenerator() {
    }

    static void writeAnonymousMap(GrListOrMap operand, GrTypeElement typeElement, StringBuilder builder, ExpressionContext context) {
        PsiSubstitutor substitutor;
        PsiClass psiClass;
        PsiType type = typeElement.getType();
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type).resolveGenerics();
            psiClass = resolveResult.getElement();
            substitutor = resolveResult.getSubstitutor();
        } else {
            psiClass = null;
            substitutor = PsiSubstitutor.EMPTY;
        }
        builder.append("new ");
        TypeWriter.writeTypeForNew(builder, type, operand);
        builder.append("() {\n");
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(operand.getProject());
        GrExpression caller = factory.createExpressionFromText("this");
        for (GrNamedArgument arg : operand.getNamedArguments()) {
            String name = arg.getLabelName();
            GrExpression expression = arg.getExpression();
            if (name == null || !(expression instanceof GrClosableBlock)) continue;
            GrClosableBlock closure = (GrClosableBlock)expression;
            GrParameter[] allParameters = closure.getAllParameters();
            ArrayList<GrParameter> actual = new ArrayList<GrParameter>(Arrays.asList(allParameters));
            PsiType clReturnType = context.typeProvider.getReturnType(closure);
            GrExpression[] args = new GrExpression[allParameters.length];
            for (int i = 0; i < allParameters.length; ++i) {
                args[i] = factory.createExpressionFromText(allParameters[i].getName());
            }
            boolean singleParam = allParameters.length == 1;
            for (int param = allParameters.length; param >= 0; --param) {
                if (param < allParameters.length && !((GrParameter)actual.get(param)).isOptional() && !singleParam) continue;
                if (param < allParameters.length) {
                    GrParameter opt = (GrParameter)actual.remove(param);
                    GrExpression initializer = opt.getInitializerGroovy();
                    args[param] = initializer == null ? factory.createExpressionFromText("null") : initializer;
                }
                PsiParameter[] parameters = actual.toArray(new GrParameter[actual.size()]);
                GrClosureSignature signature = GrClosureSignatureUtil.createSignature(parameters, clReturnType);
                GrMethod pattern = factory.createMethodFromSignature(name, signature);
                PsiMethod found = null;
                if (psiClass != null) {
                    found = psiClass.findMethodBySignature((PsiMethod)pattern, true);
                }
                if (found != null) {
                    ModifierListGenerator.writeModifiers(builder, found.getModifierList(), ModifierListGenerator.JAVA_MODIFIERS_WITHOUT_ABSTRACT);
                } else {
                    builder.append("public ");
                }
                PsiType returnType = found != null ? substitutor.substitute(context.typeProvider.getReturnType(found)) : signature.getReturnType();
                TypeWriter.writeType(builder, returnType, operand);
                builder.append(' ').append(name);
                GenerationUtil.writeParameterList(builder, parameters, new GeneratorClassNameProvider(), context);
                ExpressionContext extended = context.extend();
                extended.setInAnonymousContext(true);
                if (param == allParameters.length) {
                    new CodeBlockGenerator(builder, extended).generateCodeBlock(allParameters, closure, false);
                    continue;
                }
                builder.append("{\n");
                ExpressionGenerator expressionGenerator = new ExpressionGenerator(builder, extended);
                GenerationUtil.invokeMethodByName(caller, name, args, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, expressionGenerator, arg);
                builder.append(";\n}\n");
            }
        }
        builder.append("}");
    }
}

