/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.modules.ModuleScriptData;
import org.jetbrains.kotlin.cli.common.modules.ModuleXmlParser;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.extensions.PreprocessedFileCreator;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.PathUtil;

public class CompileEnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(CompileEnvironmentUtil.class);

    @NotNull
    public static ModuleScriptData loadModuleDescriptions(String moduleDefinitionFile, MessageCollector messageCollector2) {
        File file2 = new File(moduleDefinitionFile);
        if (!file2.exists()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Module definition file does not exist: " + moduleDefinitionFile, null);
            return ModuleScriptData.EMPTY;
        }
        String extension = FileUtilRt.getExtension(moduleDefinitionFile);
        if ("xml".equalsIgnoreCase(extension)) {
            return ModuleXmlParser.parseModuleScript(moduleDefinitionFile, messageCollector2);
        }
        messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module definition type: " + moduleDefinitionFile, null);
        return ModuleScriptData.EMPTY;
    }

    private static void doWriteToJar(OutputFileCollection outputFiles, OutputStream fos, @Nullable FqName mainClass, boolean includeRuntime) {
        try {
            Manifest manifest2 = new Manifest();
            Attributes mainAttributes = manifest2.getMainAttributes();
            mainAttributes.putValue("Manifest-Version", "1.0");
            mainAttributes.putValue("Created-By", "JetBrains Kotlin");
            if (mainClass != null) {
                mainAttributes.putValue("Main-Class", mainClass.asString());
            }
            JarOutputStream stream2 = new JarOutputStream(fos, manifest2);
            for (OutputFile outputFile : outputFiles.asList()) {
                stream2.putNextEntry(new JarEntry(outputFile.getRelativePath()));
                stream2.write(outputFile.asByteArray());
            }
            if (includeRuntime) {
                CompileEnvironmentUtil.writeRuntimeToJar(stream2);
            }
            stream2.finish();
        }
        catch (IOException e) {
            throw new CompileEnvironmentException("Failed to generate jar file", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeToJar(File jarPath, boolean jarRuntime, FqName mainClass, OutputFileCollection outputFiles) {
        FileOutputStream outputStream2 = null;
        try {
            outputStream2 = new FileOutputStream(jarPath);
            CompileEnvironmentUtil.doWriteToJar(outputFiles, outputStream2, mainClass, jarRuntime);
            outputStream2.close();
        }
        catch (FileNotFoundException e) {
            try {
                throw new CompileEnvironmentException("Invalid jar path " + jarPath, e);
                catch (IOException e2) {
                    throw ExceptionUtilsKt.rethrow(e2);
                }
            }
            catch (Throwable throwable) {
                ExceptionUtilsKt.closeQuietly(outputStream2);
                throw throwable;
            }
        }
        ExceptionUtilsKt.closeQuietly(outputStream2);
    }

    private static void writeRuntimeToJar(JarOutputStream stream2) throws IOException {
        File stdlibPath = PathUtil.getKotlinPathsForCompiler().getStdlibPath();
        if (!stdlibPath.exists()) {
            throw new CompileEnvironmentException("Couldn't find kotlin-stdlib at " + stdlibPath);
        }
        CompileEnvironmentUtil.copyJarImpl(stream2, stdlibPath);
    }

    private static void copyJarImpl(JarOutputStream stream2, File jarPath) throws IOException {
        try (JarInputStream jis = new JarInputStream(new FileInputStream(jarPath));){
            JarEntry e;
            while ((e = jis.getNextJarEntry()) != null) {
                if (!FileUtilRt.extensionEquals(e.getName(), "class")) continue;
                stream2.putNextEntry(e);
                FileUtil.copy(jis, stream2);
            }
        }
    }

    @NotNull
    public static List<KtFile> getKtFiles(@NotNull Project project, @NotNull Collection<String> sourceRoots, @NotNull CompilerConfiguration configuration, @NotNull Function1<String, Unit> reportError2) throws IOException {
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        HashSet processedFiles = Sets.newHashSet();
        ArrayList<KtFile> result2 = Lists.newArrayList();
        PreprocessedFileCreator virtualFileCreator = new PreprocessedFileCreator(project);
        for (String sourceRootPath : sourceRoots) {
            if (sourceRootPath == null) continue;
            VirtualFile vFile = localFileSystem.findFileByPath(sourceRootPath);
            if (vFile == null) {
                String message = "Source file or directory not found: " + sourceRootPath;
                File buildFilePath = configuration.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath != null && Logger.isInitialized()) {
                    LOG.warn(message + "\n\nbuild file path: " + buildFilePath + "\ncontent:\n" + FileUtil.loadFile(buildFilePath));
                }
                reportError2.invoke(message);
                continue;
            }
            if (!vFile.isDirectory() && vFile.getFileType() != KotlinFileType.INSTANCE) {
                reportError2.invoke("Source entry is not a Kotlin file: " + sourceRootPath);
                continue;
            }
            SequencesKt.forEach(FilesKt.walkTopDown(new File(sourceRootPath)), file2 -> {
                if (file2.isFile()) {
                    VirtualFile virtualFile2;
                    VirtualFile originalVirtualFile = localFileSystem.findFileByPath(file2.getAbsolutePath());
                    VirtualFile virtualFile3 = virtualFile2 = originalVirtualFile != null ? virtualFileCreator.create(originalVirtualFile) : null;
                    if (virtualFile2 != null && !processedFiles.contains(virtualFile2)) {
                        processedFiles.add(virtualFile2);
                        PsiFile psiFile = PsiManager.getInstance(project).findFile(virtualFile2);
                        if (psiFile instanceof KtFile) {
                            result2.add((KtFile)psiFile);
                        }
                    }
                }
                return Unit.INSTANCE;
            });
        }
        return result2;
    }
}

