/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class IORoutines {
    public static final byte[] LINE_BREAK_BYTES = new byte[]{13, 10};

    public static String loadAsText(InputStream in, String encoding) throws IOException {
        return IORoutines.loadAsText(in, encoding, 4096);
    }

    public static String loadAsText(InputStream in, String encoding, int bufferSize) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, encoding);
        char[] buffer = new char[bufferSize];
        int offset = 0;
        while (true) {
            int numRead;
            int remain;
            if ((remain = buffer.length - offset) <= 0) {
                char[] newBuffer = new char[buffer.length * 2];
                System.arraycopy(buffer, 0, newBuffer, 0, offset);
                buffer = newBuffer;
                remain = buffer.length - offset;
            }
            if ((numRead = reader.read(buffer, offset, remain)) == -1) break;
            offset += numRead;
        }
        return new String(buffer, 0, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] load(File file) throws IOException {
        long fileLength = file.length();
        if (fileLength > Integer.MAX_VALUE) {
            throw new IOException("File '" + file.getName() + "' too big");
        }
        FileInputStream in = new FileInputStream(file);
        try {
            byte[] byArray = IORoutines.loadExact(in, (int)fileLength);
            return byArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static byte[] load(InputStream in) throws IOException {
        return IORoutines.load(in, 4096);
    }

    public static byte[] load(InputStream in, int initialBufferSize) throws IOException {
        if (initialBufferSize == 0) {
            initialBufferSize = 1;
        }
        byte[] buffer = new byte[initialBufferSize];
        int offset = 0;
        while (true) {
            int numRead;
            int remain;
            if ((remain = buffer.length - offset) <= 0) {
                int newSize = buffer.length * 2;
                byte[] newBuffer = new byte[newSize];
                System.arraycopy(buffer, 0, newBuffer, 0, offset);
                buffer = newBuffer;
                remain = buffer.length - offset;
            }
            if ((numRead = in.read(buffer, offset, remain)) == -1) break;
            offset += numRead;
        }
        if (offset < buffer.length) {
            byte[] newBuffer = new byte[offset];
            System.arraycopy(buffer, 0, newBuffer, 0, offset);
            buffer = newBuffer;
        }
        return buffer;
    }

    public static byte[] loadExact(InputStream in, int length) throws IOException {
        int remain;
        byte[] buffer = new byte[length];
        int offset = 0;
        while ((remain = length - offset) > 0) {
            int numRead = in.read(buffer, offset, remain);
            if (numRead == -1) {
                throw new IOException("Reached EOF, read " + offset + " expecting " + length);
            }
            offset += numRead;
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equalContent(File file, byte[] content) throws IOException {
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File '" + file + "' too big");
        }
        FileInputStream in = new FileInputStream(file);
        try {
            byte[] fileContent = IORoutines.loadExact(in, (int)length);
            boolean bl = Arrays.equals(content, fileContent);
            return bl;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static void save(File file, byte[] content) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(content);
        }
        finally {
            out.close();
        }
    }

    public static String readLine(InputStream in) throws IOException {
        int b;
        StringBuffer sb = null;
        block4: while ((b = in.read()) != -1) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            switch (b) {
                case 10: {
                    break block4;
                }
                case 13: {
                    continue block4;
                }
                default: {
                    sb.append((char)b);
                    continue block4;
                }
            }
        }
        return sb == null ? null : sb.toString();
    }

    public static void touch(File file) {
        file.setLastModified(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStrings(File file, Collection list) throws IOException {
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(file));
        try {
            PrintWriter writer = new PrintWriter(bout);
            for (String text : list) {
                writer.println(text);
            }
            writer.flush();
            writer.close();
        }
        finally {
            bout.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadStrings(File file) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        FileInputStream in = new FileInputStream(file);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            LinkedList<String> linkedList = list;
            return linkedList;
        }
        finally {
            ((InputStream)in).close();
        }
    }
}

