/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.TraceNodeRunConfigurationEditor;
import com.intellij.javascript.trace.execution.TraceNodeRunConfigurationSettings;
import com.intellij.javascript.trace.execution.TraceNodeSettingsSerializationUtil;
import com.intellij.javascript.trace.execution.TraceProfileState;
import com.intellij.javascript.trace.execution.TraceRunConfiguration;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class TraceNodeConfiguration
extends TraceRunConfiguration
implements RunConfigurationWithSuppressedDefaultRunAction,
RefactoringListenerProvider {
    public static final int DEFAULT_TRACE_SERVER_PORT = 3547;
    private TraceNodeRunConfigurationSettings mySettings;
    private VirtualFile myConfigFile;

    public TraceNodeConfiguration(Project project, @NotNull ConfigurationFactory factory, String name) {
        if (factory == null) {
            TraceNodeConfiguration.$$$reportNull$$$0(0);
        }
        super(project, factory, name);
        this.mySettings = new TraceNodeRunConfigurationSettings(3547, "", null, NodeJsInterpreterRef.createProjectRef(), "", StringUtil.notNullize((String)project.getBasePath()), "", "", (Map<String, String>)new com.intellij.util.containers.HashMap(), true);
    }

    @Override
    @NotNull
    public JSONObject getConfigJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("path", this.mySettings.getConfigPath());
        if (this.mySettings.getTraceLimits() != null) {
            this.mySettings.getTraceLimits().addToConfigJson(values);
        }
        JSONObject jSONObject = new JSONObject(values);
        if (jSONObject == null) {
            TraceNodeConfiguration.$$$reportNull$$$0(1);
        }
        return jSONObject;
    }

    @Override
    @NotNull
    public GeneralCommandLine createCommandLine() throws ExecutionException {
        NodeJsLocalInterpreter interpreter = this.mySettings.getNodeInterpreterRef().resolveAsLocal(this.getProject());
        GeneralCommandLine commandLine = new GeneralCommandLine();
        String debugPortStr = System.getenv("DEBUG_SPY_JS");
        boolean useSource = !StringUtil.isEmpty((String)debugPortStr);
        commandLine.withEnvironment(this.mySettings.getEnv());
        commandLine.withParentEnvironmentType(this.mySettings.isPassParentEnv() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        commandLine.withWorkDirectory(this.mySettings.getWorkingDir());
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        String nodeOptions = this.mySettings.getNodeParams().trim();
        if (StringUtil.isNotEmpty((String)nodeOptions)) {
            commandLine.addParameters(ParametersList.parse((String)nodeOptions));
        }
        commandLine.addParameter(Utils.getServerScriptPath("spyNode.js", !useSource));
        commandLine.addParameter("--spyJsServerPort=" + this.getProxyPort());
        commandLine.addParameter("--spyJsTracedApp=" + this.mySettings.getAppFile().getAbsolutePath());
        commandLine.addParameter("--spyJsChildProc=false");
        String appOptions = this.mySettings.getAppParams().trim();
        if (StringUtil.isNotEmpty((String)appOptions)) {
            commandLine.addParameters(ParametersList.parse((String)appOptions));
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            TraceNodeConfiguration.$$$reportNull$$$0(2);
        }
        return generalCommandLine;
    }

    @Override
    public void configurationStarted(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            TraceNodeConfiguration.$$$reportNull$$$0(3);
        }
        UsageTrigger.trigger((String)"spy.js.node.rc.start");
        super.configurationStarted(processHandler);
    }

    @Override
    @Nullable
    public VirtualFile getConfigFile() {
        if (!StringUtil.isEmpty((String)this.mySettings.getConfigPath()) && this.myConfigFile == null) {
            this.myConfigFile = VfsUtil.findFileByIoFile((File)new File(this.mySettings.getConfigPath()), (boolean)false);
        }
        return this.myConfigFile;
    }

    @Override
    public int getProxyPort() {
        return this.mySettings.getProxyPort();
    }

    @NotNull
    public TraceNodeRunConfigurationSettings getTraceSettings() {
        TraceNodeRunConfigurationSettings traceNodeRunConfigurationSettings = this.mySettings;
        if (traceNodeRunConfigurationSettings == null) {
            TraceNodeConfiguration.$$$reportNull$$$0(4);
        }
        return traceNodeRunConfigurationSettings;
    }

    public void setTraceSettings(@NotNull TraceNodeRunConfigurationSettings settings) {
        if (settings == null) {
            TraceNodeConfiguration.$$$reportNull$$$0(5);
        }
        this.mySettings = settings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        TraceNodeRunConfigurationEditor traceNodeRunConfigurationEditor = new TraceNodeRunConfigurationEditor(this.getProject());
        if (traceNodeRunConfigurationEditor == null) {
            TraceNodeConfiguration.$$$reportNull$$$0(6);
        }
        return traceNodeRunConfigurationEditor;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        File config;
        NodeJsInterpreter interpreter = this.mySettings.getNodeInterpreterRef().resolve(this.getProject());
        NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        String workingDirPath = this.mySettings.getWorkingDir();
        if (StringUtil.isEmptyOrSpaces((String)workingDirPath)) {
            throw new RuntimeConfigurationError(TraceBundle.message("configuration.validation.incorrectWorkingDirPath", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.mySettings.getAppPath())) {
            throw new RuntimeConfigurationError(TraceBundle.message("configuration.validation.emptyAppPath", new Object[0]));
        }
        File app = this.mySettings.getAppFile();
        if (!(app.isFile() && app.isAbsolute() && app.exists())) {
            throw new RuntimeConfigurationError(TraceBundle.message("configuration.validation.incorrectAppPath", new Object[0]));
        }
        String configPath = this.mySettings.getConfigPath();
        if (!(StringUtil.isEmptyOrSpaces((String)configPath) || (config = new File(configPath)).isFile() && config.exists())) {
            throw new RuntimeConfigurationError(TraceBundle.message("configuration.validation.incorrectConfigPath", new Object[0]));
        }
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            TraceNodeConfiguration.$$$reportNull$$$0(7);
        }
        if (env == null) {
            TraceNodeConfiguration.$$$reportNull$$$0(8);
        }
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
            // empty catch block
        }
        return new TraceProfileState(this.getProject(), env);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            TraceNodeConfiguration.$$$reportNull$$$0(9);
        }
        super.readExternal(element);
        this.setTraceSettings(TraceNodeSettingsSerializationUtil.readFromXml(element));
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            TraceNodeConfiguration.$$$reportNull$$$0(10);
        }
        super.writeExternal(element);
        TraceNodeSettingsSerializationUtil.writeToXml(element, this.getTraceSettings());
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (StringUtil.isEmpty((String)this.mySettings.getConfigPath())) {
            return null;
        }
        VirtualFile file = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        String configPath = FileUtil.toSystemIndependentName((String)this.mySettings.getConfigPath());
        if (configPath.equals(path)) {
            return new UndoRefactoringElementAdapter(){

                protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
                    VirtualFile newFile;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((newFile = PsiUtilBase.asVirtualFile((PsiElement)element)) != null) {
                        String newPath = FileUtil.toSystemDependentName((String)newFile.getPath());
                        TraceNodeConfiguration.this.setTraceSettings(new TraceNodeRunConfigurationSettings(TraceNodeConfiguration.this.mySettings.getProxyPort(), newPath, TraceNodeConfiguration.this.mySettings.getTraceLimits(), TraceNodeConfiguration.this.mySettings.getNodeInterpreterRef(), TraceNodeConfiguration.this.mySettings.getNodeParams(), TraceNodeConfiguration.this.mySettings.getWorkingDir(), TraceNodeConfiguration.this.mySettings.getAppPath(), TraceNodeConfiguration.this.mySettings.getAppParams(), TraceNodeConfiguration.this.mySettings.getEnv(), TraceNodeConfiguration.this.mySettings.isPassParentEnv()));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/trace/execution/TraceNodeConfiguration$1", "refactored"));
                }
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/TraceNodeConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/TraceNodeConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigJson";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configurationStarted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTraceSettings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

