/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.ui.SameHeightPanel;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.EventsToolbarPanel;
import com.intellij.javascript.trace.execution.StackToolbarPanel;
import com.intellij.javascript.trace.execution.TraceConsoleProperties;
import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.common.ContextMetadata;
import com.intellij.javascript.trace.execution.common.EventDataReceivedHandler;
import com.intellij.javascript.trace.execution.common.EventDataReceivingHandler;
import com.intellij.javascript.trace.execution.common.EventMetadataExtended;
import com.intellij.javascript.trace.execution.common.EventStreamChangeType;
import com.intellij.javascript.trace.execution.common.EventStreamCommand;
import com.intellij.javascript.trace.execution.common.FileLoadedHandler;
import com.intellij.javascript.trace.execution.common.OriginalTraceVirtualFile;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.common.RuntimeStatement;
import com.intellij.javascript.trace.execution.common.SessionRunning;
import com.intellij.javascript.trace.execution.common.StackEntryBase;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.javascript.trace.execution.context.ContextTree;
import com.intellij.javascript.trace.execution.context.StackFrameContext;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventStreamNode;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.javascript.trace.execution.search.TraceNavigator;
import com.intellij.javascript.trace.execution.search.TraceSearch;
import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.javascript.trace.execution.stack.StackTree;
import com.intellij.javascript.trace.execution.stack.StackTreeStructure;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TracePanel
extends JPanel
implements TraceContext,
Disposable {
    private RunConfiguration myRunConfiguration;
    private ExecutionEnvironment myEnvironment;
    private TraceSession myTraceSession;
    private TraceConsoleProperties myProperties;
    private ConsoleView myConsole;
    private ContextTree myContextTree;
    private JScrollPane myEventsPane;
    private JScrollPane myStackPane;
    private JScrollPane myContextPane;
    private EventNode mySelectedEventNode;
    private StackFrameContext myContext;
    private EventTree myEventTree;
    private StackTree myStackTree;
    private MyEventGettingRequest myEventGettingRequest;
    private TraceProjectSettings.EventFilterState myActiveFilter = TraceProjectSettings.EventFilterState.NULL_FILTER;
    private static final Logger LOG = Logger.getInstance(TracePanel.class);
    private Timer myEventLoadingLabelTimer;
    private Timer myStackUpdateTimer;
    private SimpleNode myLastSelectedNode;
    private TraceSettingsManager myTraceSettingsManager;
    private TraceSearch myTraceSearch;
    private TraceNavigator myTraceNavigator;
    private Function<StackNode[], StackNode> myStackNodeSelector;
    private SessionRunning myIsSessionRunning = new SessionRunning(){

        @Override
        public boolean isRunning() {
            return TracePanel.this.myTraceSession.isRunning();
        }
    };

    public TracePanel(RunConfiguration runConfiguration, ExecutionEnvironment environment, TraceSession traceSession, TraceConsoleProperties properties, ConsoleView console) {
        super(new BorderLayout(0, 1));
        this.myRunConfiguration = runConfiguration;
        this.myEnvironment = environment;
        this.myTraceSession = traceSession;
        this.myProperties = properties;
        this.myConsole = console;
        this.myTraceSearch = new TraceSearch(this);
        this.myTraceNavigator = new TraceNavigator(this);
        Runnable cancelEventRetrieval = () -> {
            if (this.myEventGettingRequest != null) {
                this.myEventGettingRequest.cancel();
            }
            if (this.myStackTree == null) {
                this.cleanUpStackAndContext();
            }
        };
        traceSession.onError((Consumer<Exception>)((Consumer)error -> cancelEventRetrieval.run()));
        traceSession.onSessionStopped(cancelEventRetrieval);
        this.myEventLoadingLabelTimer = UIUtil.createNamedTimer((String)"TracePanelEvenLoading", (int)300, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (TracePanel.this.myEventGettingRequest != null) {
                    TracePanel.this.setEventLoadingMessageToStackPanel();
                }
            }
        });
        this.myEventLoadingLabelTimer.setRepeats(false);
    }

    private void cleanUpStackAndContext() {
        this.cleanUpStackTreeResources();
        this.cleanUpContextTreeResources();
        this.myContextPane.setViewportView(this.createContextTreeView());
    }

    public void dispose() {
        if (this.myEventGettingRequest != null) {
            this.myEventGettingRequest.cancel();
        }
        this.cleanUpStackTreeResources();
        this.cleanUpEventTreeResources();
        this.cleanUpContextTreeResources();
    }

    public void initUI() {
        this.myTraceSettingsManager = new TraceSettingsManager(this.myRunConfiguration.getProject(), this.myProperties);
        this.myTraceSettingsManager.addSettingsConsumer((Consumer<TraceSettings>)((Consumer)settings -> {
            this.myActiveFilter = settings.getFilter();
            this.myTraceSession.applySettings((TraceSettings)settings);
            if (settings.isRealtimeEvaluationEnabled()) {
                ValueLookupManager.getInstance((Project)this.myRunConfiguration.getProject()).startListening();
            }
        }));
        this.myEventsPane = ScrollPaneFactory.createScrollPane();
        this.myEventsPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 6);
        this.myEventTree = this.createEventsTreeView();
        this.myStackPane = ScrollPaneFactory.createScrollPane();
        this.myStackPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 7);
        this.myContextPane = ScrollPaneFactory.createScrollPane();
        this.myContextPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 3);
        this.myTraceSettingsManager.applySettings();
        EventsToolbarPanel eventsToolbarPanel = new EventsToolbarPanel(this.myRunConfiguration.getProject(), this.myProperties, this, this.myEventTree, () -> this.clear(true, true), this);
        StackToolbarPanel stackToolbarPanel = new StackToolbarPanel(this);
        final Splitter rightSplitter = new Splitter();
        rightSplitter.setFirstComponent((JComponent)this.myStackPane);
        rightSplitter.setSecondComponent((JComponent)this.myContextPane);
        rightSplitter.setHonorComponentsMinimumSize(false);
        rightSplitter.setProportion(0.6f);
        final JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)rightSplitter, "Center");
        rightPanel.add((Component)SameHeightPanel.wrap((JComponent)stackToolbarPanel, (JComponent)eventsToolbarPanel), "North");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.myEventsPane, "Center");
        leftPanel.add((Component)eventsToolbarPanel, "North");
        final Splitter splitter = new Splitter();
        splitter.setFirstComponent((JComponent)leftPanel);
        splitter.setSecondComponent((JComponent)rightPanel);
        splitter.setHonorComponentsMinimumSize(false);
        splitter.setProportion(0.25f);
        this.add((Component)splitter, "Center");
        this.myContextPane.setViewportView(this.createContextTreeView());
        this.myEventsPane.setViewportView((Component)((Object)this.myEventTree));
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                rightPanel.remove((Component)rightSplitter);
                rightSplitter.dispose();
                TracePanel.this.remove((Component)splitter);
                splitter.dispose();
            }
        });
        this.myTraceSession.onNewEvent(this);
        this.myTraceSession.onNewContext(this);
        this.myTraceSession.onContextChanged(this);
    }

    private void clear(boolean clearEventTreeCache, boolean clearConsole) {
        if (this.myEventGettingRequest != null) {
            this.myEventGettingRequest.cancel();
        }
        if (clearConsole) {
            this.myConsole.clear();
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            this.cleanUpStackAndContext();
            this.myEventTree.clear(false, clearEventTreeCache);
        });
    }

    private EventTree createEventsTreeView() {
        final EventTree treeView = new EventTree(this, this.myIsSessionRunning, this.myTraceSession.isNodeJsSession());
        if (this.myStackUpdateTimer != null) {
            this.myStackUpdateTimer.stop();
        }
        this.myStackUpdateTimer = UIUtil.createNamedTimer((String)"TracePanelEventsTree", (int)50, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TracePanel.this.performStackUpdate(treeView);
            }
        });
        treeView.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                TracePanel.this.myStackUpdateTimer.restart();
            }
        });
        treeView.addEventStreamInterruptedNodeSelectionHandler(() -> {
            this.cleanUpStackAndContext();
            this.setInterruptedEventStreamMessageToStackPanel();
        });
        treeView.addEventStreamLabelNodeSelectionHandler(() -> {
            this.cleanUpStackAndContext();
            this.setLabelEventStreamMessageToStackPanel();
        });
        treeView.addTraceCloseRequestedHandler((Consumer<EventStreamNode>)((Consumer)eventStreamNode -> {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myRunConfiguration.getProject());
            for (TraceVirtualFile file : this.myTraceSession.getLoadedTracedSourceFiles(eventStreamNode.getStreamId())) {
                fileEditorManager.closeFile((VirtualFile)file);
            }
        }));
        treeView.addBrowserCommandHandler((Consumer<EventStreamCommand>)((Consumer)command -> this.myTraceSession.executeInBrowser((EventStreamCommand)command)));
        return treeView;
    }

    @Override
    public boolean isLoadingStackTrace() {
        return this.myEventGettingRequest != null;
    }

    private void performStackUpdate(EventTree treeView) {
        SimpleNode selectedNode = treeView.getSelectedNode();
        if (selectedNode != null && selectedNode.equals((Object)this.myLastSelectedNode)) {
            return;
        }
        this.myLastSelectedNode = selectedNode;
        this.cleanUpStackAndContext();
        if (this.myEventGettingRequest != null) {
            this.myEventGettingRequest.cancel();
            this.myEventGettingRequest = null;
        }
        if (selectedNode instanceof EventNode) {
            this.myEventLoadingLabelTimer.restart();
            this.myEventGettingRequest = new MyEventGettingRequest(this.myRunConfiguration.getProject(), this.myTraceSession, this.myActiveFilter);
            EventNode eventNode = (EventNode)selectedNode;
            if (!this.myEventGettingRequest.start(eventNode, (Consumer<StackTreeStructure>)((Consumer)structure -> {
                this.mySelectedEventNode = eventNode;
                if (structure.getAllNodes().length > 0) {
                    this.myStackTree = this.createStackTreeView((StackTreeStructure)((Object)structure));
                    this.myStackPane.setViewportView((Component)((Object)this.myStackTree));
                } else {
                    this.setEmptyStackMessageToStackPanel();
                    if (this.myStackNodeSelector != null) {
                        this.myStackNodeSelector.fun((Object)new StackNode[0]);
                        this.myStackNodeSelector = null;
                    }
                }
                this.myEventGettingRequest = null;
                this.myEventLoadingLabelTimer.stop();
            }))) {
                this.myEventGettingRequest = null;
            }
        } else if (this.myStackNodeSelector == null) {
            this.myTraceSearch.reset();
        }
    }

    private void setEmptyStackMessageToStackPanel() {
        this.setStackPanelLabel(TraceBundle.message("console.trace.events.emptyStack", new Object[0]));
    }

    private void setEventLoadingMessageToStackPanel() {
        this.setStackPanelLabel(TraceBundle.message("console.trace.events.eventIsLoading", new Object[0]));
    }

    private void setStackPanelLabel(String text) {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(text);
        label.setBorder(new EmptyBorder(0, 25, 0, 25));
        panel.add((Component)label, new GridBagConstraints());
        this.myStackPane.setViewportView(panel);
    }

    private void setInterruptedEventStreamMessageToStackPanel() {
        this.setStackPanelLabel(TraceBundle.message("console.trace.events.eventContextInterrupted", new Object[0]));
    }

    private void setLabelEventStreamMessageToStackPanel() {
        this.setStackPanelLabel(TraceBundle.message("console.trace.events.eventContextLabel", new Object[0]));
    }

    private StackTree createStackTreeView(@NotNull StackTreeStructure stackTreeStructure) {
        if (stackTreeStructure == null) {
            TracePanel.$$$reportNull$$$0(0);
        }
        this.cleanUpStackTreeResources();
        final StackTree treeView = new StackTree(stackTreeStructure, this);
        if (this.myStackNodeSelector != null) {
            treeView.setSelected((StackNode)((Object)this.myStackNodeSelector.fun((Object)treeView.getAllNodes())));
            this.myStackNodeSelector = null;
        }
        treeView.addStackNodeTraceRequestHandler((Consumer<StackNode>)((Consumer)node -> this.myTraceSession.getTracedSourceFile(node.getScope(), this, false)));
        treeView.addStackNodeMappedTraceRequestedHandler((Consumer<StackNode>)((Consumer)node -> this.myTraceSession.getTracedSourceFile(node.getScope(), this, true)));
        treeView.addStackNodeSelectedHandler((Consumer<StackNode>)((Consumer)node -> this.myTraceSession.getTracedSourceFile(node.getScope(), this, this.myProperties.alwaysOpenMappedTraceIfAvailable())));
        treeView.addStackNodeCallerTraceRequestHandler((Consumer<StackNode>)((Consumer)node -> {
            StackNode caller = node.getParentStackNode();
            final RuntimeFunctionScope nodeScope = node.getScope();
            if (caller == null) {
                return;
            }
            final StackFrameContext context = StackFrameContext.create(this.myContext, caller);
            final RuntimeFunctionScope callerScope = caller.getScope();
            this.myTraceSession.getTracedSourceFile(callerScope, new FileLoadedHandler(){

                @Override
                public void fileLoaded(OriginalTraceVirtualFile file, RuntimeFunctionScope functionScope, boolean useMappedSourceIfAvailable) {
                    TraceVirtualFile fileToDisplay = file.getFileToDisplay(context, useMappedSourceIfAvailable);
                    fileToDisplay.setContext(context);
                    TracePanel.openTraceFile(TracePanel.this.myRunConfiguration.getProject(), fileToDisplay, nodeScope.getCallerStatement(callerScope));
                }
            }, this.myProperties.alwaysOpenMappedTraceIfAvailable());
        }));
        treeView.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                StackNode selectedNode = (StackNode)treeView.getSelectedNode();
                if (selectedNode != null && selectedNode.getScope() != null) {
                    TracePanel.this.myContext = StackFrameContext.create(TracePanel.this.mySelectedEventNode, selectedNode);
                    TracePanel.this.myContextTree.updateContext(TracePanel.this.myContext);
                    if (TracePanel.this.myProperties.getAutoScrollToTrace()) {
                        TracePanel.this.myStackTree.stackNodeSelected(selectedNode);
                    }
                }
            }
        });
        treeView.addSourceRequestedHandler((Consumer<StackNode>)((Consumer)stackNode -> this.myTraceSession.getTracedSourceFile(stackNode.getScope(), new FileLoadedHandler(){

            @Override
            public void fileLoaded(OriginalTraceVirtualFile file, RuntimeFunctionScope functionScope, boolean useMappedSourceIfAvailable) {
                if (!TracePanel.this.myContext.getStackFrame().equals(functionScope)) {
                    return;
                }
                TraceVirtualFile traceFile = file.getFileToDisplay(TracePanel.this.myContext, useMappedSourceIfAvailable);
                traceFile.setContext(TracePanel.this.myContext);
                VirtualFile localFile = traceFile.getProjectFile();
                TracePanel.openFile(TracePanel.this.myRunConfiguration.getProject(), (VirtualFile)(localFile != null ? localFile : traceFile), (Consumer<Editor[]>)editors -> {
                    for (Editor editor : editors) {
                        TextRange activeRange = traceFile.getFunctionRange(editor, functionScope);
                        if (activeRange == TextRange.EMPTY_RANGE) continue;
                        editor.getScrollingModel().scrollTo(TracePanel.getScrollPosition(editor.getDocument(), activeRange), ScrollType.CENTER);
                    }
                });
            }
        }, this.myProperties.alwaysOpenMappedTraceIfAvailable())));
        return treeView;
    }

    private Component createContextTreeView() {
        this.myContextTree = new ContextTree(this.myEnvironment.getProject());
        return this.myContextTree;
    }

    private void cleanUpEventTreeResources() {
        this.myEventsPane.setViewportView(null);
        if (this.myEventTree != null) {
            Disposer.dispose((Disposable)this.myEventTree);
        }
    }

    private void cleanUpStackTreeResources() {
        this.myStackPane.setViewportView(null);
        if (this.myStackTree != null) {
            Disposer.dispose((Disposable)this.myStackTree);
        }
        if (this.myEventLoadingLabelTimer != null) {
            this.myEventLoadingLabelTimer.stop();
        }
        if (this.myStackUpdateTimer != null) {
            this.myStackUpdateTimer.stop();
        }
        this.myStackTree = null;
    }

    private void cleanUpContextTreeResources() {
        this.myContextPane.setViewportView(null);
        Disposer.dispose((Disposable)this.myContextTree);
    }

    @Override
    public void newEventStreamAdded(@NotNull ContextMetadata context) {
        if (context == null) {
            TracePanel.$$$reportNull$$$0(1);
        }
        if (this.myEventTree != null) {
            this.myEventTree.addEventStream(context);
        }
    }

    @Override
    public void eventStreamChanged(@NotNull String streamId, @NotNull EventStreamChangeType change) {
        if (streamId == null) {
            TracePanel.$$$reportNull$$$0(2);
        }
        if (change == null) {
            TracePanel.$$$reportNull$$$0(3);
        }
        if (this.myEventTree != null) {
            if (change == EventStreamChangeType.INTERRUPTED) {
                this.myEventTree.interruptEventStream(streamId);
            }
            if (change == EventStreamChangeType.EXPIRED) {
                this.myEventTree.expireEventStream(streamId);
            }
            if (change == EventStreamChangeType.ACTIVATED) {
                this.myEventTree.activateEventStream(streamId);
            }
        }
    }

    @Override
    public void eventMetadataReceived(EventMetadataExtended metadata) {
        if (this.myEventTree != null) {
            this.myEventTree.eventMetadataReceived(metadata);
            this.myTraceNavigator.resetCache();
        }
    }

    @Override
    public void fileLoaded(OriginalTraceVirtualFile file, RuntimeFunctionScope functionScope, boolean useMappedSourceIfAvailable) {
        if (!this.myContext.getStackFrame().equals(functionScope)) {
            return;
        }
        TraceVirtualFile fileToDisplay = file.getFileToDisplay(this.myContext, useMappedSourceIfAvailable);
        fileToDisplay.setContext(this.myContext);
        TracePanel.openTraceFile(this.myRunConfiguration.getProject(), fileToDisplay, null);
    }

    private static void openTraceFile(@NotNull Project project, @NotNull TraceVirtualFile file, @Nullable RuntimeStatement elementToSelect) {
        if (project == null) {
            TracePanel.$$$reportNull$$$0(4);
        }
        if (file == null) {
            TracePanel.$$$reportNull$$$0(5);
        }
        TracePanel.openFile(project, (VirtualFile)file, (Consumer<Editor[]>)((Consumer)editors -> {
            if (file == null) {
                TracePanel.$$$reportNull$$$0(24);
            }
            for (Editor editor : editors) {
                TextRange selectRange;
                if (elementToSelect != null && (selectRange = file.getStatementRange(editor, file.getCurrentContext().getStackFrame(), elementToSelect.getCodeElement())) != TextRange.EMPTY_RANGE) {
                    editor.getSelectionModel().setSelection(selectRange.getStartOffset(), selectRange.getEndOffset());
                    editor.getScrollingModel().scrollTo(TracePanel.getScrollPosition(editor.getDocument(), selectRange), ScrollType.CENTER);
                    return;
                }
                editor.getSelectionModel().removeSelection();
                TextRange activeRange = file.getCurrentScopeApproxRange(editor);
                if (activeRange == TextRange.EMPTY_RANGE) continue;
                editor.getScrollingModel().scrollTo(TracePanel.getScrollPosition(editor.getDocument(), activeRange), ScrollType.CENTER);
            }
        }));
    }

    @NotNull
    private static CodeRange getCodeRange(@NotNull Document document, @NotNull TextRange range) {
        if (document == null) {
            TracePanel.$$$reportNull$$$0(6);
        }
        if (range == null) {
            TracePanel.$$$reportNull$$$0(7);
        }
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int startLine = document.getLineNumber(startOffset);
        int startColumn = startOffset - document.getLineStartOffset(startLine);
        int endLine = document.getLineNumber(endOffset);
        int endColumn = endOffset - document.getLineStartOffset(endLine);
        CodeRange codeRange = new CodeRange(startLine, endLine, startColumn, endColumn);
        if (codeRange == null) {
            TracePanel.$$$reportNull$$$0(8);
        }
        return codeRange;
    }

    @NotNull
    private static LogicalPosition getScrollPosition(@NotNull Document document, @NotNull TextRange textRange) {
        if (document == null) {
            TracePanel.$$$reportNull$$$0(9);
        }
        if (textRange == null) {
            TracePanel.$$$reportNull$$$0(10);
        }
        CodeRange range = TracePanel.getCodeRange(document, textRange);
        LogicalPosition logicalPosition = TracePanel.getScrollPosition(range);
        if (logicalPosition == null) {
            TracePanel.$$$reportNull$$$0(11);
        }
        return logicalPosition;
    }

    @NotNull
    private static LogicalPosition getScrollPosition(@NotNull CodeRange range) {
        if (range == null) {
            TracePanel.$$$reportNull$$$0(12);
        }
        LogicalPosition logicalPosition = range.getRowStart() == range.getRowEnd() ? new LogicalPosition(range.getRowStart(), Math.min(range.getColStart() + 120, range.getColEnd())) : new LogicalPosition(range.getRowStart(), range.getColStart());
        if (logicalPosition == null) {
            TracePanel.$$$reportNull$$$0(13);
        }
        return logicalPosition;
    }

    private static void openFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull Consumer<Editor[]> openedEditorsConsumer) {
        if (project == null) {
            TracePanel.$$$reportNull$$$0(14);
        }
        if (file == null) {
            TracePanel.$$$reportNull$$$0(15);
        }
        if (openedEditorsConsumer == null) {
            TracePanel.$$$reportNull$$$0(16);
        }
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, file);
        openFileDescriptor.navigate(false);
        FileEditor[] editors = FileEditorManager.getInstance((Project)project).getAllEditors(file);
        ArrayList<Editor> openedEditors = new ArrayList<Editor>();
        if (editors.length > 0) {
            for (FileEditor editor : editors) {
                TextEditor textEditor = (TextEditor)editor;
                openFileDescriptor.navigateIn(textEditor.getEditor());
                openedEditors.add(textEditor.getEditor());
            }
        }
        try {
            openedEditorsConsumer.consume((Object)openedEditors.toArray(new Editor[openedEditors.size()]));
        }
        catch (Exception ex) {
            LOG.warn((Throwable)ex);
        }
    }

    @Override
    @NotNull
    public TraceSession getTraceSession() {
        TraceSession traceSession = this.myTraceSession;
        if (traceSession == null) {
            TracePanel.$$$reportNull$$$0(17);
        }
        return traceSession;
    }

    @Override
    @NotNull
    public TraceSearch getTraceSearch() {
        TraceSearch traceSearch = this.myTraceSearch;
        if (traceSearch == null) {
            TracePanel.$$$reportNull$$$0(18);
        }
        return traceSearch;
    }

    @Override
    @NotNull
    public TraceNavigator getTraceNavigator() {
        TraceNavigator traceNavigator = this.myTraceNavigator;
        if (traceNavigator == null) {
            TracePanel.$$$reportNull$$$0(19);
        }
        return traceNavigator;
    }

    @Override
    @NotNull
    public TraceSettingsManager getTraceSettingsManager() {
        TraceSettingsManager traceSettingsManager = this.myTraceSettingsManager;
        if (traceSettingsManager == null) {
            TracePanel.$$$reportNull$$$0(20);
        }
        return traceSettingsManager;
    }

    @Override
    public void select(@NotNull EventNode eventNode, @NotNull Function<StackNode[], StackNode> stackNodeSelector) {
        if (eventNode == null) {
            TracePanel.$$$reportNull$$$0(21);
        }
        if (stackNodeSelector == null) {
            TracePanel.$$$reportNull$$$0(22);
        }
        if (this.myEventTree != null) {
            if (this.myLastSelectedNode == eventNode && this.myStackTree != null) {
                this.myStackTree.setSelected((StackNode)((Object)stackNodeSelector.fun((Object)this.myStackTree.getAllNodes())));
            } else {
                this.myStackNodeSelector = stackNodeSelector;
                this.myEventTree.setSelected(eventNode);
            }
        }
    }

    @Override
    @Nullable
    public StackTree getCurrentStackTree() {
        return this.myStackTree;
    }

    @Override
    @Nullable
    public EventTree getCurrentEventTree() {
        return this.myEventTree;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProperties.getProject();
        if (project == null) {
            TracePanel.$$$reportNull$$$0(23);
        }
        return project;
    }

    @Override
    public void activateToolWindow() {
        ExecutionManager executionManager = ExecutionManager.getInstance((Project)this.myEnvironment.getProject());
        RunContentDescriptor contentDescriptor = this.myEnvironment.getContentToReuse();
        executionManager.getContentManager().toFrontRunContent(DefaultRunExecutor.getRunExecutorInstance(), contentDescriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTreeStructure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/TracePanel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openedEditorsConsumer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventNode";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackNodeSelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/TracePanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeRange";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollPosition";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceSession";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceSearch";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceNavigator";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceSettingsManager";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStackTreeView";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "newEventStreamAdded";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "eventStreamChanged";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openTraceFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCodeRange";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getScrollPosition";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openTraceFile$15";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEventGettingRequest
    implements EventDataReceivingHandler,
    EventDataReceivedHandler {
        private Project myProject;
        private TraceSession mySession;
        private TraceProjectSettings.EventFilterState myActiveFilter;
        private ProgressIndicator myEventPreparingIndicator;
        private final Semaphore myEventPreparingLock;
        private Runnable myCancelDelegate;
        private StackEntryBase[] myEntries;
        private volatile boolean myIsCancelled;

        public MyEventGettingRequest(@NotNull Project project, @NotNull TraceSession session, @NotNull TraceProjectSettings.EventFilterState activeFilter) {
            if (project == null) {
                MyEventGettingRequest.$$$reportNull$$$0(0);
            }
            if (session == null) {
                MyEventGettingRequest.$$$reportNull$$$0(1);
            }
            if (activeFilter == null) {
                MyEventGettingRequest.$$$reportNull$$$0(2);
            }
            this.myActiveFilter = TraceProjectSettings.EventFilterState.NULL_FILTER;
            this.myEventPreparingLock = new Semaphore();
            this.myCancelDelegate = () -> {};
            this.myEntries = new StackEntryBase[0];
            this.myProject = project;
            this.mySession = session;
            this.myActiveFilter = activeFilter;
        }

        public void cancel() {
            this.myCancelDelegate.run();
            this.myIsCancelled = true;
            this.myEventPreparingLock.up();
        }

        public boolean start(final EventNode eventNode, final Consumer<StackTreeStructure> requestFinished) {
            if (!this.mySession.isRunning()) {
                return false;
            }
            this.myEventPreparingLock.down();
            this.myCancelDelegate = this.mySession.getEvent(eventNode.getEvent(), this, this);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, TraceBundle.message("console.trace.stack.loading", new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (myIsCancelled) {
                        return;
                    }
                    myEventPreparingIndicator = indicator;
                    myEventPreparingIndicator.setFraction(0.0);
                    myEventPreparingLock.waitFor();
                    if (!myIsCancelled) {
                        StackTreeStructure stackTreeStructure = new StackTreeStructure(myEntries, eventNode.getEvent(), myActiveFilter);
                        MyEventGettingRequest.access$1302(this, null);
                        myEventPreparingIndicator.setFraction(1.0);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (myIsCancelled) {
                                return;
                            }
                            requestFinished.consume((Object)stackTreeStructure);
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/trace/execution/TracePanel$MyEventGettingRequest$1", "run"));
                }
            });
            return true;
        }

        @Override
        public void eventDataReceiving(double progress) {
            if (this.myIsCancelled) {
                return;
            }
            if (this.myEventPreparingIndicator != null) {
                this.myEventPreparingIndicator.setFraction(progress);
            }
        }

        @Override
        public void eventDataReceived(StackEntryBase[] stackEntries) {
            if (this.myIsCancelled) {
                return;
            }
            this.myEntries = stackEntries;
            this.myEventPreparingLock.up();
        }

        static /* synthetic */ StackEntryBase[] access$1302(MyEventGettingRequest x0, StackEntryBase[] x1) {
            x0.myEntries = x1;
            return x1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "session";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "activeFilter";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/trace/execution/TracePanel$MyEventGettingRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

