/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.javascript.trace.execution.code.CodeElement;
import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.code.StaticElementVisitor;
import com.intellij.javascript.trace.execution.code.StaticUnknownElement;
import org.jetbrains.annotations.NotNull;

public class RuntimeStatement
implements CodeElement {
    private Integer myId;
    private StaticCodeElement myElement;

    public RuntimeStatement(StaticCodeElement element) {
        this.myElement = element;
    }

    public RuntimeStatement(StaticUnknownElement element, int id) {
        this.myElement = element;
        this.myId = id;
    }

    @Override
    @NotNull
    public String getFile() {
        String string = this.myElement.getFile();
        if (string == null) {
            RuntimeStatement.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFunc() {
        String string = this.myElement.getFunc();
        if (string == null) {
            RuntimeStatement.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public CodeRange getCodeRange() {
        CodeRange codeRange = this.myElement.getCodeRange();
        if (codeRange == null) {
            RuntimeStatement.$$$reportNull$$$0(2);
        }
        return codeRange;
    }

    public boolean isLoaded() {
        return !(this.myElement instanceof StaticUnknownElement);
    }

    public int getId() {
        return this.myId;
    }

    public void accept(@NotNull StaticElementVisitor visitor) {
        if (visitor == null) {
            RuntimeStatement.$$$reportNull$$$0(3);
        }
        this.myElement.accept(visitor);
    }

    public void update(StaticCodeElement codeElement) {
        this.myElement = codeElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeStatement statement = (RuntimeStatement)o;
        if (!this.getCodeRange().equals(statement.getCodeRange())) {
            return false;
        }
        if (!this.getFile().equals(statement.getFile())) {
            return false;
        }
        return this.getFunc().equals(statement.getFunc());
    }

    public int hashCode() {
        int result = this.getFile().hashCode();
        result = 31 * result + this.getFunc().hashCode();
        result = 31 * result + this.getCodeRange().hashCode();
        return result;
    }

    public StaticCodeElement getCodeElement() {
        return this.myElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/common/RuntimeStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunc";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/common/RuntimeStatement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

