/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.code.StaticFuncStart;
import com.intellij.javascript.trace.execution.code.StaticProgramStart;
import com.intellij.javascript.trace.execution.common.FunctionNamePresentation;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.fileDependency.DependencyEventTreeNode;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.FileTreeNode;
import com.intellij.javascript.trace.execution.fileDependency.FunctionCombination;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class FunctionTreeNode
extends SimpleNode {
    private final SimpleNode[] myChildren;
    private final String myFuncElementId;
    private final TraceContext myContext;
    private final FileNode myFile;
    private StaticCodeElement myCodeElement;

    public FunctionTreeNode(@NotNull TraceContext context, @NotNull String streamId, @NotNull FileTreeNode parent, @NotNull FunctionCombination functionCombination) {
        if (context == null) {
            FunctionTreeNode.$$$reportNull$$$0(0);
        }
        if (streamId == null) {
            FunctionTreeNode.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            FunctionTreeNode.$$$reportNull$$$0(2);
        }
        if (functionCombination == null) {
            FunctionTreeNode.$$$reportNull$$$0(3);
        }
        super((SimpleNode)parent);
        this.myContext = context;
        this.myChildren = new SimpleNode[]{new FunctionTreeNode(context, streamId, this, functionCombination)};
        this.myFuncElementId = functionCombination.getFromFunctionId();
        this.myFile = functionCombination.getSourceFile();
        this.init();
    }

    public FunctionTreeNode(@NotNull TraceContext context, @NotNull String streamId, @NotNull FunctionTreeNode parent, @NotNull FunctionCombination functionCombination) {
        if (context == null) {
            FunctionTreeNode.$$$reportNull$$$0(4);
        }
        if (streamId == null) {
            FunctionTreeNode.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            FunctionTreeNode.$$$reportNull$$$0(6);
        }
        if (functionCombination == null) {
            FunctionTreeNode.$$$reportNull$$$0(7);
        }
        super((SimpleNode)parent);
        this.myContext = context;
        ArrayList nodes = new ArrayList(ContainerUtil.map(functionCombination.getEventHits().entrySet(), entry -> {
            if (context == null) {
                FunctionTreeNode.$$$reportNull$$$0(8);
            }
            if (streamId == null) {
                FunctionTreeNode.$$$reportNull$$$0(9);
            }
            return new DependencyEventTreeNode(context, this, streamId, (Long)entry.getKey(), (Long)entry.getValue());
        }));
        this.myChildren = nodes.toArray(new SimpleNode[nodes.size()]);
        this.myFuncElementId = functionCombination.getToFunctionId();
        this.myFile = functionCombination.getTargetFile();
        this.init();
    }

    private void init() {
        this.myCodeElement = this.myContext.getTraceSession().getCodeElementById(this.myFuncElementId);
        assert (this.myCodeElement != null);
        PresentationData presentation = this.getPresentation();
        this.setIcon(this.myFile.getFileIcon());
        FunctionNamePresentation functionNamePresentation = new FunctionNamePresentation(this.myCodeElement, this.myCodeElement instanceof StaticProgramStart, false);
        presentation.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        functionNamePresentation.buildFullName(presentation, false, null, false);
    }

    public SimpleNode[] getChildren() {
        return this.myChildren;
    }

    public String getFile() {
        return this.myCodeElement.getFile();
    }

    public int getFunctionId() {
        return this.myCodeElement instanceof StaticProgramStart ? ((StaticProgramStart)this.myCodeElement).getFuncId() : ((StaticFuncStart)this.myCodeElement).getFuncId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamId";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCombination";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/trace/execution/fileDependency/FunctionTreeNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

