/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.renderers;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class UmlNoteContainer
extends JPanel
implements Border {
    private final DiagramBuilder myBuilder;
    private final Point basePoint;
    private static final Color BG_COLOR = new JBColor(new Color(249, 254, 213), new Color(79, 82, 82));
    private static final Color BORDER_COLOR = new JBColor(new Color(204, 204, 0), new Color(112, 115, 117));
    private static final int ARC_SIZE = 16;

    public UmlNoteContainer(DiagramNoteNode note, DiagramBuilder builder, Point point) {
        super(new BorderLayout(0, 0));
        this.setFocusable(false);
        this.setOpaque(false);
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.setBorder(this);
        panel.setOpaque(false);
        panel.setFocusable(false);
        JTextArea text = new JTextArea(note.getTooltip());
        text.setFocusable(false);
        text.setBackground(BG_COLOR);
        panel.add((Component)text, "Center");
        this.add((Component)panel, "Center");
        this.myBuilder = builder;
        this.basePoint = point;
    }

    @Override
    public Point getPopupLocation(MouseEvent event) {
        Point p = this.myBuilder.getView().getCanvasComponent().getLocationOnScreen();
        return new Point(this.basePoint.x - p.x + event.getX(), this.basePoint.y - p.y + event.getY());
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        GraphicsConfig config = new GraphicsConfig(g);
        g.setColor(BG_COLOR);
        g.fillRoundRect(x + 1, y + 1, width - 2, height - 2, 16, 16);
        g.setColor(BORDER_COLOR);
        g.drawRoundRect(x + 1, y + 1, width - 2, height - 2, 16, 16);
        config.restore();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return JBUI.insets((int)5, (int)10);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

