/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.dependency;

import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.settings.DiagramConfigElement;
import com.intellij.diagram.settings.DiagramConfigGroup;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uml.java.JavaUmlRelationships;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassDependencyAnalyzer {
    private final PsiClass myClass;
    private static final List<String> COLLECTIONS = new ArrayList<String>();

    public JavaClassDependencyAnalyzer(PsiClass clazz) {
        this.myClass = clazz;
    }

    private static Pair<PsiClass, DiagramRelationshipInfo> createPair(PsiClass cl, DiagramRelationshipInfo relationship) {
        return Pair.create((Object)cl, (Object)relationship);
    }

    public List<Pair<PsiClass, DiagramRelationshipInfo>> computeUsedClasses() {
        PsiElement element;
        final ArrayList<Pair<PsiClass, DiagramRelationshipInfo>> dependencies = new ArrayList<Pair<PsiClass, DiagramRelationshipInfo>>();
        final Conf conf = Conf.fromUmlConfiguration(DiagramConfiguration.getConfiguration());
        JavaRecursiveElementVisitor visitor = new JavaRecursiveElementVisitor(){
            private boolean insideField;
            private boolean insideCollection;
            private boolean insideClassObjectAccess;
            private boolean insideInner;

            void add(Pair<PsiClass, DiagramRelationshipInfo> pair) {
                JavaClassDependencyAnalyzer.add((Pair<PsiClass, DiagramRelationshipInfo>)pair, dependencies, JavaClassDependencyAnalyzer.this.myClass, conf);
            }

            public void visitClass(PsiClass aClass) {
                if (this.insideInner || aClass instanceof PsiAnonymousClass) {
                    super.visitClass(aClass);
                } else {
                    this.insideInner = true;
                    super.visitClass(aClass);
                    this.insideInner = false;
                }
            }

            public void visitField(PsiField field) {
                if (!this.insideInner) {
                    this.insideField = true;
                    super.visitField(field);
                    this.insideField = false;
                }
            }

            public void visitNewExpression(PsiNewExpression expression) {
                PsiClass psiClass;
                if (this.insideInner) {
                    return;
                }
                PsiType type = expression.getType();
                if (type != null && (psiClass = JavaClassDependencyAnalyzer.findConcreteClass(JavaClassDependencyAnalyzer.typeToClass(type))) != null) {
                    this.add((Pair<PsiClass, DiagramRelationshipInfo>)JavaClassDependencyAnalyzer.createPair(psiClass, JavaUmlRelationships.CREATE));
                }
                super.visitNewExpression(expression);
            }

            public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
                if (!this.insideInner) {
                    this.insideClassObjectAccess = true;
                    super.visitClassObjectAccessExpression(expression);
                    this.insideClassObjectAccess = false;
                }
            }

            public void visitTypeElement(PsiTypeElement typeElement) {
                if (this.insideInner) {
                    return;
                }
                PsiType type = typeElement.getType();
                PsiClass psiClass = JavaClassDependencyAnalyzer.typeToClass(type);
                if (psiClass != null && !(psiClass instanceof PsiTypeParameter)) {
                    if (this.insideClassObjectAccess) {
                        this.add((Pair<PsiClass, DiagramRelationshipInfo>)JavaClassDependencyAnalyzer.createPair(psiClass, JavaUmlRelationships.DEPENDENCY));
                    } else if (this.insideField && !this.insideCollection && !(type instanceof PsiArrayType)) {
                        this.add((Pair<PsiClass, DiagramRelationshipInfo>)JavaClassDependencyAnalyzer.createPair(psiClass, JavaUmlRelationships.TO_ONE));
                    } else if (this.insideField && this.insideCollection && !(type instanceof PsiArrayType)) {
                        this.add((Pair<PsiClass, DiagramRelationshipInfo>)JavaClassDependencyAnalyzer.createPair(psiClass, JavaUmlRelationships.TO_MANY));
                    } else {
                        this.add((Pair<PsiClass, DiagramRelationshipInfo>)JavaClassDependencyAnalyzer.createPair(psiClass, JavaUmlRelationships.DEPENDENCY));
                    }
                }
                if (this.insideField && !this.insideCollection && JavaClassDependencyAnalyzer.isCollection(typeElement)) {
                    this.insideCollection = true;
                    super.visitTypeElement(typeElement);
                    this.insideCollection = false;
                } else {
                    super.visitTypeElement(typeElement);
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
                if (this.insideInner) {
                    return;
                }
                PsiExpression qualifierExpression = referenceExpression.getQualifierExpression();
                if (qualifierExpression != null) {
                    PsiElement reference;
                    PsiReference psiReference = qualifierExpression.getReference();
                    if (psiReference != null && (reference = psiReference.resolve()) instanceof PsiClass) {
                        this.add((Pair<PsiClass, DiagramRelationshipInfo>)JavaClassDependencyAnalyzer.createPair((PsiClass)reference, JavaUmlRelationships.DEPENDENCY));
                    }
                } else {
                    PsiClass aClass;
                    PsiElement resolve = referenceExpression.resolve();
                    if ((resolve instanceof PsiField || resolve instanceof PsiMethod) && (aClass = ((PsiMember)resolve).getContainingClass()) != null) {
                        this.add((Pair<PsiClass, DiagramRelationshipInfo>)JavaClassDependencyAnalyzer.createPair(aClass, JavaUmlRelationships.DEPENDENCY));
                    }
                }
                super.visitReferenceExpression(referenceExpression);
            }
        };
        PsiClass source = this.myClass;
        if (this.myClass instanceof PsiCompiledElement && (element = this.myClass.getNavigationElement()) instanceof PsiClass) {
            source = (PsiClass)element;
        }
        visitor.visitElement((PsiElement)source);
        return dependencies;
    }

    private static void add(Pair<PsiClass, DiagramRelationshipInfo> pair, List<Pair<PsiClass, DiagramRelationshipInfo>> dependencies, PsiClass myClass, Conf conf) {
        DiagramRelationshipInfo r = (DiagramRelationshipInfo)pair.second;
        if (r == JavaUmlRelationships.TO_ONE && !conf.showOneToOne || r == JavaUmlRelationships.TO_MANY && !conf.showOneToMany || r == JavaUmlRelationships.DEPENDENCY && !conf.showUsages || myClass.equals(pair.first) && !conf.showCyclic || r != JavaUmlRelationships.TO_MANY && r != JavaUmlRelationships.TO_ONE && !myClass.equals(pair.first) && !conf.showNewExpressions) {
            return;
        }
        dependencies.add(pair);
    }

    @Nullable
    private static PsiClass typeToClass(@NotNull PsiType psiType) {
        PsiClass psiClass;
        PsiType deepComponentType;
        if (psiType == null) {
            JavaClassDependencyAnalyzer.$$$reportNull$$$0(0);
        }
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass2 = ((PsiClassType)psiType).resolve();
            if (psiClass2 != null) {
                return psiClass2;
            }
        } else if (psiType instanceof PsiArrayType && (deepComponentType = ((PsiArrayType)psiType).getComponentType().getDeepComponentType()) instanceof PsiClassType && (psiClass = ((PsiClassType)deepComponentType).resolve()) != null) {
            return psiClass;
        }
        return null;
    }

    private static boolean isCollection(@NotNull PsiTypeElement type) {
        if (type == null) {
            JavaClassDependencyAnalyzer.$$$reportNull$$$0(1);
        }
        if (type.getType() instanceof PsiArrayType) {
            return true;
        }
        PsiClass aClass = JavaClassDependencyAnalyzer.typeToClass(type.getType());
        if (aClass == null) {
            return false;
        }
        List<PsiClass> classes = JavaClassDependencyAnalyzer.getAllInterfaces(aClass);
        classes.add(aClass);
        for (PsiClass cl : classes) {
            if (!COLLECTIONS.contains(cl.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static List<PsiClass> getAllInterfaces(PsiClass psiClass) {
        PsiClass[] inters;
        ArrayList<PsiClass> interfaces = new ArrayList<PsiClass>();
        for (PsiClass inter : inters = psiClass.getInterfaces()) {
            interfaces.add(inter);
            interfaces.addAll(JavaClassDependencyAnalyzer.getAllInterfaces(inter));
        }
        return interfaces;
    }

    @Nullable
    private static PsiClass findConcreteClass(PsiClass psiClass) {
        while (psiClass instanceof PsiAnonymousClass) {
            psiClass = PsiUtil.resolveClassInType((PsiType)((PsiAnonymousClass)psiClass).getBaseClassType());
        }
        return psiClass;
    }

    static {
        COLLECTIONS.add("java.lang.Iterable");
        COLLECTIONS.add("java.util.Map");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/java/dependency/JavaClassDependencyAnalyzer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "typeToClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isCollection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Conf {
        public boolean showOneToOne;
        public boolean showOneToMany;
        public boolean showUsages;
        public boolean showCyclic;
        public boolean showNewExpressions;

        private Conf() {
        }

        public static Conf fromUmlConfiguration(DiagramConfiguration conf) {
            Conf c = new Conf();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                c.showNewExpressions = true;
                c.showCyclic = true;
                c.showUsages = true;
                c.showOneToMany = true;
                c.showOneToOne = true;
                return c;
            }
            DiagramProvider provider = DiagramProvider.findByID((String)"JAVA");
            DiagramConfigGroup[] settings = provider.getExtras().getAdditionalDiagramSettings();
            HashMap<String, Boolean> booleans = new HashMap<String, Boolean>();
            for (DiagramConfigGroup setting : settings) {
                if (!setting.getName().equals("Dependencies")) continue;
                for (DiagramConfigElement element : setting.getElements()) {
                    if (element.getType() != DiagramConfigElement.Type.CHECKBOX) continue;
                    String key = StringUtil.decapitalize((String)element.getName().replace(" ", ""));
                    booleans.put(key, conf.isEnabledByDefault(provider, element.getName()));
                }
            }
            c.showOneToOne = (Boolean)booleans.get("showOneToOne");
            c.showOneToMany = (Boolean)booleans.get("showOneToMany");
            c.showUsages = (Boolean)booleans.get("showUsages");
            c.showCyclic = (Boolean)booleans.get("showCyclic");
            c.showNewExpressions = (Boolean)booleans.get("others");
            return c;
        }
    }
}

