/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.jps.builder;

import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuilderExecutionSettings {
    @Nullable
    private final File myGradleHomeDir;
    @Nullable
    private final File myGradleServiceDir;
    @Nullable
    private final File myJavaHomeDir;
    @NotNull
    private final File myProjectDir;
    @NotNull
    private final BuildMode myBuildMode;
    @NotNull
    private final List<String> myGradleTasksToInvoke;
    @NotNull
    private final List<String> myCommandLineOptions;
    @NotNull
    private final List<String> myJvmOptions;
    private final boolean myEmbeddedModeEnabled = SystemProperties.getBooleanProperty((String)"com.android.studio.gradle.use.embedded.daemon", (boolean)false);
    private final boolean myVerboseLoggingEnabled;
    private final boolean myParallelBuild;
    private final boolean myOfflineBuildMode;
    private final boolean myConfigureOnDemand;

    BuilderExecutionSettings() {
        this.myGradleHomeDir = BuilderExecutionSettings.findDir("com.android.studio.gradle.home.path", "Gradle home");
        this.myGradleServiceDir = BuilderExecutionSettings.findDir("com.android.studio.gradle.service.dir.path", "Gradle service");
        this.myJavaHomeDir = BuilderExecutionSettings.findDir("com.android.studio.gradle.java.home.path", "Java home");
        this.myProjectDir = BuilderExecutionSettings.findProjectRootDir();
        String buildActionName = System.getProperty("com.android.studio.gradle.build.mode");
        this.myBuildMode = Strings.isNullOrEmpty((String)buildActionName) ? BuildMode.DEFAULT_BUILD_MODE : BuildMode.valueOf((String)buildActionName);
        this.myGradleTasksToInvoke = BuilderExecutionSettings.getJvmArgGroup("com.android.studio.gradle.gradle.tasks.");
        this.myCommandLineOptions = BuilderExecutionSettings.getJvmArgGroup("com.android.studio.gradle.daemon.command.line.option.");
        this.myJvmOptions = BuilderExecutionSettings.getJvmArgGroup("com.android.studio.gradle.daemon.jvm.option.");
        this.myVerboseLoggingEnabled = SystemProperties.getBooleanProperty((String)"com.android.studio.gradle.use.verbose.logging", (boolean)false);
        this.myParallelBuild = SystemProperties.getBooleanProperty((String)"compile.parallel", (boolean)false);
        this.myOfflineBuildMode = SystemProperties.getBooleanProperty((String)"com.android.studio.gradle.offline.mode", (boolean)false);
        this.myConfigureOnDemand = SystemProperties.getBooleanProperty((String)"com.android.studio.gradle.configuration.on.demand", (boolean)false);
        this.populateHttpProxyJvmOptions();
    }

    @Nullable
    private static File findDir(@NotNull String jvmArgName, @NotNull String dirType) {
        File gradleServiceDir;
        if (jvmArgName == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(0);
        }
        if (dirType == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(1);
        }
        if ((gradleServiceDir = BuilderExecutionSettings.createFile(jvmArgName)) == null) {
            return null;
        }
        BuilderExecutionSettings.ensureDirectoryExists(gradleServiceDir, dirType);
        return gradleServiceDir;
    }

    @NotNull
    private static File findProjectRootDir() {
        File projectRootDir = BuilderExecutionSettings.createFile("com.android.studio.gradle.project.path");
        if (projectRootDir == null) {
            throw new NullPointerException("Project directory not specified");
        }
        BuilderExecutionSettings.ensureDirectoryExists(projectRootDir, "project");
        File file = projectRootDir;
        if (file == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(2);
        }
        return file;
    }

    private static void ensureDirectoryExists(@NotNull File dir, @NotNull String type) {
        if (dir == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(3);
        }
        if (type == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(4);
        }
        if (!dir.isDirectory()) {
            String path = dir.getPath();
            String msg = String.format("Unable to obtain %1$s directory: the file '%2$s' is not a directory", type, path);
            throw new IllegalArgumentException(msg);
        }
    }

    @Nullable
    private static File createFile(@NotNull String jvmArgName) {
        String path;
        if (jvmArgName == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(5);
        }
        return (path = System.getProperty(jvmArgName)) != null && !path.isEmpty() ? new File(path) : null;
    }

    @NotNull
    private static List<String> getJvmArgGroup(@NotNull String argPrefix) {
        String arg;
        if (argPrefix == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(6);
        }
        ArrayList args = Lists.newArrayList();
        int counter = 0;
        while (!Strings.isNullOrEmpty((String)(arg = System.getProperty(argPrefix + counter++)))) {
            args.add(arg);
        }
        ArrayList arrayList = args;
        if (arrayList == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private void populateHttpProxyJvmOptions() {
        String jvmOption;
        int counter = 0;
        while (!Strings.isNullOrEmpty((String)(jvmOption = System.getProperty("com.android.studio.gradle.proxy.property." + counter++)))) {
            int indexOfSeparator = jvmOption.indexOf(":");
            if (indexOfSeparator < 0 || indexOfSeparator >= jvmOption.length() - 1) continue;
            String arg = AndroidGradleSettings.createJvmArg((String)jvmOption.substring(0, indexOfSeparator), (String)jvmOption.substring(indexOfSeparator + 1));
            this.myJvmOptions.add(arg);
        }
    }

    boolean isEmbeddedModeEnabled() {
        return this.myEmbeddedModeEnabled;
    }

    boolean isVerboseLoggingEnabled() {
        return this.myVerboseLoggingEnabled;
    }

    @NotNull
    List<String> getCommandLineOptions() {
        List<String> list = this.myCommandLineOptions;
        if (list == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    List<String> getJvmOptions() {
        List<String> list = this.myJvmOptions;
        if (list == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    File getGradleHomeDir() {
        return this.myGradleHomeDir;
    }

    @Nullable
    File getGradleServiceDir() {
        return this.myGradleServiceDir;
    }

    @Nullable
    File getJavaHomeDir() {
        return this.myJavaHomeDir;
    }

    @NotNull
    File getProjectDir() {
        File file = this.myProjectDir;
        if (file == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(10);
        }
        return file;
    }

    @NotNull
    BuildMode getBuildMode() {
        BuildMode buildMode = this.myBuildMode;
        if (buildMode == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(11);
        }
        return buildMode;
    }

    boolean isParallelBuild() {
        return this.myParallelBuild;
    }

    boolean isOfflineBuild() {
        return this.myOfflineBuildMode;
    }

    public boolean isConfigureOnDemand() {
        return this.myConfigureOnDemand;
    }

    @NotNull
    List<String> getGradleTasksToInvoke() {
        List<String> list = this.myGradleTasksToInvoke;
        if (list == null) {
            BuilderExecutionSettings.$$$reportNull$$$0(12);
        }
        return list;
    }

    public String toString() {
        return "BuilderExecutionSettings[buildMode=" + this.myBuildMode.name() + ", commandLineOptions=" + this.myCommandLineOptions + ", embeddedModeEnabled=" + this.myEmbeddedModeEnabled + ", gradleHomeDir=" + this.myGradleHomeDir + ", gradleServiceDir=" + this.myGradleServiceDir + ", javaHomeDir=" + this.myJavaHomeDir + ", jvmOptions=" + this.myJvmOptions + ", gradleTasksToInvoke=" + this.myGradleTasksToInvoke + ", offlineBuild=" + this.myOfflineBuildMode + ", parallelBuild=" + this.myParallelBuild + ", projectDir=" + this.myProjectDir + ", verboseLoggingEnabled=" + this.myVerboseLoggingEnabled + ']';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmArgName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirType";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/jps/builder/BuilderExecutionSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/jps/builder/BuilderExecutionSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findProjectRootDir";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmArgGroup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineOptions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmOptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDir";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildMode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleTasksToInvoke";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDir";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ensureDirectoryExists";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getJvmArgGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

