/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.editor;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.pom.SpringBeanPomTargetUtils;
import com.intellij.spring.model.xml.beans.Description;
import com.intellij.spring.model.xml.beans.ScopedElement;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class SpringBeanDocumentationProvider
extends AbstractDocumentationProvider {
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        JamPsiMemberSpringBean jamPsiMemberSpringBean;
        PsiAnnotation description;
        GenericAttributeValue scope;
        SpringProfile profile;
        CommonSpringBean springBean = SpringBeanPomTargetUtils.getSpringBean((PsiElement)element);
        if (springBean == null || !springBean.isValid()) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(SpringBeanDocumentationProvider.getSpringBeanTypeName(springBean));
        String beanName = SpringPresentationProvider.getSpringBeanName((CommonSpringBean)springBean);
        sb.append(" <b>").append(StringUtil.escapeXml((String)beanName)).append("</b>");
        String[] aliases = springBean.getAliases();
        if (aliases.length > 0) {
            sb.append(" (");
            sb.append(StringUtil.join((String[])aliases, (String)", "));
            sb.append(")");
        }
        sb.append("<br/>");
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass != null) {
            sb.append("<br/>");
            PsiClassType beanClassType = PsiTypesUtil.getClassType((PsiClass)beanClass);
            JavaDocInfoGenerator.generateType((StringBuilder)sb, (PsiType)beanClassType, (PsiElement)beanClass, (boolean)true);
            SpringBeanDocumentationProvider.appendSupers(sb, "extends", beanClass, beanClass.getExtendsListTypes());
            SpringBeanDocumentationProvider.appendSupers(sb, "implements", beanClass, beanClass.getImplementsListTypes());
            sb.append("<br/>");
        }
        sb.append("<br/>");
        VirtualFile file = springBean.getContainingFile().getVirtualFile();
        if (file != null) {
            sb.append(ProjectUtil.calcRelativeToProjectPath((VirtualFile)file, (Project)element.getProject()));
            sb.append("<br/><br/>");
        }
        if ((profile = springBean.getProfile()) != SpringProfile.DEFAULT) {
            sb.append("Profile: ");
            sb.append(StringUtil.join((Collection)profile.getNames(), (String)", "));
            sb.append("<br/>");
        }
        if (springBean instanceof ScopedElement && DomUtil.hasXml((DomElement)(scope = ((ScopedElement)springBean).getScope()))) {
            sb.append("Scope: ");
            sb.append(scope.getStringValue());
            sb.append("<br/>");
        }
        if (springBean instanceof Description) {
            Description description2 = (Description)springBean;
            String documentation = (String)description2.getDescription().getValue();
            if (StringUtil.isNotEmpty((String)documentation)) {
                sb.append("<br/><br/>");
                sb.append(documentation);
            }
        } else if (springBean instanceof JamPsiMemberSpringBean && (description = AnnotationUtil.findAnnotation((PsiModifierListOwner)(jamPsiMemberSpringBean = (JamPsiMemberSpringBean)springBean).getPsiElement(), (boolean)true, (String[])new String[]{"org.springframework.context.annotation.Description"})) != null) {
            sb.append("<br/><br/>");
            sb.append(AnnotationUtil.getStringAttributeValue((PsiAnnotation)description, null));
        }
        sb.append("</html>");
        return sb.toString();
    }

    private static void appendSupers(StringBuilder sb, String role, PsiClass context, PsiClassType[] types) {
        if (types.length == 0) {
            return;
        }
        sb.append("<br/>");
        sb.append(role);
        sb.append("&nbsp;");
        for (int i = 0; i < types.length; ++i) {
            PsiClassType type = types[i];
            JavaDocInfoGenerator.generateType((StringBuilder)sb, (PsiType)type, (PsiElement)context, (boolean)true);
            if (i >= types.length - 1) continue;
            sb.append(",&nbsp;");
        }
    }

    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        CommonSpringBean springBean = SpringBeanPomTargetUtils.getSpringBean((PsiElement)element);
        if (springBean == null || !springBean.isValid()) {
            return null;
        }
        String beanName = SpringPresentationProvider.getSpringBeanName((CommonSpringBean)springBean);
        PsiFile containingFile = springBean.getContainingFile();
        StringBuilder sb = new StringBuilder(SpringBeanDocumentationProvider.getSpringBeanTypeName(springBean)).append(" ").append(beanName).append(" [").append(containingFile.getName()).append("]");
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (psiClass != null) {
            sb.append("\n ").append(psiClass.getQualifiedName());
        }
        return sb.toString();
    }

    private static String getSpringBeanTypeName(CommonSpringBean springBean) {
        PsiElement identifyingPsiElement = springBean.getIdentifyingPsiElement();
        assert (identifyingPsiElement != null) : springBean;
        return ElementDescriptionUtil.getElementDescription((PsiElement)identifyingPsiElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
    }
}

