/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.gutter.SpringAnnotatorBase;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class SpringPropertiesAnnotator
extends SpringAnnotatorBase {
    public String getId() {
        return "SpringPropertiesAnnotator";
    }

    public String getName() {
        return "Properties";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.Gutter.SpringProperty;
    }

    @Override
    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        UElement element;
        if (psiElement == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(1);
        }
        if ((element = UastContextKt.toUElement((PsiElement)psiElement, UElement.class)) instanceof UClass) {
            UClass uClass = (UClass)element;
            PsiClass psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class);
            if (psiClass == null || !SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
                return;
            }
            this.annotateClass(result, uClass);
            for (UMethod method : uClass.getMethods()) {
                this.annotateMethod(method, result);
            }
        }
    }

    private static void addPropertiesGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends DomElement>> targets) {
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)SpringApiIcons.Gutter.SpringProperty, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR, (NotNullFunction)NavigationGutterIconBuilder.DOM_GOTO_RELATED_ITEM_PROVIDER);
        builder.setTargets(targets).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setPopupTitle(SpringBundle.message("spring.bean.property.navigate.choose.class.title", new Object[0])).setTooltipText(SpringBundle.message("spring.bean.property.tooltip.navigate.declaration", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createSpringRelatedMergeableLineMarkerInfo(psiIdentifier));
    }

    @Override
    protected void annotateClass(Collection<? super RelatedItemLineMarkerInfo> result, @NotNull UClass uClass, PsiElement identifier) {
        PsiClass psiClass;
        if (uClass == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(2);
        }
        if ((psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class)) == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (SpringCommonUtils.isSpringConfigured((Module)module) || SpringModelUtils.getInstance().hasAutoConfiguredModels(module)) {
            SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
            if (info.isMappedDomBean() || info.isStereotypeJavaBean()) {
                return;
            }
            SpringPropertiesAnnotator.annotatePsiClassSpringPropertyValues(result, psiClass, identifier, SpringModelUtils.getInstance().getSpringModel((PsiElement)psiClass).getConfigFiles());
        }
    }

    @Override
    protected void annotateMethod(@NotNull UMethod umethod, PsiElement identifier, Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiMethod method;
        if (umethod == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(3);
        }
        if ((method = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)umethod, PsiMethod.class)) == null) {
            return;
        }
        final PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
        if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) && info.isMappedProperty(method)) {
            SpringPropertiesAnnotator.addPropertiesGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends DomElement>>(){

                @NotNull
                protected Collection<? extends DomElement> compute() {
                    String propertyName = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)method);
                    SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
                    Collection collection = info.getMappedProperties(propertyName);
                    if (collection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return collection;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringPropertiesAnnotator$1", "compute"));
                }
            });
        }
    }

    private static void annotatePsiClassSpringPropertyValues(Collection<? super RelatedItemLineMarkerInfo> result, @NotNull PsiClass psiClass, @NotNull PsiElement identifier, @NotNull Set<? extends PsiFile> xmlConfigFiles) {
        if (psiClass == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(4);
        }
        if (identifier == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(5);
        }
        if (xmlConfigFiles == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(6);
        }
        if (DumbService.isDumb((Project)psiClass.getProject())) {
            return;
        }
        if (xmlConfigFiles.isEmpty()) {
            return;
        }
        final List values = Collections.synchronizedList(new ArrayList());
        List springFiles = ContainerUtil.mapNotNull(xmlConfigFiles, psiFile -> psiFile instanceof XmlFile ? psiFile.getVirtualFile() : null);
        ReferencesSearch.search((PsiElement)psiClass, (SearchScope)GlobalSearchScope.filesScope((Project)psiClass.getProject(), (Collection)springFiles)).forEach(psiReference -> {
            SpringProperty value;
            DomElement domElement;
            PsiElement element = psiReference.getElement();
            if (element instanceof XmlElement && (domElement = DomUtil.getDomElement((PsiElement)element)) != null && !SpringPropertiesAnnotator.isAnonymousBeanClass(domElement) && (value = (SpringProperty)domElement.getParentOfType(SpringProperty.class, false)) != null) {
                values.add(value);
            }
            return true;
        });
        if (!values.isEmpty()) {
            SpringPropertiesAnnotator.addPropertiesGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends DomElement>>(){

                @NotNull
                protected Collection<? extends DomElement> compute() {
                    List list = values;
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringPropertiesAnnotator$2", "compute"));
                }
            });
        }
    }

    private static boolean isAnonymousBeanClass(DomElement domElement) {
        GenericAttributeValue genericAttributeValue = (GenericAttributeValue)domElement.getParentOfType(GenericAttributeValue.class, false);
        if (genericAttributeValue != null && "class".equals(genericAttributeValue.getXmlElementName())) {
            return genericAttributeValue.getParent() instanceof SpringBean;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "umethod";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlConfigFiles";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/gutter/SpringPropertiesAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNavigationMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateMethod";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "annotatePsiClassSpringPropertyValues";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

