/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.beans.CNamespaceValue;
import com.intellij.spring.model.xml.beans.ConstructorArgDefinition;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Colors;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ResolvedConstructorArgsMessageBuilder {
    private static final Color AUTOWIRED_COLOR = new JBColor(Colors.DARK_BLUE, LightColors.BLUE.brighter());
    private static final Color UNKNOWN_INJECTION_COLOR = new JBColor(Colors.DARK_RED, LightColors.RED.brighter());
    @NotNull
    private final String myMessage;
    private PsiMethod[] myConstructors;
    @NotNull
    private final ResolvedConstructorArgs myResolvedConstructorArgs;
    private final StringBuilder mySB;

    public ResolvedConstructorArgsMessageBuilder(@NotNull String message, @NotNull PsiMethod[] constructors, @NotNull ResolvedConstructorArgs resolvedArgs) {
        if (message == null) {
            ResolvedConstructorArgsMessageBuilder.$$$reportNull$$$0(0);
        }
        if (constructors == null) {
            ResolvedConstructorArgsMessageBuilder.$$$reportNull$$$0(1);
        }
        if (resolvedArgs == null) {
            ResolvedConstructorArgsMessageBuilder.$$$reportNull$$$0(2);
        }
        this.mySB = new StringBuilder();
        this.myMessage = message;
        this.myConstructors = constructors;
        this.myResolvedConstructorArgs = resolvedArgs;
    }

    public String getMessage() {
        if (this.myConstructors.length == 0) {
            return this.myMessage;
        }
        this.append("<html>");
        this.append(this.myMessage);
        this.append("#treeend");
        for (PsiMethod constructor : this.myConstructors) {
            Map args = this.myResolvedConstructorArgs.getResolvedArgs(constructor);
            Map params = this.myResolvedConstructorArgs.getAutowiredParams(constructor);
            this.append("<hr>");
            this.append("<table>");
            this.append("<tr><td><b>").append(constructor.getName()).append("(...):</b></td><td></td><td><b>Bean:</b></td></tr>");
            for (PsiParameter parameter : constructor.getParameterList().getParameters()) {
                Set<SpringBeanPointer> pointers;
                this.append("<tr>");
                this.append("<td>");
                this.appendParameterText(parameter);
                this.append("</td><td>&nbsp;&nbsp;&nbsp;</td>");
                this.append("<td>");
                Collection<Object> collection = pointers = params == null ? Collections.emptySet() : (Collection)params.get(parameter);
                if (pointers != null && pointers.size() > 0) {
                    this.appendAutowiredBeanPointersText(pointers);
                } else {
                    ConstructorArgDefinition key = null;
                    if (args != null) {
                        for (Map.Entry entry : args.entrySet()) {
                            if (!((PsiParameter)entry.getValue()).equals(parameter)) continue;
                            key = (ConstructorArgDefinition)entry.getKey();
                            break;
                        }
                    }
                    if (key != null) {
                        this.appendConstructorArgText(key);
                    } else {
                        this.append("<font color='#").append(ColorUtil.toHex((Color)UNKNOWN_INJECTION_COLOR)).append("'>");
                        this.append("<b> ??? </b>");
                        this.append("</font>");
                    }
                }
                this.append("</td>");
                this.append("</tr>");
            }
            this.append("</table>");
        }
        this.append("</html>");
        return this.mySB.toString();
    }

    private void appendAutowiredBeanPointersText(Collection<SpringBeanPointer> pointers) {
        this.append("<font color='").append("#" + ColorUtil.toHex((Color)(pointers.size() > 1 ? UNKNOWN_INJECTION_COLOR : AUTOWIRED_COLOR))).append("'>");
        this.append("Autowired:");
        for (SpringBeanPointer pointer : pointers) {
            String qualifiedName;
            this.append(" ");
            this.append(pointer.getName());
            PsiClass beanClass = pointer.getBeanClass();
            if (beanClass == null || (qualifiedName = beanClass.getQualifiedName()) == null) continue;
            this.append("(");
            this.append(StringUtil.getShortName((String)qualifiedName));
            this.append(")");
            this.append(";");
        }
        this.mySB.deleteCharAt(this.mySB.length() - 1);
        this.append("</font>");
    }

    private void appendConstructorArgText(@NotNull ConstructorArgDefinition key) {
        if (key == null) {
            ResolvedConstructorArgsMessageBuilder.$$$reportNull$$$0(3);
        }
        if (key instanceof CNamespaceValue) {
            XmlElement element = key.getXmlElement();
            if (element != null) {
                this.appendXmlCode("<bean ... ");
                this.append(StringUtil.escapeXml((String)("<b>" + element.getText() + "</b>")));
                this.appendXmlCode("... />");
            }
        } else {
            XmlTag element = key.getXmlTag();
            if (element != null) {
                String text = element.getText();
                String[] strings = StringUtil.splitByLines((String)text);
                if (strings.length > 1) {
                    text = strings[0] + strings[1] + "...";
                }
                this.appendXmlCode(text);
            }
        }
    }

    private void appendParameterText(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            ResolvedConstructorArgsMessageBuilder.$$$reportNull$$$0(4);
        }
        this.appendXmlCode(StringUtil.getShortName((String)parameter.getType().getPresentableText()));
        this.append(" ");
        this.append(parameter.getName());
    }

    private StringBuilder append(String text) {
        return this.mySB.append(text);
    }

    private StringBuilder appendXmlCode(String text) {
        this.append((String)ProblemDescriptorUtil.XML_CODE_MARKER.first);
        this.append(StringUtil.escapeXml((String)text));
        return this.append((String)ProblemDescriptorUtil.XML_CODE_MARKER.second);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedArgs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/xml/ResolvedConstructorArgsMessageBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendConstructorArgText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendParameterText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

