/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.jam.SpringBeanPointerResolveInspection;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtilImpl;
import com.intellij.spring.model.jam.testContexts.SpringTransactionConfiguration;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSql;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSqlConfig;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringContextConfigurationInspection
extends AbstractBaseJavaLocalInspectionTool {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Module module;
        if (aClass == null) {
            SpringContextConfigurationInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringContextConfigurationInspection.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass)) != null) {
            SpringTestingSqlConfig sqlConfig;
            SpringTransactionConfiguration transactionConfiguration;
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            SpringContextConfiguration contextConfiguration = (SpringContextConfiguration)SpringContextConfiguration.META.getJamElement((PsiModifierListOwner)aClass);
            if (contextConfiguration != null) {
                SpringContextConfigurationInspection.checkContextConfiguration(contextConfiguration, holder);
            }
            if ((transactionConfiguration = (SpringTransactionConfiguration)SpringTransactionConfiguration.META.getJamElement((PsiModifierListOwner)aClass)) != null) {
                SpringBeanPointerResolveInspection.checkBeanPointerResolve((ProblemsHolder)holder, transactionConfiguration.getTransactionManagerAttributeElement());
            }
            if ((sqlConfig = this.getTestingSqlConfig(aClass)) != null) {
                SpringBeanPointerResolveInspection.checkBeanPointerResolve((ProblemsHolder)holder, (JamStringAttributeElement)sqlConfig.getTransactionManagerElement());
                SpringBeanPointerResolveInspection.checkBeanPointerResolve((ProblemsHolder)holder, (JamStringAttributeElement)sqlConfig.getDatasourceAttrElement());
            }
            return holder.getResultsArray();
        }
        return super.checkClass(aClass, manager, isOnTheFly);
    }

    protected SpringTestingSqlConfig getTestingSqlConfig(@NotNull PsiClass aClass) {
        SpringTestingSqlConfig sqlConfig;
        if (aClass == null) {
            SpringContextConfigurationInspection.$$$reportNull$$$0(2);
        }
        if ((sqlConfig = (SpringTestingSqlConfig)SpringTestingSqlConfig.META.getJamElement((PsiModifierListOwner)aClass)) != null) {
            return sqlConfig;
        }
        SpringTestingSql testingSql = (SpringTestingSql)SpringTestingSql.CLASS_META.getJamElement((PsiModifierListOwner)aClass);
        if (testingSql != null) {
            return testingSql.getSqlConfig();
        }
        return null;
    }

    private static void checkContextConfiguration(@NotNull SpringContextConfiguration contextConfiguration, @NotNull ProblemsHolder holder) {
        Object fix;
        PsiAnnotation annotation;
        XmlFile xmlFile;
        if (contextConfiguration == null) {
            SpringContextConfigurationInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            SpringContextConfigurationInspection.$$$reportNull$$$0(4);
        }
        if (SpringContextConfigurationInspection.isLocationsAttributesDefined(contextConfiguration, true)) {
            SpringContextConfigurationInspection.checkLocationAttribute(holder, contextConfiguration.getLocationsAttributeElement());
            SpringContextConfigurationInspection.checkLocationAttribute(holder, contextConfiguration.getValueAttributeElement());
        } else if (SpringTestContextUtilImpl.isGenericXmlContextLoader(contextConfiguration) && (xmlFile = SpringTestContextUtilImpl.getDefaultLocation((ContextConfiguration)contextConfiguration)) == null) {
            annotation = contextConfiguration.getAnnotation();
            assert (annotation != null);
            PsiDirectory directory = annotation.getContainingFile().getContainingDirectory();
            fix = directory == null ? null : new CreateFileFix(SpringTestContextUtilImpl.getDefaultAppContextName((ContextConfiguration)contextConfiguration), directory, null){

                protected String getFileText() {
                    return SpringCommonUtils.getSpringXmlTemplate((Module[])new Module[]{ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation)}).getText();
                }
            };
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("SpringContextConfigurationInspection.cannot.find.default.app.context", SpringTestContextUtilImpl.getDefaultAppContextName((ContextConfiguration)contextConfiguration)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
        }
        if (SpringTestContextUtilImpl.isAnnotationConfigLoader((ContextConfiguration)contextConfiguration)) {
            CommonProcessors.FindProcessor<SpringContextConfiguration> processor = new CommonProcessors.FindProcessor<SpringContextConfiguration>(){

                protected boolean accept(SpringContextConfiguration configuration) {
                    return configuration.getConfigurationClasses().size() != 0;
                }
            };
            SpringContextConfigurationInspection.processConfigurations(contextConfiguration, true, (Processor<SpringContextConfiguration>)processor);
            if (!processor.isFound() && !SpringContextConfigurationInspection.hasInnerConfigurations(contextConfiguration)) {
                annotation = contextConfiguration.getAnnotation();
                assert (annotation != null);
                final PsiClass aClass = contextConfiguration.getPsiElement();
                if (aClass == null) {
                    return;
                }
                fix = new LocalQuickFixBase("Create Inner ContextConfiguration class"){

                    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        PsiClass existedClass;
                        if (project == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (descriptor == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        if ((existedClass = aClass.findInnerClassByName("ContextConfiguration", false)) != null) {
                            PsiModifierList modifierList = existedClass.getModifierList();
                            if (modifierList != null) {
                                modifierList.addAnnotation("org.springframework.context.annotation.Configuration");
                            }
                        } else {
                            PsiClass innerClass = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createClass("ContextConfiguration");
                            PsiModifierList modifierList = innerClass.getModifierList();
                            if (modifierList != null) {
                                modifierList.setModifierProperty("public", true);
                                modifierList.setModifierProperty("static", true);
                                modifierList.addAnnotation("org.springframework.context.annotation.Configuration");
                            }
                            aClass.add((PsiElement)innerClass);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "project";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "descriptor";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection$3";
                        objectArray[2] = "applyFix";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                holder.registerProblem((PsiElement)annotation, SpringBundle.message("SpringContextConfigurationInspection.cannot.find.default.app.context", aClass.getName() + "ContextConfiguration"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{holder.isOnTheFly() ? fix : null});
            }
        }
    }

    private static boolean hasInnerConfigurations(@NotNull SpringContextConfiguration configuration) {
        PsiClass configurationClass;
        if (configuration == null) {
            SpringContextConfigurationInspection.$$$reportNull$$$0(5);
        }
        if ((configurationClass = configuration.getPsiElement()) != null) {
            for (PsiClass psiClass : configurationClass.getAllInnerClasses()) {
                if (!psiClass.hasModifierProperty("static") || JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkLocationAttribute(ProblemsHolder holder, List<JamStringAttributeElement<List<XmlFile>>> attributeElements) {
        block0: for (JamStringAttributeElement<List<XmlFile>> attributeElement : attributeElements) {
            PsiLiteral psiLiteral = attributeElement.getPsiLiteral();
            if (psiLiteral == null) continue;
            for (PsiReference psiReference : psiLiteral.getReferences()) {
                if (psiReference.isSoft() || !(psiReference instanceof FileReference) || ((FileReference)psiReference).multiResolve(false).length != 0) continue;
                holder.registerProblem(psiReference);
                continue block0;
            }
        }
    }

    private static boolean isLocationsAttributesDefined(SpringContextConfiguration contextConfiguration) {
        return !contextConfiguration.getLocationsAttributeElement().isEmpty() || !contextConfiguration.getValueAttributeElement().isEmpty();
    }

    private static boolean isLocationsAttributesDefined(SpringContextConfiguration contextConfiguration, boolean searchParent) {
        CommonProcessors.FindProcessor<SpringContextConfiguration> searchLocationsProcessor = new CommonProcessors.FindProcessor<SpringContextConfiguration>(){

            protected boolean accept(SpringContextConfiguration configuration) {
                return SpringContextConfigurationInspection.isLocationsAttributesDefined(configuration);
            }
        };
        SpringContextConfigurationInspection.processConfigurations(contextConfiguration, searchParent, (Processor<SpringContextConfiguration>)searchLocationsProcessor);
        return searchLocationsProcessor.isFound();
    }

    private static boolean processConfigurations(@NotNull SpringContextConfiguration contextConfiguration, boolean searchParent, @NotNull Processor<SpringContextConfiguration> processor) {
        PsiClass psiClass;
        if (contextConfiguration == null) {
            SpringContextConfigurationInspection.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            SpringContextConfigurationInspection.$$$reportNull$$$0(7);
        }
        if (!processor.process((Object)contextConfiguration)) {
            return false;
        }
        if (searchParent && (psiClass = contextConfiguration.getPsiElement()) != null) {
            JamService service = JamService.getJamService((Project)psiClass.getProject());
            for (PsiClass superClass = psiClass.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                SpringContextConfiguration configuration = (SpringContextConfiguration)service.getJamElement((PsiElement)superClass, new JamMemberMeta[]{SpringContextConfiguration.META});
                if (configuration == null || processor.process((Object)configuration)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringContextConfigurationInspection" == null) {
            SpringContextConfigurationInspection.$$$reportNull$$$0(8);
        }
        return "SpringContextConfigurationInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTestingSqlConfig";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkContextConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasInnerConfigurations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processConfigurations";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

