/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.spring.toolWindow.SpringBaseView;
import com.intellij.spring.toolWindow.SpringToolWindowContent;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class SpringToolWindowFactory
implements ToolWindowFactory {
    public void createToolWindowContent(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            SpringToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            SpringToolWindowFactory.$$$reportNull$$$0(1);
        }
        toolWindow.setAvailable(true, null);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setContentUiType(ToolWindowContentUiType.TABBED, null);
        final ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContentManagerListener((ContentManagerListener)new MyContentManagerListener(project));
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                SpringToolWindowFactory.runUpdateContents(project, contentManager);
            }
        });
        ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(Facet facet) {
                SpringToolWindowFactory.runUpdateContents(project, contentManager);
            }

            public void facetRemoved(Facet facet) {
                SpringToolWindowFactory.runUpdateContents(project, contentManager);
            }
        }, (Disposable)project);
        SpringToolWindowFactory.runUpdateContents(project, contentManager);
    }

    private static void runUpdateContents(@NotNull Project project, ContentManager contentManager) {
        if (project == null) {
            SpringToolWindowFactory.$$$reportNull$$$0(2);
        }
        DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
            if (project == null) {
                SpringToolWindowFactory.$$$reportNull$$$0(3);
            }
            SpringToolWindowFactory.updateSpringToolWindowContents(project, contentManager);
        });
    }

    private static void updateSpringToolWindowContents(Project project, ContentManager contentManager) {
        ContentFactory factory = contentManager.getFactory();
        for (SpringToolWindowContent springToolWindowContent : (SpringToolWindowContent[])SpringToolWindowContent.EP_NAME.getExtensions()) {
            Content existing = contentManager.findContent(springToolWindowContent.displayName);
            if (!springToolWindowContent.isAvailable(project)) {
                if (existing == null) continue;
                contentManager.removeContent(existing, true);
                continue;
            }
            if (existing != null) continue;
            Content content = factory.createContent((JComponent)new SpringToolWindowContentStub(springToolWindowContent), springToolWindowContent.displayName, false);
            content.setCloseable(false);
            Icon icon = null;
            try {
                icon = IconLoader.getIcon((String)springToolWindowContent.icon, springToolWindowContent.getClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
            content.setPopupIcon(icon);
            contentManager.addContent(content);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/toolWindow/SpringToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runUpdateContents";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runUpdateContents$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SpringToolWindowContentStub
    extends JPanel {
        private final SpringToolWindowContent mySpringToolWindowContent;

        private SpringToolWindowContentStub(SpringToolWindowContent springToolWindowContent) {
            this.mySpringToolWindowContent = springToolWindowContent;
        }

        public SpringToolWindowContent getSpringToolWindowContent() {
            return this.mySpringToolWindowContent;
        }
    }

    private static class MyContentManagerListener
    extends ContentManagerAdapter {
        private final Project myProject;

        private MyContentManagerListener(Project project) {
            this.myProject = project;
        }

        public void selectionChanged(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content.getComponent() instanceof SpringToolWindowContentStub) {
                SpringToolWindowContentStub stub = (SpringToolWindowContentStub)content.getComponent();
                SpringToolWindowContent springToolWindowContent = stub.getSpringToolWindowContent();
                SpringBaseView view = springToolWindowContent.createSpringView(this.myProject);
                content.setComponent((JComponent)view);
                content.setHelpId(view.getHelpId());
                content.setPreferredFocusableComponent(view.getComponent());
            }
        }
    }
}

