/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code;

import org.jetbrains.java.decompiler.code.CodeConstants;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.JumpInstruction;
import org.jetbrains.java.decompiler.code.SwitchInstruction;

public class Instruction
implements CodeConstants {
    public final int opcode;
    public final int group;
    public final boolean wide;
    public final int bytecodeVersion;
    protected final int[] operands;

    public static Instruction create(int opcode, boolean wide, int group, int bytecodeVersion, int[] operands) {
        if (opcode >= 153 && opcode <= 166 || opcode == 198 || opcode == 199 || opcode == 168 || opcode == 201 || opcode == 167 || opcode == 200) {
            return new JumpInstruction(opcode, group, wide, bytecodeVersion, operands);
        }
        if (opcode == 170 || opcode == 171) {
            return new SwitchInstruction(opcode, group, wide, bytecodeVersion, operands);
        }
        return new Instruction(opcode, group, wide, bytecodeVersion, operands);
    }

    public static boolean equals(Instruction i1, Instruction i2) {
        return i1 != null && i2 != null && (i1 == i2 || i1.opcode == i2.opcode && i1.wide == i2.wide && i1.operandsCount() == i2.operandsCount());
    }

    public Instruction(int opcode, int group, boolean wide, int bytecodeVersion, int[] operands) {
        this.opcode = opcode;
        this.group = group;
        this.wide = wide;
        this.bytecodeVersion = bytecodeVersion;
        this.operands = operands;
    }

    public void initInstruction(InstructionSequence seq) {
    }

    public int operandsCount() {
        return this.operands == null ? 0 : this.operands.length;
    }

    public int operand(int index) {
        return this.operands[index];
    }

    public boolean canFallThrough() {
        return this.opcode != 167 && this.opcode != 200 && this.opcode != 169 && (this.opcode < 172 || this.opcode > 177) && this.opcode != 191 && this.opcode != 168 && this.opcode != 170 && this.opcode != 171;
    }

    public Instruction clone() {
        return Instruction.create(this.opcode, this.wide, this.group, this.bytecodeVersion, this.operands == null ? null : (int[])this.operands.clone());
    }
}

