/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.collectors.BytecodeSourceMapper;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.main.collectors.ImportCollector;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerPreferences;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.StructContext;

public class DecompilerContext {
    public static final String CURRENT_CLASS = "CURRENT_CLASS";
    public static final String CURRENT_CLASS_WRAPPER = "CURRENT_CLASS_WRAPPER";
    public static final String CURRENT_CLASS_NODE = "CURRENT_CLASS_NODE";
    public static final String CURRENT_METHOD_WRAPPER = "CURRENT_METHOD_WRAPPER";
    private static volatile DecompilerContext currentContext = null;
    private final Map<String, Object> properties;
    private final IFernflowerLogger logger;
    private final StructContext structContext;
    private final ClassesProcessor classProcessor;
    private final PoolInterceptor poolInterceptor;
    private ImportCollector importCollector;
    private VarProcessor varProcessor;
    private CounterContainer counterContainer;
    private BytecodeSourceMapper bytecodeSourceMapper;

    private DecompilerContext(Map<String, Object> properties, IFernflowerLogger logger, StructContext structContext, ClassesProcessor classProcessor, PoolInterceptor interceptor) {
        this.properties = properties;
        this.logger = logger;
        this.structContext = structContext;
        this.classProcessor = classProcessor;
        this.poolInterceptor = interceptor;
        this.counterContainer = new CounterContainer();
    }

    public static void initContext(Map<String, Object> customProperties, IFernflowerLogger logger, StructContext structContext, ClassesProcessor classProcessor, PoolInterceptor interceptor) {
        String level;
        Objects.requireNonNull(logger);
        Objects.requireNonNull(structContext);
        Objects.requireNonNull(classProcessor);
        HashMap<String, Object> properties = new HashMap<String, Object>(IFernflowerPreferences.DEFAULTS);
        if (customProperties != null) {
            properties.putAll(customProperties);
        }
        if ((level = (String)properties.get("log")) != null) {
            try {
                logger.setSeverity(IFernflowerLogger.Severity.valueOf(level.toUpperCase(Locale.US)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        currentContext = new DecompilerContext(properties, logger, structContext, classProcessor, interceptor);
    }

    public static void clearContext() {
        currentContext = null;
    }

    public static void setProperty(String key, Object value) {
        DecompilerContext.currentContext.properties.put(key, value);
    }

    public static void startClass(ImportCollector importCollector) {
        DecompilerContext.currentContext.importCollector = importCollector;
        DecompilerContext.currentContext.counterContainer = new CounterContainer();
        DecompilerContext.currentContext.bytecodeSourceMapper = new BytecodeSourceMapper();
    }

    public static void startMethod(VarProcessor varProcessor) {
        DecompilerContext.currentContext.varProcessor = varProcessor;
        DecompilerContext.currentContext.counterContainer = new CounterContainer();
    }

    public static Object getProperty(String key) {
        return DecompilerContext.currentContext.properties.get(key);
    }

    public static boolean getOption(String key) {
        return "1".equals(DecompilerContext.getProperty(key));
    }

    public static String getNewLineSeparator() {
        return DecompilerContext.getOption("nls") ? "\n" : "\r\n";
    }

    public static IFernflowerLogger getLogger() {
        return DecompilerContext.currentContext.logger;
    }

    public static StructContext getStructContext() {
        return DecompilerContext.currentContext.structContext;
    }

    public static ClassesProcessor getClassProcessor() {
        return DecompilerContext.currentContext.classProcessor;
    }

    public static PoolInterceptor getPoolInterceptor() {
        return DecompilerContext.currentContext.poolInterceptor;
    }

    public static ImportCollector getImportCollector() {
        return DecompilerContext.currentContext.importCollector;
    }

    public static VarProcessor getVarProcessor() {
        return DecompilerContext.currentContext.varProcessor;
    }

    public static CounterContainer getCounterContainer() {
        return DecompilerContext.currentContext.counterContainer;
    }

    public static BytecodeSourceMapper getBytecodeSourceMapper() {
        return DecompilerContext.currentContext.bytecodeSourceMapper;
    }
}

