/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.config.SpringBootConfigFileHighlightingUtil;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public class SpringBootApplicationYamlInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpringBootApplicationYamlInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringBootApplicationYamlInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof YAMLFile)) {
            return null;
        }
        YAMLFile yamlFile = (YAMLFile)file;
        if (!SpringCommonUtils.hasSpringFacets((Project)manager.getProject()) || !SpringBootApplicationYamlUtil.isApplicationYamlFile(yamlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (!SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        final SpringBootConfigFileHighlightingUtil configFileHighlightingUtil = new SpringBootConfigFileHighlightingUtil(holder);
        List yamlDocuments = yamlFile.getDocuments();
        final boolean hasMultipleDocuments = yamlDocuments.size() > 1;
        for (YAMLDocument document : yamlDocuments) {
            final MultiMap duplicates = new MultiMap();
            document.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    if (!(element instanceof YAMLKeyValue)) {
                        return;
                    }
                    YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
                    PsiElement keyElement = yamlKeyValue.getKey();
                    if (keyElement == null) {
                        return;
                    }
                    YAMLValue valueElement = yamlKeyValue.getValue();
                    if (valueElement != null && !(valueElement instanceof YAMLScalar) && !(valueElement instanceof YAMLSequence)) {
                        return;
                    }
                    if (valueElement != null) {
                        if (valueElement instanceof YAMLScalar) {
                            configFileHighlightingUtil.highlightValueReferences((PsiElement)valueElement);
                        } else {
                            YAMLSequence sequence = (YAMLSequence)valueElement;
                            for (YAMLSequenceItem item : sequence.getItems()) {
                                YAMLValue itemValue = item.getValue();
                                if (!(itemValue instanceof YAMLScalar)) continue;
                                configFileHighlightingUtil.highlightValueReferences((PsiElement)itemValue);
                            }
                        }
                    }
                    if (PsiTreeUtil.getContextOfType((PsiElement)yamlKeyValue, (Class[])new Class[]{YAMLSequenceItem.class}) != null) {
                        return;
                    }
                    SpringBootApplicationMetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)yamlKeyValue);
                    if (configKey == null) {
                        String qualifiedConfigKeyName = SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(yamlKeyValue);
                        if (hasMultipleDocuments && "spring.profiles".equals(qualifiedConfigKeyName)) {
                            return;
                        }
                        configFileHighlightingUtil.highlightUnresolvedConfigKey(keyElement, qualifiedConfigKeyName);
                        return;
                    }
                    if (configKey.getDeprecation() != SpringBootApplicationMetaConfigKey.Deprecation.NOT_DEPRECATED) {
                        configFileHighlightingUtil.highlightDeprecatedConfigKey(keyElement, configKey, new LocalQuickFix[0]);
                    }
                    if (!configKey.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.MAP_GROUP)) {
                        duplicates.putValue((Object)configKey.getName(), (Object)yamlKeyValue);
                    }
                }
            });
            for (Map.Entry entry : duplicates.entrySet()) {
                final Collection values = (Collection)entry.getValue();
                if (values.size() == 1) continue;
                final String configKey = (String)entry.getKey();
                LocalQuickFixBase showDuplicatesFix = new LocalQuickFixBase("Show Duplicates for '" + configKey + "'", "Show Duplicates"){

                    public boolean startInWriteAction() {
                        return false;
                    }

                    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        if (project == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (descriptor == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        DataManager.getInstance().getDataContextFromFocus().doWhenDone(context -> NavigationUtil.getPsiElementPopup((PsiElement[])values.toArray(new PsiElement[values.size()]), (String)("Duplicates for '" + configKey + "'")).showInBestPositionFor(context));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "project";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "descriptor";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlInspection$2";
                        objectArray[2] = "applyFix";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                for (YAMLKeyValue keyValue : values) {
                    holder.registerProblem((PsiElement)keyValue, "Duplicate configuration key '" + configKey + "'", new LocalQuickFix[]{showDuplicatesFix});
                }
            }
        }
        return holder.getResultsArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

