/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlAccessor;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlReferenceContributor;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.hash.HashSet;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.completion.YamlKeyCompletionInsertHandler;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;

public class SpringBootApplicationYamlKeyCompletionContributor
extends CompletionContributor {
    public SpringBootApplicationYamlKeyCompletionContributor() {
        MyKeyCompletionProvider provider = new MyKeyCompletionProvider();
        PsiElementPattern.Capture psiElementCapture = (PsiElementPattern.Capture)PlatformPatterns.psiElement().andNot((ElementPattern)PlatformPatterns.psiComment());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)psiElementCapture.withSuperParent(2, YAMLMapping.class)).andNot((ElementPattern)PlatformPatterns.psiElement(PsiComment.class))).with(SpringBootApplicationYamlReferenceContributor.APPLICATION_YAML_SB_1_2_OR_HIGHER), provider);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)psiElementCapture.withSuperParent(2, YAMLDocument.class)).with(SpringBootApplicationYamlReferenceContributor.APPLICATION_YAML_SB_1_2_OR_HIGHER), provider);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)psiElementCapture.withParent((ElementPattern)PlatformPatterns.psiElement(YAMLScalar.class).afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)YAMLTokenTypes.INDENT)))).with(SpringBootApplicationYamlReferenceContributor.APPLICATION_YAML_SB_1_2_OR_HIGHER), provider);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)psiElementCapture.afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)YAMLTokenTypes.INDENT))).with(SpringBootApplicationYamlReferenceContributor.APPLICATION_YAML_SB_1_2_OR_HIGHER), provider);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(LeafPsiElement.class).withElementType((IElementType)YAMLTokenTypes.SCALAR_KEY)).withParent(YAMLKeyValue.class)).with(SpringBootApplicationYamlReferenceContributor.APPLICATION_YAML_SB_1_2_OR_HIGHER), provider);
    }

    private static class MyKeyCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final Key<String> CONFIG_KEY = Key.create((String)"ymlConfigKey");
        private static final InsertHandler<LookupElementDecorator<LookupElementBuilder>> INSERT_HANDLER = new YamlKeyCompletionInsertHandler<LookupElementDecorator<LookupElementBuilder>>(){

            @NotNull
            protected YAMLKeyValue createNewEntry(@NotNull YAMLDocument document, LookupElementDecorator<LookupElementBuilder> item) {
                if (document == null) {
                    1.$$$reportNull$$$0(0);
                }
                String qualifiedKey = (String)item.getCopyableUserData(CONFIG_KEY);
                assert (qualifiedKey != null);
                SpringBootApplicationYamlAccessor accessor = new SpringBootApplicationYamlAccessor(document);
                YAMLKeyValue keyValue = accessor.create(qualifiedKey);
                assert (keyValue != null) : qualifiedKey;
                YAMLKeyValue yAMLKeyValue = keyValue;
                if (yAMLKeyValue == null) {
                    1.$$$reportNull$$$0(1);
                }
                return yAMLKeyValue;
            }

            public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElementBuilder> item) {
                super.handleInsert(context, item);
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlKeyCompletionContributor$MyKeyCompletionProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlKeyCompletionContributor$MyKeyCompletionProvider$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createNewEntry";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createNewEntry";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        private static final InsertHandler<LookupElement> INSERT_COLON_INSERT_HANDLER = new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement lookupElement) {
                if (YamlKeyCompletionInsertHandler.isCharAtCaret((Editor)context.getEditor(), (char)':')) {
                    context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, false);
                } else {
                    EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)":");
                }
            }
        };

        private MyKeyCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            int invocationCount;
            if (parameters == null) {
                MyKeyCompletionProvider.$$$reportNull$$$0(0);
            }
            if (result == null) {
                MyKeyCompletionProvider.$$$reportNull$$$0(1);
            }
            YAMLFile yamlFile = (YAMLFile)parameters.getOriginalFile();
            PsiElement element = parameters.getPosition();
            PsiElement originalElement = CompletionUtil.getOriginalElement((PsiElement)element);
            YAMLKeyValue parentYamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)originalElement, YAMLKeyValue.class);
            if (parentYamlKeyValue == null) {
                parentYamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
            }
            if (element.getNode().getElementType() == YAMLTokenTypes.SCALAR_KEY) {
                parentYamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)parentYamlKeyValue, YAMLKeyValue.class);
            }
            if ((invocationCount = parameters.getInvocationCount()) <= 1) {
                result.addLookupAdvertisement("Press " + SpringBootApplicationYamlKeyCompletionContributor.getActionShortcut((String)"CodeCompletion") + " to see all configuration keys with different prefix");
            }
            String fullParentConfigName = SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(parentYamlKeyValue);
            String parentConfigKeyName = parentYamlKeyValue == null || invocationCount > 1 ? "" : fullParentConfigName;
            SpringBootApplicationYamlAccessor accessor = new SpringBootApplicationYamlAccessor((PsiElement)ObjectUtils.chooseNotNull((Object)originalElement, (Object)element));
            List configKeys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys((PsiElement)yamlFile);
            if (originalElement != null && (originalElement.getNode().getElementType() == YAMLTokenTypes.SCALAR_KEY || originalElement.getParent() instanceof YAMLScalar)) {
                MyKeyCompletionProvider.addCurrentLineKeyComponents(result, fullParentConfigName, configKeys);
            }
            int maxVariants = Registry.intValue((String)"ide.completion.variant.limit");
            int count = 0;
            ArrayList<LookupElement> keyLookupElements = new ArrayList<LookupElement>();
            for (SpringBootApplicationMetaConfigKey configKey : configKeys) {
                if (!parentConfigKeyName.isEmpty() && !configKey.matchesPrefix(parentConfigKeyName) || accessor.findExistingKey(configKey.getName()) != null) continue;
                if (count++ == maxVariants) break;
                LookupElementBuilder builder = configKey.getPresentation().getLookupElement();
                builder.putCopyableUserData(CONFIG_KEY, (Object)configKey.getName());
                LookupElementDecorator insertHandler = LookupElementDecorator.withInsertHandler((LookupElement)builder, INSERT_HANDLER);
                LookupElement lookupElement = configKey.getPresentation().tuneLookupElement((LookupElement)insertHandler);
                keyLookupElements.add(lookupElement);
            }
            result.addAllElements(keyLookupElements);
            if (yamlFile.getDocuments().size() > 1 && accessor.findExistingKey("spring.profiles") == null) {
                LookupElementBuilder builder = LookupElementBuilder.create((String)"spring.profiles").withIcon(SpringApiIcons.SpringProfile).withTailText(" (Define profile(s) for this document)", true);
                builder.putCopyableUserData(CONFIG_KEY, (Object)"spring.profiles");
                LookupElementDecorator decorator = LookupElementDecorator.withInsertHandler((LookupElement)builder, INSERT_HANDLER);
                result.addElement((LookupElement)decorator);
            }
            result.stopHere();
        }

        private static void addCurrentLineKeyComponents(@NotNull CompletionResultSet result, @NotNull String parentConfigKeyName, @NotNull List<SpringBootApplicationMetaConfigKey> keys) {
            if (result == null) {
                MyKeyCompletionProvider.$$$reportNull$$$0(2);
            }
            if (parentConfigKeyName == null) {
                MyKeyCompletionProvider.$$$reportNull$$$0(3);
            }
            if (keys == null) {
                MyKeyCompletionProvider.$$$reportNull$$$0(4);
            }
            HashSet addedKeys = new HashSet();
            int parentComponents = StringUtil.countChars((CharSequence)parentConfigKeyName, (char)'.') + 1;
            for (SpringBootApplicationMetaConfigKey key : keys) {
                String intermediateKey;
                List components;
                if (!parentConfigKeyName.isEmpty() && !key.matchesPrefix(parentConfigKeyName) || (components = StringUtil.split((String)key.getName(), (String)".")).size() <= parentComponents || addedKeys.contains(intermediateKey = (String)components.get(parentComponents)) || components.size() == parentComponents + 1) continue;
                addedKeys.add(intermediateKey);
                result.addElement((LookupElement)LookupElementBuilder.create((String)intermediateKey).withIcon(AllIcons.Nodes.Property).withInsertHandler(INSERT_COLON_INSERT_HANDLER));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentConfigKeyName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlKeyCompletionContributor$MyKeyCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCurrentLineKeyComponents";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

