/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlAccessor;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public class SpringBootModelApplicationYamlConfigFileContributor
extends SpringBootModelConfigFileContributor {
    public SpringBootModelApplicationYamlConfigFileContributor() {
        super((FileType)YAMLFileType.YML);
    }

    @NotNull
    public List<SpringBootModelConfigFileContributor.ConfigurationValueResult> findConfigurationValues(PsiFile configFile, SpringBootApplicationMetaConfigKey key, boolean checkRelaxedNames, @Nullable Set<String> activeProfiles) {
        Pair<YAMLFile, Boolean> relevantFileInfo = SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevantFile(configFile, activeProfiles);
        if (relevantFileInfo == null) {
            List<SpringBootModelConfigFileContributor.ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(0);
            }
            return list;
        }
        String keyName = key.getName();
        SmartList results = new SmartList();
        Processor processor = arg_0 -> SpringBootModelApplicationYamlConfigFileContributor.lambda$findConfigurationValues$0(keyName, (List)results, checkRelaxedNames, key, arg_0);
        YAMLFile yamlFile = (YAMLFile)relevantFileInfo.first;
        if (!((Boolean)relevantFileInfo.second).booleanValue()) {
            boolean processAllDocuments = activeProfiles == PROCESS_ALL_PROFILES;
            for (YAMLDocument document : yamlFile.getDocuments()) {
                if (!processAllDocuments && !SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevantDocument(document, activeProfiles) || SpringBootApplicationYamlAccessor.processAllKeys((YAMLPsiElement)document, (Processor<YAMLKeyValue>)processor) || processAllDocuments) continue;
                break;
            }
            SmartList smartList = results;
            if (smartList == null) {
                SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(1);
            }
            return smartList;
        }
        YAMLDocument profileDocument = (YAMLDocument)ContainerUtil.getFirstItem((List)yamlFile.getDocuments());
        if (profileDocument != null && !SpringBootApplicationYamlAccessor.processAllKeys((YAMLPsiElement)profileDocument, (Processor<YAMLKeyValue>)processor)) {
            SmartList smartList = results;
            if (smartList == null) {
                SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(2);
            }
            return smartList;
        }
        List<SpringBootModelConfigFileContributor.ConfigurationValueResult> list = Collections.emptyList();
        if (list == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static void processYamlKeyValue(List<SpringBootModelConfigFileContributor.ConfigurationValueResult> results, YAMLKeyValue yamlKeyValue) {
        PsiElement keyElement = yamlKeyValue.getKey();
        YAMLValue valueElement = yamlKeyValue.getValue();
        if (valueElement instanceof YAMLSequence) {
            YAMLSequence sequence = (YAMLSequence)valueElement;
            for (YAMLSequenceItem item : sequence.getItems()) {
                YAMLValue itemValue = item.getValue();
                if (!(itemValue instanceof YAMLScalar)) continue;
                results.add(new YamlConfigurationValueResult(yamlKeyValue, keyElement, (PsiElement)itemValue, itemValue.getText()));
            }
            return;
        }
        if (valueElement instanceof YAMLMapping) {
            YAMLMapping mapping = (YAMLMapping)valueElement;
            for (YAMLKeyValue mapKeyValue : mapping.getKeyValues()) {
                results.add(new YamlConfigurationValueResult(mapKeyValue, mapKeyValue.getKey(), (PsiElement)mapKeyValue.getValue(), mapKeyValue.getValueText()));
            }
            return;
        }
        results.add(new YamlConfigurationValueResult(yamlKeyValue, keyElement, (PsiElement)valueElement, yamlKeyValue.getValueText()));
    }

    private static boolean isProfileRelevantDocument(YAMLDocument document, Set<String> activeProfiles) {
        if (ContainerUtil.isEmpty(activeProfiles)) {
            return true;
        }
        SpringBootApplicationYamlAccessor accessor = new SpringBootApplicationYamlAccessor(document);
        YAMLKeyValue profilesKey = accessor.findExistingKey("spring.profiles");
        if (profilesKey == null) {
            return false;
        }
        String profileText = profilesKey.getValueText();
        return activeProfiles.contains(profileText);
    }

    @Nullable
    private static Pair<YAMLFile, Boolean> isProfileRelevantFile(PsiFile configFile, @Nullable Set<String> activeProfiles) {
        if (!(configFile instanceof YAMLFile)) {
            return null;
        }
        YAMLFile yamlFile = (YAMLFile)configFile;
        if (ContainerUtil.isEmpty(activeProfiles) || activeProfiles == PROCESS_ALL_PROFILES) {
            return Pair.create((Object)yamlFile, (Object)false);
        }
        String fileName = yamlFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        if (profileSuffix == null) {
            return Pair.create((Object)yamlFile, (Object)false);
        }
        boolean isInActiveProfiles = activeProfiles.contains(profileSuffix);
        return isInActiveProfiles ? Pair.create((Object)yamlFile, (Object)true) : null;
    }

    private static /* synthetic */ boolean lambda$findConfigurationValues$0(String keyName, List results, boolean checkRelaxedNames, SpringBootApplicationMetaConfigKey key, YAMLKeyValue keyValue) {
        ProgressManager.checkCanceled();
        String qualifiedKeyName = SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(keyValue);
        if (qualifiedKeyName.equals(keyName)) {
            SpringBootModelApplicationYamlConfigFileContributor.processYamlKeyValue(results, keyValue);
            return false;
        }
        if (!checkRelaxedNames) {
            return true;
        }
        if (key.matches(qualifiedKeyName)) {
            SpringBootModelApplicationYamlConfigFileContributor.processYamlKeyValue(results, keyValue);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/yaml/SpringBootModelApplicationYamlConfigFileContributor", "findConfigurationValues"));
    }

    private static class YamlConfigurationValueResult
    extends SpringBootModelConfigFileContributor.ConfigurationValueResult {
        @NotNull
        private final YAMLKeyValue myValue;

        YamlConfigurationValueResult(@NotNull YAMLKeyValue yamlKeyValue, @Nullable PsiElement keyElement, @Nullable PsiElement valueElement, @Nullable String valueText) {
            if (yamlKeyValue == null) {
                YamlConfigurationValueResult.$$$reportNull$$$0(0);
            }
            super(keyElement, valueElement, valueText);
            this.myValue = yamlKeyValue;
        }

        @Nullable
        public MetaConfigKeyReference getMetaConfigKeyReference() {
            return (MetaConfigKeyReference)ContainerUtil.findInstance((Object[])this.myValue.getReferences(), MetaConfigKeyReference.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yamlKeyValue", "com/intellij/spring/boot/application/yaml/SpringBootModelApplicationYamlConfigFileContributor$YamlConfigurationValueResult", "<init>"));
        }
    }
}

