/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;

public class CommandPartition3
extends SingleLineCommand2<ActivityDiagram3> {
    public CommandPartition3() {
        super(CommandPartition3.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("partition"), new RegexLeaf("[%s]+"), new RegexOptional((IRegex)new RegexConcat(CommandPartition3.color().getRegex(), new RegexLeaf("[%s]+"))), new RegexLeaf("TITLECOLOR", "(?:(#\\w+)[%s]+)?"), new RegexLeaf("NAME", "([%g][^%g]+[%g]|\\S+)"), new RegexLeaf("[%s]*\\{?$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, RegexResult arg) {
        String partitionTitle = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("NAME", 0));
        HtmlColor titleColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("TITLECOLOR", 0));
        Colors colors = CommandPartition3.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        HtmlColor backColorInSkinparam = diagram.getSkinParam().getHtmlColor(ColorParam.partitionBackground, null, false);
        HtmlColor backColor = backColorInSkinparam == null ? colors.getColor(ColorType.BACK) : backColorInSkinparam;
        HtmlColor borderColor = diagram.getSkinParam().getHtmlColor(ColorParam.partitionBorder, null, false);
        if (borderColor == null) {
            borderColor = HtmlColorUtils.BLACK;
        }
        diagram.startGroup(Display.getWithNewlines(partitionTitle), backColor, titleColor, borderColor);
        return CommandExecutionResult.ok();
    }
}

