/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class FtileEmpty
extends AbstractFtile {
    private final double width;
    private final double height;
    private final Swimlane swimlaneIn;
    private final Swimlane swimlaneOut;

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    public FtileEmpty(ISkinParam skinParam, double width, double height) {
        this(skinParam, width, height, null, null);
    }

    public FtileEmpty(ISkinParam skinParam, double width, double height, Swimlane swimlaneIn, Swimlane swimlaneOut) {
        super(skinParam);
        this.width = width;
        this.height = height;
        this.swimlaneIn = swimlaneIn;
        this.swimlaneOut = swimlaneOut;
    }

    public FtileEmpty(ISkinParam skinParam) {
        this(skinParam, 0.0, 0.0, null, null);
    }

    public FtileEmpty(ISkinParam skinParam, Swimlane swimlane) {
        this(skinParam, 0.0, 0.0, swimlane, swimlane);
    }

    public String toString() {
        return "FtileEmpty";
    }

    @Override
    public void drawU(UGraphic ug) {
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        return new FtileGeometry(this.width, this.height, this.width / 2.0, 0.0, this.height);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlaneIn;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlaneOut;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.swimlaneIn != null) {
            result.add(this.swimlaneIn);
        }
        if (this.swimlaneOut != null) {
            result.add(this.swimlaneOut);
        }
        return Collections.unmodifiableSet(result);
    }
}

