/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowDressing;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseArrow
extends AbstractComponentRoseArrow {
    private final HorizontalAlignment messagePosition;
    private final boolean niceArrow;
    public static final double spaceCrossX = 6.0;
    public static final double diamCircle = 8.0;
    public static final double thinCircle = 1.5;

    public ComponentRoseArrow(HtmlColor foregroundColor, FontConfiguration font, Display stringsToDisplay, ArrowConfiguration arrowConfiguration, HorizontalAlignment messagePosition, ISkinSimple spriteContainer, HorizontalAlignment textHorizontalAlignment, LineBreakStrategy maxMessageSize, boolean niceArrow) {
        super(foregroundColor, font, stringsToDisplay, arrowConfiguration, spriteContainer, textHorizontalAlignment, maxMessageSize);
        this.messagePosition = messagePosition;
        this.niceArrow = niceArrow;
    }

    @Override
    public void drawInternalU(UGraphic ug, Area area) {
        double textPos;
        if (this.getArrowConfiguration().isHidden()) {
            return;
        }
        Dimension2D dimensionToUse = area.getDimensionToUse();
        StringBounder stringBounder = ug.getStringBounder();
        int textHeight = (int)this.getTextHeight(stringBounder);
        ug = ug.apply(new UChangeColor(this.getForegroundColor()));
        ArrowDressing dressing1 = this.getArrowConfiguration().getDressing1();
        ArrowDressing dressing2 = this.getArrowConfiguration().getDressing2();
        double start = 0.0;
        double len = dimensionToUse.getWidth() - 1.0;
        double pos1 = start + 1.0;
        double pos2 = len - 1.0;
        if (this.getArrowConfiguration().getDecoration2() == ArrowDecoration.CIRCLE && dressing2.getHead() == ArrowHead.NONE) {
            len -= 4.0;
        }
        if (this.getArrowConfiguration().getDecoration2() == ArrowDecoration.CIRCLE && dressing2.getHead() != ArrowHead.NONE) {
            len -= 5.5;
        }
        if (this.getArrowConfiguration().getDecoration1() == ArrowDecoration.CIRCLE && dressing1.getHead() == ArrowHead.NONE) {
            start += 4.0;
            len -= 4.0;
        }
        if (this.getArrowConfiguration().getDecoration1() == ArrowDecoration.CIRCLE && dressing1.getHead() == ArrowHead.NORMAL) {
            start += 9.5;
            len -= 9.5;
        }
        this.drawDressing1(ug, pos1, dressing1, this.getArrowConfiguration().getDecoration1());
        this.drawDressing2(ug, pos2, dressing2, this.getArrowConfiguration().getDecoration2());
        if (dressing2.getPart() == ArrowPart.FULL && dressing2.getHead() == ArrowHead.NORMAL) {
            len -= (double)(this.getArrowDeltaX() / 2);
        }
        if (dressing1.getPart() == ArrowPart.FULL && dressing1.getHead() == ArrowHead.NORMAL) {
            start += (double)(this.getArrowDeltaX() / 2);
            len -= (double)(this.getArrowDeltaX() / 2);
        }
        if (dressing2.getHead() == ArrowHead.CROSSX) {
            len -= 12.0;
        }
        if (dressing1.getHead() == ArrowHead.CROSSX) {
            start += 12.0;
            len -= 12.0;
        }
        this.getArrowConfiguration().applyStroke(ug).apply(new UTranslate(start, textHeight)).draw(new ULine(len, 0.0));
        ArrowDirection direction2 = this.getDirection2();
        if (this.messagePosition == HorizontalAlignment.CENTER) {
            double textWidth = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            textPos = (dimensionToUse.getWidth() - textWidth) / 2.0;
        } else if (this.messagePosition == HorizontalAlignment.RIGHT) {
            double textWidth = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            textPos = dimensionToUse.getWidth() - textWidth - (double)this.getMarginX2() - (double)(direction2 == ArrowDirection.LEFT_TO_RIGHT_NORMAL ? this.getArrowDeltaX() : 0);
        } else {
            textPos = this.getMarginX1() + (direction2 == ArrowDirection.RIGHT_TO_LEFT_REVERSE || direction2 == ArrowDirection.BOTH_DIRECTION ? this.getArrowDeltaX() : 0);
        }
        this.getTextBlock().drawU(ug.apply(new UTranslate(textPos, 0.0)));
    }

    private void drawDressing1(UGraphic ug, double x, ArrowDressing dressing, ArrowDecoration decoration) {
        StringBounder stringBounder = ug.getStringBounder();
        int textHeight = (int)this.getTextHeight(stringBounder);
        if (decoration == ArrowDecoration.CIRCLE) {
            UEllipse circle = new UEllipse(8.0, 8.0);
            ug.apply(new UStroke(1.5)).apply(new UChangeColor(this.getForegroundColor())).apply(new UTranslate(x - 4.0 - 1.5, (double)textHeight - 4.0 - 0.75)).draw(circle);
            x += 5.5;
        }
        if (dressing.getHead() == ArrowHead.ASYNC) {
            if (dressing.getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x - 1.0, textHeight)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
            if (dressing.getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x - 1.0, textHeight)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
        } else if (dressing.getHead() == ArrowHead.CROSSX) {
            ug = ug.apply(new UStroke(2.0));
            ug.apply(new UTranslate(6.0, textHeight - this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            ug.apply(new UTranslate(6.0, textHeight + this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
        } else if (dressing.getHead() == ArrowHead.NORMAL) {
            UPolygon polygon = this.getPolygonReverse(dressing.getPart(), textHeight);
            ug.apply(new UChangeBackColor(this.getForegroundColor())).apply(new UTranslate(x, 0.0)).draw(polygon);
        }
    }

    private void drawDressing2(UGraphic ug, double x, ArrowDressing dressing, ArrowDecoration decoration) {
        StringBounder stringBounder = ug.getStringBounder();
        int textHeight = (int)this.getTextHeight(stringBounder);
        if (decoration == ArrowDecoration.CIRCLE) {
            ug = ug.apply(new UStroke(1.5)).apply(new UChangeColor(this.getForegroundColor()));
            UEllipse circle = new UEllipse(8.0, 8.0);
            ug.apply(new UTranslate(x - 4.0 + 1.5, (double)textHeight - 4.0 - 0.75)).draw(circle);
            ug = ug.apply(new UStroke());
            x -= 5.5;
        }
        if (dressing.getHead() == ArrowHead.ASYNC) {
            if (dressing.getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x, textHeight)).draw(new ULine(-this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
            if (dressing.getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x, textHeight)).draw(new ULine(-this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
        } else if (dressing.getHead() == ArrowHead.CROSSX) {
            ug = ug.apply(new UStroke(2.0));
            ug.apply(new UTranslate(x - 6.0 - (double)this.getArrowDeltaX(), textHeight - this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            ug.apply(new UTranslate(x - 6.0 - (double)this.getArrowDeltaX(), textHeight + this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
            ug = ug.apply(new UStroke());
        } else if (dressing.getHead() == ArrowHead.NORMAL) {
            UPolygon polygon = this.getPolygonNormal(dressing.getPart(), textHeight, x);
            ug.apply(new UChangeBackColor(this.getForegroundColor())).draw(polygon);
        }
    }

    private UPolygon getPolygonNormal(ArrowPart part, int textHeight, double x2) {
        UPolygon polygon = new UPolygon();
        if (part == ArrowPart.TOP_PART) {
            polygon.addPoint(x2 - (double)this.getArrowDeltaX(), textHeight - this.getArrowDeltaY());
            polygon.addPoint(x2, textHeight);
            polygon.addPoint(x2 - (double)this.getArrowDeltaX(), textHeight);
        } else if (part == ArrowPart.BOTTOM_PART) {
            polygon.addPoint(x2 - (double)this.getArrowDeltaX(), textHeight + 1);
            polygon.addPoint(x2, textHeight + 1);
            polygon.addPoint(x2 - (double)this.getArrowDeltaX(), textHeight + this.getArrowDeltaY() + 1);
        } else {
            polygon.addPoint(x2 - (double)this.getArrowDeltaX(), textHeight - this.getArrowDeltaY());
            polygon.addPoint(x2, textHeight);
            polygon.addPoint(x2 - (double)this.getArrowDeltaX(), textHeight + this.getArrowDeltaY());
            if (this.niceArrow) {
                polygon.addPoint(x2 - (double)this.getArrowDeltaX() + 4.0, textHeight);
            }
        }
        return polygon;
    }

    private UPolygon getPolygonReverse(ArrowPart part, int textHeight) {
        UPolygon polygon = new UPolygon();
        if (part == ArrowPart.TOP_PART) {
            polygon.addPoint(this.getArrowDeltaX(), textHeight - this.getArrowDeltaY());
            polygon.addPoint(0.0, textHeight);
            polygon.addPoint(this.getArrowDeltaX(), textHeight);
        } else if (part == ArrowPart.BOTTOM_PART) {
            polygon.addPoint(this.getArrowDeltaX(), textHeight + 1);
            polygon.addPoint(0.0, textHeight + 1);
            polygon.addPoint(this.getArrowDeltaX(), textHeight + this.getArrowDeltaY() + 1);
        } else {
            polygon.addPoint(this.getArrowDeltaX(), textHeight - this.getArrowDeltaY());
            polygon.addPoint(0.0, textHeight);
            polygon.addPoint(this.getArrowDeltaX(), textHeight + this.getArrowDeltaY());
            if (this.niceArrow) {
                polygon.addPoint(this.getArrowDeltaX() - 4, textHeight);
            }
        }
        return polygon;
    }

    @Override
    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimensionToUse) {
        int textHeight = (int)this.getTextHeight(stringBounder);
        if (this.getDirection2() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return new Point2D.Double(this.getPaddingX(), (double)textHeight + this.getPaddingY());
        }
        return new Point2D.Double(dimensionToUse.getWidth() + this.getPaddingX(), (double)textHeight + this.getPaddingY());
    }

    @Override
    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimensionToUse) {
        int textHeight = (int)this.getTextHeight(stringBounder);
        if (this.getDirection2() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return new Point2D.Double(dimensionToUse.getWidth() + this.getPaddingX(), (double)textHeight + this.getPaddingY());
        }
        return new Point2D.Double(this.getPaddingX(), (double)textHeight + this.getPaddingY());
    }

    private final ArrowDirection getDirection2() {
        return this.getArrowConfiguration().getArrowDirection();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + 2.0 * this.getPaddingY();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + (double)this.getArrowDeltaX();
    }
}

