/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class DumpSpringMVCModelAction
extends AnAction {
    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean hasSpring = project != null && SpringCommonUtils.hasSpringFacets((Project)project);
        e.getPresentation().setEnabled(hasSpring);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Runnable process = () -> {
            String dump = (String)ReadAction.compute(() -> DumpSpringMVCModelAction.getMvcModelDump(project));
            UIUtil.invokeLaterIfNeeded(() -> {
                Messages.InputDialog dialog = new Messages.InputDialog(project, "", "Spring MVC Model Dump", null, dump, null){

                    protected JTextComponent createTextFieldComponent() {
                        return new JTextArea(20, 120);
                    }

                    protected JComponent createScrollableTextComponent() {
                        return new JBScrollPane((Component)this.myField);
                    }
                };
                dialog.show();
            });
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(process, "Gathering Spring MVC Models", true, project);
    }

    private static String getMvcModelDump(Project project) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        Module[] modules = ModuleManager.getInstance((Project)project).getSortedModules();
        StringBuilder dump = new StringBuilder();
        int processedModules = 0;
        for (Module module : modules) {
            pi.checkCanceled();
            String name = module.getName();
            dump.append(name).append(" ").append(StringUtil.repeatSymbol((char)'=', (int)Math.max(1, 100 - name.length()))).append("\n");
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet == null) {
                dump.append("no Spring facet");
            } else {
                Collection webFacets = WebFacet.getInstances((Module)module);
                if (webFacets.isEmpty()) {
                    dump.append("no Web facets");
                } else {
                    DumpSpringMVCModelAction.dumpModule(dump, springFacet, webFacets);
                }
            }
            dump.append("\n\n");
            pi.setFraction((double)(++processedModules) / (double)modules.length);
        }
        return dump.toString();
    }

    private static void dumpModule(StringBuilder dump, SpringFacet springFacet, Collection<WebFacet> webFacets) {
        SpringFileSet fileSet;
        SpringMVCModel model = SpringMVCModelService.getInstance().getModel(webFacets.iterator().next(), springFacet);
        if (model == null) {
            dump.append("No Spring MVC model");
            return;
        }
        dump.append("Servlet models:\n");
        Collection servletModels = model.getServletModels();
        for (SpringModel servletModel : servletModels) {
            fileSet = servletModel.getFileSet();
            assert (fileSet != null) : servletModel;
            dump.append(" ").append(fileSet.getId());
        }
        dump.append("\nRoot models:\n");
        for (SpringModel allModel : model.getAllModels()) {
            if (servletModels.contains(allModel)) continue;
            fileSet = allModel.getFileSet();
            assert (fileSet != null) : allModel;
            dump.append(" ").append(fileSet.getId());
        }
        dump.append("\n\nServlet mapping:\n");
        ServletMappingInfo info = model.getServletMappingInfo();
        if (info == null) {
            dump.append("NONE\n");
        } else {
            dump.append("'").append(info.getUrlPattern()).append("' ").append(info.getServlet().getServletName().getStringValue()).append(" (in ").append(info.getServlet().getContainingFile()).append(")");
        }
        PsiClass dummyPsiElement = info == null ? null : info.getServlet().getPsiClass();
        dump.append("\n\nView Resolvers:\n");
        dump.append(" hasUnknown: ").append(model.hasUnknownResolvers());
        for (ViewResolver resolver : model.getViewResolvers()) {
            dump.append("\n ").append(resolver.toString()).append(" [").append(resolver.getID()).append("]");
            if (dummyPsiElement == null) continue;
            dump.append("\n    ").append(StringUtil.join((Collection)ContainerUtil.map((Collection)resolver.getAllViews((PsiElement)dummyPsiElement, model), element -> element.getLookupString()), (String)", "));
        }
        dump.append("\n\nURLs:");
        for (SpringMVCModel.Variant variant : model.getAllUrls()) {
            PsiElement resolve = variant.getPsiElementPointer().getPsiElement();
            PsiFile finalResolve = resolve != null ? resolve.getContainingFile() : null;
            dump.append("\n").append(variant.getLookupString()).append(" ").append(RequestMethod.getDisplay((RequestMethod[])variant.getMethod())).append(" ").append(finalResolve);
        }
    }
}

