/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.request;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.web.mvc.SpringMvcBundle;
import com.intellij.spring.web.mvc.request.NavigatorHttpRequest;
import com.intellij.spring.web.mvc.request.RequestNavigator;
import com.intellij.ui.UIBundle;
import com.intellij.util.PathUtil;
import com.intellij.ws.http.request.HttpRequestLanguage;
import com.intellij.ws.http.request.HttpRequestPsiConverter;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;
import com.intellij.ws.http.request.psi.HttpRequestTarget;
import com.intellij.ws.rest.client.RestClientRequest;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RestClientRequestNavigator
implements RequestNavigator {
    public boolean accept(@NotNull NavigatorHttpRequest request) {
        if (request == null) {
            RestClientRequestNavigator.$$$reportNull$$$0(0);
        }
        return true;
    }

    public void navigate(final @NotNull Project project, final @NotNull NavigatorHttpRequest request, @NotNull String hint) {
        if (project == null) {
            RestClientRequestNavigator.$$$reportNull$$$0(1);
        }
        if (request == null) {
            RestClientRequestNavigator.$$$reportNull$$$0(2);
        }
        if (hint == null) {
            RestClientRequestNavigator.$$$reportNull$$$0(3);
        }
        if (project.isDisposed()) {
            return;
        }
        final String requestText = RestClientRequestNavigator.getRequestText(request);
        LanguageFileType fileType = HttpRequestLanguage.INSTANCE.getAssociatedFileType();
        String ext = fileType == null ? "" : fileType.getDefaultExtension();
        final String fileName = PathUtil.makeFileName((String)hint, (String)ext);
        RunResult result = new WriteCommandAction<NavigatablePsiElement>(project, SpringMvcBundle.message("request.navigator.update.scratch.file", new Object[0]), new PsiFile[0]){

            protected boolean isGlobalUndoAction() {
                return true;
            }

            protected boolean shouldRecordActionForActiveDocument() {
                return false;
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }

            protected void run(@NotNull Result<NavigatablePsiElement> result) throws Throwable {
                PsiDocumentManager manager;
                Document document;
                VirtualFile file;
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                ScratchFileService fileService = ScratchFileService.getInstance();
                try {
                    file = fileService.findFile((RootType)ScratchRootType.getInstance(), fileName, ScratchFileService.Option.create_if_missing);
                }
                catch (IOException e) {
                    throw new Exception(UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}), e);
                }
                fileService.getScratchesMapping().setMapping(file, (Object)HttpRequestLanguage.INSTANCE);
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (!(psiFile instanceof HttpRequestPsiFile)) {
                    throw new Exception(SpringMvcBundle.message("request.navigator.invalid.file", fileName));
                }
                HttpRequest[] requests = (HttpRequest[])PsiTreeUtil.getChildrenOfType((PsiElement)psiFile, HttpRequest.class);
                if (requests != null) {
                    for (HttpRequest httpRequest : requests) {
                        String path;
                        String requestHttpUrl = httpRequest.getHttpUrl(HttpRequestVariableSubstitutor.empty());
                        if (requestHttpUrl == null) continue;
                        HttpRequestTarget requestTarget = httpRequest.getRequestTarget();
                        if (requestTarget != null && StringUtil.isEmpty((String)(path = requestTarget.getHttpPath(HttpRequestVariableSubstitutor.empty()))) && request.getUrl().endsWith("/")) {
                            requestHttpUrl = requestHttpUrl + "/";
                        }
                        if (!request.getUrl().equalsIgnoreCase(requestHttpUrl)) continue;
                        result.setResult((Object)httpRequest);
                        return;
                    }
                }
                if ((document = (manager = PsiDocumentManager.getInstance((Project)project)).getDocument(psiFile)) == null) {
                    throw new Exception(SpringMvcBundle.message("request.navigator.invalid.file.document", fileName));
                }
                RestClientRequestNavigator.appendSeparatorIfNeeded(requests, document);
                document.insertString(document.getTextLength(), (CharSequence)requestText);
                manager.commitDocument(document);
                HttpRequest[] updatedRequests = (HttpRequest[])PsiTreeUtil.getChildrenOfType((PsiElement)psiFile, HttpRequest.class);
                if (updatedRequests != null && updatedRequests.length > 0) {
                    result.setResult((Object)updatedRequests[updatedRequests.length - 1]);
                } else {
                    result.setResult((Object)psiFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/web/mvc/request/RestClientRequestNavigator$1", "run"));
            }
        }.execute();
        if (result.hasException()) {
            Messages.showMessageDialog((String)result.getThrowable().getMessage(), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        NavigatablePsiElement psiElement = (NavigatablePsiElement)result.getResultObject();
        if (psiElement != null) {
            psiElement.navigate(true);
        }
    }

    private static void appendSeparatorIfNeeded(HttpRequest[] requests, Document document) {
        HttpRequest lastRequest;
        PsiElement nextSeparator;
        if (requests != null && requests.length > 0 && (nextSeparator = HttpRequestPsiUtils.getNextSiblingByType((PsiElement)(lastRequest = requests[requests.length - 1]), (IElementType)HttpRequestElementTypes.REQUEST_SEPARATOR, (boolean)true)) == null) {
            int endOffset = requests[requests.length - 1].getTextRange().getEndOffset();
            document.insertString(endOffset, (CharSequence)("\n\n" + HttpRequestPsiConverter.getSeparator() + "\n\n"));
            return;
        }
        int endOffset = document.getTextLength();
        if (endOffset > 0 && !document.getText(new TextRange(endOffset - 1, endOffset)).equals("\n")) {
            document.insertString(endOffset, (CharSequence)"\n\n");
        }
    }

    private static String getRequestText(@NotNull NavigatorHttpRequest request) {
        if (request == null) {
            RestClientRequestNavigator.$$$reportNull$$$0(4);
        }
        RestClientRequest restClientRequest = new RestClientRequest();
        restClientRequest.httpMethod = request.getRequestMethod();
        restClientRequest.urlBase = request.getUrl();
        restClientRequest.urlPath = "";
        restClientRequest.headers = request.getHeaders().stream().map(header -> new RestClientRequest.KeyValuePair((String)header.first, (String)header.second)).collect(Collectors.toList());
        restClientRequest.parametersEnabled = true;
        restClientRequest.parameters = request.getParams().stream().map(param -> new RestClientRequest.KeyValuePair((String)param.first, (String)param.second)).collect(Collectors.toList());
        return HttpRequestPsiConverter.toPsiHttpRequest((RestClientRequest)restClientRequest);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/web/mvc/request/RestClientRequestNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "navigate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRequestText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

