/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.taglib;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.impl.ELElementProcessor;
import com.intellij.psi.impl.source.jsp.el.impl.ElVariablesProvider;
import com.intellij.psi.impl.source.jsp.el.impl.JspElVariablesProvider;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.el.contextProviders.SpringElContextProvider;
import com.intellij.spring.web.mvc.jsp.SpringMvcElVariablesProvider;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class SpringElInJspContextProvider
extends SpringElContextProvider {
    private static final ElVariablesProvider JSP_EL_VARIABLES_PROVIDER = new JspElVariablesProvider();
    private static final ElVariablesProvider SPRING_MVC_EL_VARIABLES_PROVIDER = new SpringMvcElVariablesProvider();

    SpringElInJspContextProvider(PsiElement host) {
        super(host);
    }

    @Nullable
    public Iterator<? extends PsiVariable> getTopLevelElVariables(@Nullable String nameHint) {
        PsiVariable variable;
        PsiFile hostFile = this.myHost.getContainingFile();
        PsiElement injectedElementNoCommit = InjectedLanguageManager.getInstance((Project)hostFile.getProject()).findInjectedElementAt(hostFile, this.myHost.getTextOffset());
        ELExpressionHolder holder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)injectedElementNoCommit, ELExpressionHolder.class);
        assert (holder != null);
        SmartList result = new SmartList();
        ELElementProcessor processor = SpringElInJspContextProvider.createProcessor(nameHint, (List<PsiVariable>)result);
        boolean viaJsp = JSP_EL_VARIABLES_PROVIDER.processImplicitVariables(injectedElementNoCommit, holder, processor);
        if (!viaJsp) {
            return result.iterator();
        }
        if (nameHint != null && (variable = this.findVariable(nameHint, this.myHost)) != null) {
            return Collections.singleton(variable).iterator();
        }
        result.addAll(this.getAllVariables(this.myHost));
        SPRING_MVC_EL_VARIABLES_PROVIDER.processImplicitVariables(injectedElementNoCommit, holder, processor);
        return result.iterator();
    }

    private static ELElementProcessor createProcessor(final String nameHint, final List<PsiVariable> result) {
        return new ELElementProcessor(){

            public boolean processNSPrefix(String prefix) {
                return true;
            }

            public boolean processVariable(PsiVariable variable) {
                if (nameHint != null && nameHint.equals(variable.getName())) {
                    result.add(variable);
                    return false;
                }
                result.add(variable);
                return true;
            }

            public boolean processMethod(PsiMethod method) {
                return true;
            }

            public boolean processProperty(IProperty property) {
                return true;
            }

            public void setSubstitutor(PsiSubstitutor substitutor) {
            }

            @Nullable
            public String getNameHint() {
                return nameHint;
            }
        };
    }
}

