/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.tiles;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.mvc.TilesConfigurer;
import com.intellij.spring.model.xml.mvc.TilesDefinitions;
import com.intellij.spring.web.SpringWebConstants;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.spring.web.mvc.tiles.TilesConfigurerReferenceContributor;
import com.intellij.struts.StrutsPluginDomFactory;
import com.intellij.struts.StrutsProjectComponent;
import com.intellij.struts.TilesModel;
import com.intellij.struts.TilesModelProvider;
import com.intellij.struts.psi.TilesModelImpl;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MVCTilesModelProvider
implements TilesModelProvider {
    @NotNull
    public Collection<TilesModel> computeModels(@NotNull Module module) {
        SpringFacet springFacet;
        if (module == null) {
            MVCTilesModelProvider.$$$reportNull$$$0(0);
        }
        if ((springFacet = SpringFacet.getInstance((Module)module)) == null) {
            List<TilesModel> list = Collections.emptyList();
            if (list == null) {
                MVCTilesModelProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        if (webFacets.isEmpty()) {
            List<TilesModel> list = Collections.emptyList();
            if (list == null) {
                MVCTilesModelProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        SmartList models = new SmartList();
        Processor processor = arg_0 -> MVCTilesModelProvider.lambda$computeModels$0(module, (List)models, arg_0);
        for (WebFacet webFacet : webFacets) {
            SpringMVCModel springMVCModel = SpringMVCModelService.getInstance().getModel(webFacet, springFacet);
            if (springMVCModel == null) continue;
            Collection servletModels = springMVCModel.getServletModels();
            for (SpringModel servletModel : servletModels) {
                MVCTilesModelProvider.processTiles(servletModel, (Processor<Set<XmlFile>>)processor);
            }
        }
        SmartList smartList = models;
        if (smartList == null) {
            MVCTilesModelProvider.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    private static void processTiles(SpringModel model, Processor<Set<XmlFile>> consumer) {
        Module module = model.getModule();
        assert (module != null) : model;
        for (String configurerClass : SpringWebConstants.TILES_CONFIGURER_CLASSES) {
            PsiClass tilesConfigurer = SpringCommonUtils.findLibraryClass((Module)module, (String)configurerClass);
            if (tilesConfigurer == null || MVCTilesModelProvider.processTilesConfigurer(model, consumer, tilesConfigurer)) continue;
            return;
        }
    }

    private static boolean processTilesConfigurer(SpringModel model, Processor<Set<XmlFile>> consumer, PsiClass configurerClass) {
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)configurerClass).withInheritors().effectiveBeanTypes();
        List pointers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        for (SpringBeanPointer pointer : pointers) {
            Set<VirtualFile> tilesXmlFiles = MVCTilesModelProvider.getTilesXmlFiles(pointer);
            PsiManager psiManager = configurerClass.getManager();
            StrutsPluginDomFactory tilesFactory = StrutsProjectComponent.getInstance((Project)psiManager.getProject()).getTilesFactory();
            LinkedHashSet<XmlFile> foundFiles = new LinkedHashSet<XmlFile>(tilesXmlFiles.size());
            for (VirtualFile file : tilesXmlFiles) {
                PsiFile psiFile = psiManager.findFile(file);
                if (!(psiFile instanceof XmlFile) || tilesFactory.getDomRoot((XmlFile)psiFile) == null) continue;
                foundFiles.add((XmlFile)psiFile);
            }
            if (consumer.process(foundFiles)) continue;
            return false;
        }
        return pointers.isEmpty();
    }

    @NotNull
    private static Set<VirtualFile> getTilesXmlFiles(SpringBeanPointer pointer) {
        if (!pointer.isValid()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                MVCTilesModelProvider.$$$reportNull$$$0(4);
            }
            return set;
        }
        CommonSpringBean springBean = pointer.getSpringBean();
        SmartList referenceElements = new SmartList();
        if (springBean instanceof SpringBean) {
            SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)springBean, (String)"definitions");
            if (!(property instanceof SpringProperty)) {
                Set<VirtualFile> set = Collections.emptySet();
                if (set == null) {
                    MVCTilesModelProvider.$$$reportNull$$$0(5);
                }
                return set;
            }
            SpringProperty springProperty = (SpringProperty)property;
            String valueAttribute = property.getValueAsString();
            if (valueAttribute != null) {
                MVCTilesModelProvider.addReferences((List<PsiReference>)referenceElements, (PsiElement)springProperty.getValueAttr().getXmlAttributeValue());
            } else {
                MVCTilesModelProvider.collectCollectionProperties((List<PsiReference>)referenceElements, springProperty);
            }
        } else if (springBean instanceof TilesConfigurer) {
            TilesConfigurer tilesConfigurer = (TilesConfigurer)springBean;
            for (TilesDefinitions definitions : tilesConfigurer.getTilesDefinitions()) {
                if (definitions.getLocation().getStringValue() == null) continue;
                MVCTilesModelProvider.addReferences((List<PsiReference>)referenceElements, (PsiElement)definitions.getLocation().getXmlAttributeValue());
            }
        } else if (springBean instanceof ContextJavaBean) {
            MVCTilesModelProvider.collectJavaBeanReferences((List<PsiReference>)referenceElements, springBean);
        }
        LinkedHashSet files = ContainerUtil.newLinkedHashSet();
        for (PsiReference reference : referenceElements) {
            if (!(reference instanceof PsiPolyVariantReference)) continue;
            for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                ContainerUtil.addIfNotNull((Collection)files, (Object)PsiUtilBase.asVirtualFile((PsiElement)result.getElement()));
            }
        }
        LinkedHashSet linkedHashSet = files;
        if (linkedHashSet == null) {
            MVCTilesModelProvider.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    private static void addReferences(List<PsiReference> references, @Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return;
        }
        Object[] psiReferences = psiElement.getReferences();
        ContainerUtil.addAllNotNull(references, (Object[])psiReferences);
    }

    private static void collectCollectionProperties(List<PsiReference> references, SpringProperty springProperty) {
        if (DomUtil.hasXml((DomElement)springProperty.getList())) {
            MVCTilesModelProvider.collect(references, springProperty.getList());
        }
        if (DomUtil.hasXml((DomElement)springProperty.getSet())) {
            MVCTilesModelProvider.collect(references, springProperty.getSet());
        }
        if (DomUtil.hasXml((DomElement)springProperty.getArray())) {
            MVCTilesModelProvider.collect(references, springProperty.getArray());
        }
    }

    private static void collect(List<PsiReference> references, ListOrSet list) {
        for (SpringValue springValue : list.getValues()) {
            MVCTilesModelProvider.addReferences(references, (PsiElement)springValue.getXmlElement());
        }
    }

    private static void collectJavaBeanReferences(List<PsiReference> references, CommonSpringBean springBean) {
        PsiExpression[] paramExpressions;
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass == null) {
            return;
        }
        PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)beanClass, (String)"definitions", (boolean)false, (boolean)true);
        if (setter == null) {
            setter = PropertyUtilBase.findPropertySetter((PsiClass)PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType(true)), (String)"definitions", (boolean)false, (boolean)true);
        }
        if (setter == null) {
            return;
        }
        LocalSearchScope scope = new LocalSearchScope((PsiElement)((ContextJavaBean)springBean).getPsiElement());
        PsiMethodCallExpression setDefinitionsCall = (PsiMethodCallExpression)ContainerUtil.getFirstItem((Collection)StringExpressionHelper.searchMethodCalls((PsiMethod)setter, (SearchScope)scope));
        if (setDefinitionsCall == null) {
            return;
        }
        for (PsiExpression expression : paramExpressions = setDefinitionsCall.getArgumentList().getExpressions()) {
            PsiElement resolve;
            if (expression instanceof PsiNewExpression) {
                PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)expression).getArrayInitializer();
                if (arrayInitializer == null) continue;
                for (PsiExpression initializer : arrayInitializer.getInitializers()) {
                    MVCTilesModelProvider.addReferences(references, (PsiElement)initializer);
                }
                continue;
            }
            if (expression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)expression).resolve()) instanceof PsiVariable) {
                PsiExpression initializer = ((PsiVariable)resolve).getInitializer();
                if (initializer instanceof PsiLiteralExpression) {
                    ContainerUtil.addAllNotNull(references, (Object[])MVCTilesModelProvider.createResourceReferences(initializer));
                    continue;
                }
                if (initializer instanceof PsiNewExpression) {
                    initializer = ((PsiNewExpression)initializer).getArrayInitializer();
                }
                if (initializer instanceof PsiArrayInitializerExpression) {
                    for (PsiExpression psiExpression : ((PsiArrayInitializerExpression)initializer).getInitializers()) {
                        ContainerUtil.addAllNotNull(references, (Object[])MVCTilesModelProvider.createResourceReferences(psiExpression));
                    }
                }
            }
            MVCTilesModelProvider.addReferences(references, (PsiElement)expression);
        }
    }

    @NotNull
    private static PsiReference[] createResourceReferences(PsiExpression initializer) {
        PsiReference[] psiReferenceArray = TilesConfigurerReferenceContributor.PROVIDER.getReferencesByElement((PsiElement)initializer, new ProcessingContext());
        if (psiReferenceArray == null) {
            MVCTilesModelProvider.$$$reportNull$$$0(7);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ boolean lambda$computeModels$0(@NotNull Module module, List models, Set definitions) {
        StrutsPluginDomFactory factory;
        DomFileElement domFileElement;
        if (module == null) {
            MVCTilesModelProvider.$$$reportNull$$$0(8);
        }
        if ((domFileElement = (factory = StrutsProjectComponent.getInstance((Project)module.getProject()).getTilesFactory()).createMergedModelRoot(definitions)) != null) {
            TilesModelImpl tilesModel = new TilesModelImpl(definitions, domFileElement, "mvcTilesModel");
            models.add(tilesModel);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/tiles/MVCTilesModelProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/tiles/MVCTilesModelProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeModels";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTilesXmlFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createResourceReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeModels";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeModels$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

