/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import com.intellij.spring.web.mvc.SpringMVCReference;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewReference;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringMVCViewReferenceProvider
extends PsiReferenceProvider {
    public static final PsiJavaElementPattern.Capture<PsiElement> VIEW_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiLiteral.class, PsiReferenceExpression.class}).with(SpringMvcLibraryUtil.IS_SPRING_MVC_PROJECT)).andOr(new ElementPattern[]{PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("setViewName")).inClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"org.springframework.web.servlet.ModelAndView", "org.springframework.web.servlet.config.annotation.ViewControllerRegistration"})))), PsiJavaPatterns.psiExpression().constructorParameter(0, new String[]{"org.springframework.web.servlet.ModelAndView"}), PsiJavaPatterns.psiExpression().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReturnStatement.class).inside((ElementPattern)PsiJavaPatterns.psiMethod().with((PatternCondition)new PatternCondition<PsiMethod>("mvcRequestHandler"){

        public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
            if (method == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!SpringControllerClassInfo.isRequestHandlerCandidate(method)) {
                return false;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.web.bind.annotation.ResponseBody", (int)0)) {
                return false;
            }
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            SpringControllerClassInfo controllerClassInfo = SpringControllerClassInfo.getInfo(psiClass);
            if (!controllerClassInfo.isRequestHandler(method)) {
                return false;
            }
            if (!SpringControllerClassInfo.isJamRequestHandler(method)) {
                return true;
            }
            return !controllerClassInfo.hasClassLevelResponseBody();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider$1", "accepts"));
        }
    })))});
    private final boolean mySoft;

    public SpringMVCViewReferenceProvider() {
        this(true);
    }

    public SpringMVCViewReferenceProvider(boolean soft) {
        this.mySoft = soft;
    }

    public static void register(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(VIEW_PATTERN, (PsiReferenceProvider)new SpringMVCViewReferenceProvider(false), 100.0);
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiType type;
        if (element == null) {
            SpringMVCViewReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpringMVCViewReferenceProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiLiteralExpression && ((type = ((PsiLiteralExpression)element).getType()) == null || !type.equalsToText("java.lang.String"))) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringMVCViewReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SpringMVCModel model = SpringMVCModelService.getInstance().getModel(element);
        if (model == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringMVCViewReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        String text = range.substring(element.getText());
        if (text.startsWith("redirect:")) {
            String redirectUrl = (range = SpringMVCViewReferenceProvider.adjustRange(range, text, "redirect:")).substring(element.getText());
            if (GlobalPathReferenceProvider.isWebReferenceUrl((String)redirectUrl)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new WebReference(element, range)};
                if (psiReferenceArray == null) {
                    SpringMVCViewReferenceProvider.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }
            SpringMVCReference mvcReference = new SpringMVCReference(element, range.getStartOffset(), redirectUrl, model.getServletMappingInfo(), true);
            PsiReference[] psiReferenceArray = new PsiReference[]{mvcReference};
            if (psiReferenceArray == null) {
                SpringMVCViewReferenceProvider.$$$reportNull$$$0(5);
            }
            return psiReferenceArray;
        }
        range = SpringMVCViewReferenceProvider.adjustRange(range, text, "forward:");
        text = range.substring(element.getText());
        SmartList references = new SmartList();
        List allResolvers = model.getViewResolvers();
        final boolean soft = this.mySoft || model.hasUnknownResolvers();
        SmartList resolvers = new SmartList();
        for (final ViewResolver viewResolver : allResolvers) {
            WebDirectoryElement root;
            if (viewResolver instanceof UrlBasedViewResolver && (root = ((UrlBasedViewResolver)viewResolver).getRoot(model)) != null) {
                FileReferenceSet fileReferenceSet = new FileReferenceSet(text, element, range.getStartOffset(), null, false){

                    public FileReference createFileReference(TextRange range, int index, String text) {
                        return new FileReference(this, range, index, text){

                            protected String encode(String name, PsiElement psiElement) {
                                if (psiElement instanceof PsiFile) {
                                    name = ((UrlBasedViewResolver)viewResolver).encode(name);
                                }
                                return name == null ? null : super.encode(name, psiElement);
                            }

                            @NotNull
                            public String decode(@NotNull String name) {
                                if (name == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (this.isLast()) {
                                    name = ((UrlBasedViewResolver)viewResolver).decode(name);
                                }
                                String string = super.decode(name);
                                if (string == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return string;
                            }

                            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                                String newName;
                                if (element == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                return (newName = viewResolver.bindToElement(element)) == null ? this.getElement() : ElementManipulators.getManipulator((PsiElement)this.getElement()).handleContentChange(this.getElement(), newName);
                            }

                            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                                return super.handleElementRename(viewResolver.handleElementRename(newElementName));
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string;
                                switch (n) {
                                    default: {
                                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                    case 1: {
                                        string = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 3;
                                        break;
                                    }
                                    case 1: {
                                        n2 = 2;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "name";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider$2$1";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "element";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider$2$1";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "decode";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray;
                                        objectArray[2] = "decode";
                                        break;
                                    }
                                    case 1: {
                                        break;
                                    }
                                    case 2: {
                                        objectArray = objectArray;
                                        objectArray[2] = "bindToElement";
                                        break;
                                    }
                                }
                                String string2 = String.format(string, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalArgumentException(string2);
                                        break;
                                    }
                                    case 1: {
                                        runtimeException = new IllegalStateException(string2);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        };
                    }

                    protected boolean isUrlEncoded() {
                        return true;
                    }

                    protected boolean isSoft() {
                        return soft;
                    }
                };
                fileReferenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, psiFile -> Collections.singletonList(root));
                references.addAll(Arrays.asList(fileReferenceSet.getAllReferences()));
                continue;
            }
            resolvers.add(viewResolver);
        }
        if (!resolvers.isEmpty() || allResolvers.isEmpty()) {
            references.add(new ViewReference(element, (List<ViewResolver>)resolvers, range, soft));
        }
        PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
        if (psiReferenceArray == null) {
            SpringMVCViewReferenceProvider.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    private static TextRange adjustRange(TextRange range, String text, String prefix) {
        return text.startsWith(prefix) ? new TextRange(range.getStartOffset() + prefix.length(), range.getEndOffset()) : range;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/views/SpringMVCViewReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

