/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.util;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.ManifestFileTypeFactory;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.lang.manifest.psi.Section;

public class ManifestUtils {
    @NonNls
    public static final String IMPORT_BUNDLE_HEADER = "Import-Bundle";
    @NonNls
    public static final String IMPORT_LIBRARY_HEADER = "Import-Library";
    @NonNls
    public static final String VERSION_RANGE_ATTRIBUTE_NAME = "version";
    @NonNls
    public static final String VERSION_ATTRIBUTE_NAME = "version";
    @NonNls
    public static final String WEB_CONTEXT_PATH_HEADER = "Web-ContextPath";
    private static final ManifestUtils ourInstance = new ManifestUtils();

    public static ManifestUtils getInstance() {
        return ourInstance;
    }

    private ManifestUtils() {
    }

    @Nullable
    public String getHeaderValue(@NotNull PsiFile manifestFile, @NotNull String headerName) {
        Header header;
        if (manifestFile == null) {
            ManifestUtils.$$$reportNull$$$0(0);
        }
        if (headerName == null) {
            ManifestUtils.$$$reportNull$$$0(1);
        }
        return (header = this.findHeader(manifestFile, headerName)) != null ? this.getHeaderValue(header) : null;
    }

    @Nullable
    public String getHeaderValue(@NotNull Header header) {
        HeaderValue value;
        if (header == null) {
            ManifestUtils.$$$reportNull$$$0(2);
        }
        return (value = header.getHeaderValue()) != null ? value.getUnwrappedText() : null;
    }

    @Nullable
    public Header findHeader(@NotNull PsiFile manifestFile, @NotNull String headerName) {
        List<Header> headers;
        if (manifestFile == null) {
            ManifestUtils.$$$reportNull$$$0(3);
        }
        if (headerName == null) {
            ManifestUtils.$$$reportNull$$$0(4);
        }
        return (headers = this.findHeaders(manifestFile, headerName)).size() == 0 ? null : headers.get(0);
    }

    @NotNull
    public List<Header> findHeaders(@NotNull PsiFile file, @NotNull String headerName) {
        if (file == null) {
            ManifestUtils.$$$reportNull$$$0(5);
        }
        if (headerName == null) {
            ManifestUtils.$$$reportNull$$$0(6);
        }
        if (!(file instanceof ManifestFile)) {
            List<Header> list = Collections.emptyList();
            if (list == null) {
                ManifestUtils.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = ContainerUtil.filter((Collection)((ManifestFile)file).getHeaders(), header -> {
            if (headerName == null) {
                ManifestUtils.$$$reportNull$$$0(21);
            }
            return headerName.equalsIgnoreCase(header.getName());
        });
        if (list == null) {
            ManifestUtils.$$$reportNull$$$0(8);
        }
        return list;
    }

    public Header createHeader(@NotNull Project project, @NotNull String headerName, @NotNull String headerValue) {
        if (project == null) {
            ManifestUtils.$$$reportNull$$$0(9);
        }
        if (headerName == null) {
            ManifestUtils.$$$reportNull$$$0(10);
        }
        if (headerValue == null) {
            ManifestUtils.$$$reportNull$$$0(11);
        }
        return this.createHeader(project, this.createHeaderText(headerName, headerValue));
    }

    public String createHeaderText(@NotNull String headerName, @NotNull String headerValue) {
        if (headerName == null) {
            ManifestUtils.$$$reportNull$$$0(12);
        }
        if (headerValue == null) {
            ManifestUtils.$$$reportNull$$$0(13);
        }
        return MessageFormat.format("{0}: {1}\n", headerName, headerValue);
    }

    public Header createHeader(@NotNull Project project, @NotNull CharSequence headerText) {
        if (project == null) {
            ManifestUtils.$$$reportNull$$$0(14);
        }
        if (headerText == null) {
            ManifestUtils.$$$reportNull$$$0(15);
        }
        return (Header)ManifestUtils.createDummyFile(project, headerText).getHeaders().get(0);
    }

    private static ManifestFile createDummyFile(@NotNull Project project, @NonNls @NotNull CharSequence content) {
        if (project == null) {
            ManifestUtils.$$$reportNull$$$0(16);
        }
        if (content == null) {
            ManifestUtils.$$$reportNull$$$0(17);
        }
        return (ManifestFile)PsiFileFactory.getInstance((Project)project).createFileFromText("DUMMY.MF", (FileType)ManifestFileTypeFactory.MANIFEST, content);
    }

    private static Section findSection(@NotNull PsiFile file) {
        if (file == null) {
            ManifestUtils.$$$reportNull$$$0(18);
        }
        return file instanceof ManifestFile ? ((ManifestFile)file).getMainSection() : null;
    }

    public void addHeader(@NotNull PsiFile manifestFile, @NotNull Header header) {
        Section section;
        if (manifestFile == null) {
            ManifestUtils.$$$reportNull$$$0(19);
        }
        if (header == null) {
            ManifestUtils.$$$reportNull$$$0(20);
        }
        if ((section = ManifestUtils.findSection(manifestFile)) == null) {
            Section dummySection = ManifestUtils.findSection((PsiFile)ManifestUtils.createDummyFile(manifestFile.getManager().getProject(), "Header: value"));
            dummySection.deleteChildRange(dummySection.getFirstChild(), dummySection.getLastChild());
            manifestFile.add((PsiElement)dummySection);
            section = ManifestUtils.findSection(manifestFile);
        }
        section.add((PsiElement)header);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestFile";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerName";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dmserver/util/ManifestUtils";
                break;
            }
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerValue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dmserver/util/ManifestUtils";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findHeader";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findHeaders";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createHeader";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createHeaderText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDummyFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findSection";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addHeader";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findHeaders$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

