/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudbees.agent;

import com.cloudbees.api.BeesClient;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogPipe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public abstract class CBLogPipeBase
extends LogPipe {
    private final BeesClient myClient;
    private final String myClientKind;
    private final CloudAgentLogger myLogger;
    private final CloudAgentLoggingHandler myLoggingHandler;
    private OutputStream myOutputStream;

    public CBLogPipeBase(BeesClient client, String deploymentName, String clientLogKind, CloudAgentLogger logger, CloudAgentLoggingHandler loggingHandler) {
        super(deploymentName, clientLogKind, logger, loggingHandler);
        this.myClient = client;
        this.myClientKind = clientLogKind;
        this.myLogger = logger;
        this.myLoggingHandler = loggingHandler;
    }

    protected InputStream createInputStream(final String deploymentName) {
        try {
            PipedInputStream inputStream = new PipedInputStream();
            this.myOutputStream = new PipedOutputStream(inputStream);
            new Thread("CB log pipe"){

                @Override
                public void run() {
                    while (!CBLogPipeBase.this.isClosed()) {
                        try {
                            CBLogPipeBase.this.myClient.tailLog(deploymentName, CBLogPipeBase.this.myClientKind, CBLogPipeBase.this.myOutputStream);
                        }
                        catch (Exception e) {
                            CBLogPipeBase.this.myLoggingHandler.println(e.toString());
                        }
                        CBLogPipeBase.this.myLogger.debug("tail to cut for: " + deploymentName);
                        CBLogPipeBase.this.cutTail();
                    }
                }
            }.start();
            return inputStream;
        }
        catch (IOException e) {
            this.myLoggingHandler.println(e.toString());
            return null;
        }
    }

    public void close() {
        super.close();
        try {
            if (this.myOutputStream != null) {
                this.myOutputStream.close();
            }
        }
        catch (IOException e) {
            this.myLogger.debug(e.toString());
        }
    }
}

