/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.google.common.base.Strings;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.configuration.CssPrefix;
import com.intellij.codeInsight.template.emmet.nodes.CssEmmetNode;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssTermList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPropertyTemplateEmmetNode
extends CssEmmetNode {
    private final TemplateImpl myTemplate;

    public CssPropertyTemplateEmmetNode(TemplateImpl template, List<String> values, Collection<CssPrefix> prefixes, boolean isImportant) {
        super(values, prefixes, isImportant);
        this.myTemplate = template;
    }

    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        TemplateToken templateToken = new TemplateToken("");
        CssDeclaration[] properties = CssElementFactory.getInstance((Project)callback.getProject()).createProperties(this.myTemplate.getString(), null);
        if (properties.length > 0) {
            String valueFromTemplate;
            String propertyName = properties[0].getPropertyName();
            CssTermList termList = properties[0].getValue();
            String termListText = termList != null ? termList.getText().trim() : "";
            String value = valueFromTemplate = !termListText.isEmpty() ? termListText : "$VAR0$";
            if (!this.myValues.isEmpty() && !valueFromTemplate.isEmpty()) {
                for (Variable variable : this.myTemplate.getVariables()) {
                    String name = variable.getName();
                    if (Strings.isNullOrEmpty((String)name) || !valueFromTemplate.contains(name)) continue;
                    value = this.createValue(propertyName);
                    break;
                }
                if ("$END$".equals(valueFromTemplate)) {
                    value = this.createValue(propertyName);
                }
            }
            if (this.myImportant) {
                value = value + " !important";
            }
            TemplateImpl template = this.myTemplate.copy();
            String declarationsTerminator = CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)callback.getContext());
            boolean caretAtTerminator = this.isCaretAtDeclarationsTerminator(callback.getEditor(), declarationsTerminator);
            String templateString = this.createDeclarationsString(propertyName, value, declarationsTerminator, !caretAtTerminator);
            template.setString(templateString);
            if (this.myValues.isEmpty()) {
                if ((termList == null || "$END$".equals(value)) && templateString.contains("$VAR_EMMET_VALUE$")) {
                    template.addVariable("VAR_EMMET_VALUE", "VAR_EMMET_VALUE", "", true);
                } else if (termList == null && "$VAR0$".equals(value)) {
                    template.addVariable("VAR0", "VAR0", "", true);
                } else {
                    for (Variable variable : this.myTemplate.getVariables()) {
                        template.addVariable(variable.getName(), variable.getExpressionString(), variable.getDefaultValueString(), variable.isAlwaysStopAt());
                    }
                }
            }
            templateToken.setTemplate(template, callback);
            GenerationNode node = new GenerationNode(templateToken, numberInIteration, totalIterations, surroundedText, insertSurroundedTextAtTheEnd, parent, declarationsTerminator.isEmpty());
            List<GenerationNode> list = Collections.singletonList(node);
            if (list == null) {
                CssPropertyTemplateEmmetNode.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<GenerationNode> list = Collections.emptyList();
        if (list == null) {
            CssPropertyTemplateEmmetNode.$$$reportNull$$$0(1);
        }
        return list;
    }

    public int getApproximateOutputLength(@Nullable CustomTemplateCallback callback) {
        return this.myTemplate.getTemplateText().length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/CssPropertyTemplateEmmetNode", "expand"));
    }
}

