/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.converters.PathReferenceConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class DependencyConfigFileConverter
extends PathReferenceConverter {
    private static final PathReferenceProvider ourProvider = new StaticPathReferenceProvider(null){

        public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<PsiReference> references, boolean soft) {
            if (psiElement == null) {
                1.$$$reportNull$$$0(0);
            }
            if (references == null) {
                1.$$$reportNull$$$0(1);
            }
            FileReferenceSet set = new FileReferenceSet(text, psiElement, offset, null, true, true, new FileType[]{XmlFileType.INSTANCE}){
                private final Condition<PsiFileSystemItem> PLUGIN_XML_CONDITION;
                {
                    super(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
                    this.PLUGIN_XML_CONDITION = item -> !item.isDirectory() && !item.equals(this.getContainingFile()) && item instanceof XmlFile && DescriptorUtil.isPluginXml((PsiFile)item) && !this.isAlreadyUsed((XmlFile)item);
                }

                private boolean isAlreadyUsed(XmlFile xmlFile) {
                    PsiFile file = this.getContainingFile();
                    if (!(file instanceof XmlFile)) {
                        return false;
                    }
                    DomFileElement<IdeaPlugin> ideaPlugin = DescriptorUtil.getIdeaPlugin((XmlFile)file);
                    if (ideaPlugin == null) {
                        return false;
                    }
                    return !ContainerUtil.process(((IdeaPlugin)ideaPlugin.getRootElement()).getDependencies(), dependency -> {
                        GenericAttributeValue<PathReference> configFileAttribute = dependency.getConfigFile();
                        if (!DomUtil.hasXml(configFileAttribute)) {
                            return true;
                        }
                        PathReference pathReference = (PathReference)configFileAttribute.getValue();
                        if (pathReference == null) {
                            return true;
                        }
                        return !xmlFile.equals(pathReference.resolve());
                    });
                }

                @NotNull
                public Collection<PsiFileSystemItem> computeDefaultContexts() {
                    PsiFile containingFile = this.getContainingFile();
                    if (containingFile == null) {
                        List<PsiFileSystemItem> list = Collections.emptyList();
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return list;
                    }
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                    if (module == null) {
                        List<PsiFileSystemItem> list = Collections.emptyList();
                        if (list == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return list;
                    }
                    HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
                    VirtualFile parent = containingFile.getVirtualFile().getParent();
                    roots.add(parent);
                    for (VirtualFile sourceRoot : ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.PRODUCTION)) {
                        roots.add(sourceRoot.findChild("META-INF"));
                    }
                    Collection collection = this.toFileSystemItems(roots);
                    if (collection == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return collection;
                }

                protected boolean isSoft() {
                    return true;
                }

                protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                    return this.PLUGIN_XML_CONDITION;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/DependencyConfigFileConverter$1$1", "computeDefaultContexts"));
                }
            };
            Collections.addAll(references, set.getAllReferences());
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "references";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/devkit/dom/DependencyConfigFileConverter$1";
            objectArray[2] = "createReferences";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public PathReference fromString(@Nullable String s, ConvertContext context) {
        XmlElement element = context.getXmlElement();
        Module module = context.getModule();
        if (s == null || element == null || module == null) {
            return null;
        }
        return PathReferenceManager.getInstance().getCustomPathReference(s, module, (PsiElement)element, new PathReferenceProvider[]{ourProvider});
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        if (psiElement == null) {
            DependencyConfigFileConverter.$$$reportNull$$$0(0);
        }
        PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createCustomReferences(psiElement, soft, new PathReferenceProvider[]{ourProvider});
        if (psiReferenceArray == null) {
            DependencyConfigFileConverter.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/DependencyConfigFileConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/DependencyConfigFileConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

