/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.ReferenceSetBase;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocator;

public class ExtensionOrderConverter
implements CustomReferenceConverter<String> {
    private static final Logger LOG = Logger.getInstance(ExtensionOrderConverter.class);

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        PsiElement originalElement = CompletionUtil.getOriginalOrSelf((PsiElement)element);
        final String orderValue = ElementManipulators.getValueText((PsiElement)originalElement);
        if (StringUtil.isEmpty((String)orderValue)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ExtensionOrderConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final Extension extension = (Extension)value.getParentOfType(Extension.class, false);
        if (extension == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ExtensionOrderConverter.$$$reportNull$$$0(1);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new ReferenceSetBase<PsiReference>(orderValue, element, 0, ','){

            protected List<PsiReference> createReferences(TextRange range, int index) {
                String orderPart = range.substring(orderValue);
                range = new TextRange(range.getStartOffset() + 1, range.getEndOffset() + 1);
                List subParts = ExtensionOrderConverter.splitOrderPart(orderPart);
                if (subParts.isEmpty()) {
                    return Collections.emptyList();
                }
                String idSubPart = null;
                if (subParts.size() == 2) {
                    idSubPart = (String)subParts.get(1);
                } else if (ExtensionOrderConverter.isBeforeOrAfterKeyword(StringUtil.trimLeading((String)orderPart), false)) {
                    idSubPart = "";
                }
                if (subParts.size() > 2 || idSubPart != null && !ExtensionOrderConverter.isBeforeOrAfterKeyword((String)subParts.get(0))) {
                    return Collections.singletonList(new InvalidOrderPartPsiReference(this.getElement(), range, orderPart));
                }
                List wordIndices = ExtensionOrderConverter.getWordIndicesInOrderPart(orderPart);
                if (wordIndices.isEmpty()) {
                    LOG.error("Unexpected empty word indices list for 'order' part: " + orderPart);
                    return Collections.singletonList(new InvalidOrderPartPsiReference(this.getElement(), range, orderPart));
                }
                if (idSubPart != null && idSubPart.isEmpty()) {
                    wordIndices.add(new TextRange(orderPart.length(), orderPart.length()));
                }
                if (idSubPart == null) {
                    return Collections.emptyList();
                }
                assert (wordIndices.size() == 2) : wordIndices.toString();
                TextRange idSubPartRange = ((TextRange)wordIndices.get(1)).shiftRight(range.getStartOffset());
                return ContainerUtil.list((Object[])new PsiReference[]{new OrderReferencedIdPsiReference(this.getElement(), idSubPartRange, idSubPart, extension)});
            }
        }.getPsiReferences();
        if (psiReferenceArray == null) {
            ExtensionOrderConverter.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static List<String> splitOrderPart(String orderPart) {
        ArrayList<String> result = new ArrayList<String>();
        List subParts = StringUtil.split((String)orderPart, (String)" ");
        subParts.forEach(s -> {
            if (":".equals(s)) {
                result.add((String)s);
            } else {
                Collections.addAll(result, s.split(":"));
            }
        });
        return result;
    }

    private static List<TextRange> getWordIndicesInOrderPart(String orderPart) {
        return StringUtil.getWordIndicesIn((String)orderPart, (Set)ContainerUtil.set((Object[])new Character[]{Character.valueOf(' '), Character.valueOf(':')}));
    }

    private static boolean isBeforeOrAfterKeyword(String str) {
        return ExtensionOrderConverter.isBeforeOrAfterKeyword(str, true);
    }

    private static boolean isBeforeOrAfterKeyword(String str, boolean trimKeyword) {
        return (trimKeyword ? "before ".trim() : "before ").equalsIgnoreCase(str) || (trimKeyword ? "after ".trim() : "after ").equalsIgnoreCase(str) || "before:".equalsIgnoreCase(str) || "before:".equalsIgnoreCase(str);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/ExtensionOrderConverter", "createReferences"));
    }

    private static class OrderReferencedIdPsiReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        private final String myReferencedId;
        private final Extension myExtension;

        public OrderReferencedIdPsiReference(@NotNull PsiElement element, @NotNull TextRange rangeInElement, @NotNull String referencedId, @NotNull Extension extension) {
            if (element == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(0);
            }
            if (rangeInElement == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(1);
            }
            if (referencedId == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(2);
            }
            if (extension == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(3);
            }
            super(element, rangeInElement);
            this.myReferencedId = referencedId;
            this.myExtension = extension;
        }

        @Nullable
        public PsiElement resolve() {
            ExtensionPoint extensionPoint = this.myExtension.getExtensionPoint();
            if (extensionPoint == null) {
                return null;
            }
            ExtensionLocator epAndIdLocator = ExtensionLocator.byExtensionPointAndId(extensionPoint, this.myReferencedId);
            List<ExtensionCandidate> candidates = epAndIdLocator.findCandidates();
            if (candidates.isEmpty()) {
                return null;
            }
            XmlTag referencedElement = (XmlTag)candidates.iterator().next().pointer.getElement();
            if (referencedElement == null) {
                return null;
            }
            DomManager domManager = DomManager.getDomManager((Project)referencedElement.getProject());
            DomElement domElement = domManager.getDomElement(referencedElement);
            if (domElement == null) {
                return referencedElement;
            }
            DomTarget target = DomTarget.getTarget((DomElement)domElement);
            if (target == null) {
                return referencedElement;
            }
            return PomService.convertToPsi((PsiTarget)target);
        }

        @NotNull
        public Object[] getVariants() {
            ExtensionPoint extensionPoint = this.myExtension.getExtensionPoint();
            if (extensionPoint == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    OrderReferencedIdPsiReference.$$$reportNull$$$0(4);
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            ExtensionLocator epLocator = ExtensionLocator.byExtensionPoint(extensionPoint);
            List<ExtensionCandidate> candidates = epLocator.findCandidates();
            Project project = this.getElement().getProject();
            DomManager domManager = DomManager.getDomManager((Project)project);
            ArrayList<Extension> extensionsForThisEp = new ArrayList<Extension>();
            for (ExtensionCandidate candidate : candidates) {
                XmlTag tag = (XmlTag)candidate.pointer.getElement();
                DomElement domElement = domManager.getDomElement(tag);
                if (!(domElement instanceof Extension)) continue;
                extensionsForThisEp.add((Extension)domElement);
            }
            Map<Extension, String> targetExtensionsWithMarks = this.filterAndMarkExtensions(extensionsForThisEp, project);
            List<LookupElement> idCompletionVariants = OrderReferencedIdPsiReference.getLookupElements(targetExtensionsWithMarks);
            Object[] objectArray = idCompletionVariants.toArray(new LookupElement[idCompletionVariants.size()]);
            if (objectArray == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(5);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            ExtensionPoint ep = this.myExtension.getExtensionPoint();
            String string = "Cannot resolve ''{0}'' " + (ep != null ? ep.getEffectiveName() + " " : "") + "extension";
            if (string == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(6);
            }
            return string;
        }

        public boolean isSoft() {
            return true;
        }

        private Map<Extension, String> filterAndMarkExtensions(List<Extension> extensionsForThisEp, Project project) {
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            GlobalSearchScope resolveScope = this.getElement().getResolveScope();
            PsiClass languageEpClass = javaPsiFacade.findClass(LanguageExtensionPoint.class.getCanonicalName(), resolveScope);
            if (languageEpClass == null) {
                return Collections.emptyMap();
            }
            PsiClass fileTypeEpClass = javaPsiFacade.findClass(FileTypeExtensionPoint.class.getCanonicalName(), resolveScope);
            if (fileTypeEpClass == null) {
                return Collections.emptyMap();
            }
            String currentExtensionId = this.myExtension.getId().getStringValue();
            String currentExtensionLanguage = OrderReferencedIdPsiReference.getSpecificExtensionAttribute(this.myExtension, languageEpClass, "language");
            String currentExtensionFileType = OrderReferencedIdPsiReference.getSpecificExtensionAttribute(this.myExtension, fileTypeEpClass, "filetype");
            HashMap result = new HashMap();
            for (Extension extension : extensionsForThisEp) {
                String fileType;
                String language;
                String id = extension.getId().getStringValue();
                if (StringUtil.isEmpty((String)id) || id.equals(currentExtensionId)) continue;
                String extensionMark = null;
                if (currentExtensionLanguage != null && (language = OrderReferencedIdPsiReference.getSpecificExtensionAttribute(extension, languageEpClass, "language")) != null) {
                    if (!language.equals("any") && !language.isEmpty() && !language.equals(currentExtensionLanguage)) continue;
                    extensionMark = language;
                }
                if (currentExtensionFileType != null && (fileType = OrderReferencedIdPsiReference.getSpecificExtensionAttribute(extension, fileTypeEpClass, "filetype")) != null) {
                    if (!currentExtensionFileType.equals(fileType)) continue;
                    extensionMark = extensionMark != null ? null : fileType;
                }
                result.put(extension, extensionMark);
            }
            return result;
        }

        @NotNull
        private static List<LookupElement> getLookupElements(@NotNull Map<Extension, String> targetExtensionsWithMarks) {
            if (targetExtensionsWithMarks == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(7);
            }
            ArrayList<LookupElement> result = new ArrayList<LookupElement>(targetExtensionsWithMarks.size());
            for (Map.Entry<Extension, String> entry : targetExtensionsWithMarks.entrySet()) {
                Extension extension = entry.getKey();
                String mark = entry.getValue();
                PsiElement targetElement = OrderReferencedIdPsiReference.getTargetElement(extension);
                String id = extension.getId().getStringValue();
                if (StringUtil.isEmpty((String)id)) {
                    LOG.error("Unexpected empty id in target extension: " + extension);
                    continue;
                }
                result.add(OrderReferencedIdPsiReference.createLookupElement(targetElement, id, extension.getModule(), mark));
            }
            ArrayList<LookupElement> arrayList = result;
            if (arrayList == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        @Nullable
        private static String getSpecificExtensionAttribute(@NotNull Extension e, @NotNull PsiClass parentBeanClass, @NotNull String attribute) {
            ExtensionPoint ep;
            if (e == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(9);
            }
            if (parentBeanClass == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(10);
            }
            if (attribute == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(11);
            }
            if ((ep = e.getExtensionPoint()) == null) {
                return null;
            }
            PsiClass beanClass = (PsiClass)ep.getBeanClass().getValue();
            if (beanClass == null) {
                return null;
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)beanClass, (PsiClass)parentBeanClass, (boolean)true)) {
                return null;
            }
            DomAttributeChildDescription attributeDescription = e.getGenericInfo().getAttributeChildDescription(attribute);
            if (attributeDescription == null) {
                return null;
            }
            return attributeDescription.getDomAttributeValue((DomElement)e).getStringValue();
        }

        @NotNull
        private static PsiElement getTargetElement(Extension e) {
            DomTarget extensionTarget = DomTarget.getTarget((DomElement)e);
            if (extensionTarget != null) {
                PsiElement psiElement = PomService.convertToPsi((PsiTarget)extensionTarget);
                if (psiElement == null) {
                    OrderReferencedIdPsiReference.$$$reportNull$$$0(12);
                }
                return psiElement;
            }
            XmlTag xmlTag = e.getXmlTag();
            if (xmlTag == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(13);
            }
            return xmlTag;
        }

        @NotNull
        private static LookupElement createLookupElement(@NotNull PsiElement targetElement, @NotNull String id, @Nullable Module module, @Nullable String mark) {
            if (targetElement == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(14);
            }
            if (id == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(15);
            }
            LookupElementBuilder element = LookupElementBuilder.create((Object)targetElement, (String)id);
            if (module != null) {
                element = element.withTypeText(module.getName(), ModuleType.get((Module)module).getIcon(), false).withTypeIconRightAligned(true);
            }
            if (mark != null) {
                element = element.withTailText(" {" + mark + "}", true);
            }
            LookupElementBuilder lookupElementBuilder = element;
            if (lookupElementBuilder == null) {
                OrderReferencedIdPsiReference.$$$reportNull$$$0(16);
            }
            return lookupElementBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 12: 
                case 13: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 12: 
                case 13: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referencedId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 12: 
                case 13: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/dom/ExtensionOrderConverter$OrderReferencedIdPsiReference";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetExtensionsWithMarks";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentBeanClass";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetElement";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/dom/ExtensionOrderConverter$OrderReferencedIdPsiReference";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupElements";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetElement";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 12: 
                case 13: 
                case 16: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupElements";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpecificExtensionAttribute";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 12: 
                case 13: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InvalidOrderPartPsiReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        private final String myOrderPart;

        public InvalidOrderPartPsiReference(@NotNull PsiElement element, @NotNull TextRange rangeInElement, String orderPart) {
            if (element == null) {
                InvalidOrderPartPsiReference.$$$reportNull$$$0(0);
            }
            if (rangeInElement == null) {
                InvalidOrderPartPsiReference.$$$reportNull$$$0(1);
            }
            super(element, rangeInElement);
            this.myOrderPart = orderPart;
        }

        @Nullable
        public PsiElement resolve() {
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                InvalidOrderPartPsiReference.$$$reportNull$$$0(2);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = DevKitBundle.message("invalid.order.attribute.part", this.myOrderPart.trim());
            if (string == null) {
                InvalidOrderPartPsiReference.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/dom/ExtensionOrderConverter$InvalidOrderPartPsiReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/dom/ExtensionOrderConverter$InvalidOrderPartPsiReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

