/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.impl.PropertyKeyReferenceProvider;

public class I18nReferenceContributor
extends PsiReferenceContributor {
    private static final String[] EXTENSION_TAG_NAMES = new String[]{"localInspection", "globalInspection", "configurable", "applicationConfigurable", "projectConfigurable"};
    private static final String[] TYPE_NAME_TAG = new String[]{"typeName"};
    private static final String INTENTION_ACTION_TAG = "intentionAction";
    private static final String INTENTION_ACTION_BUNDLE_TAG = "bundleName";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            I18nReferenceContributor.$$$reportNull$$$0(0);
        }
        I18nReferenceContributor.registerKeyProviders(registrar);
        I18nReferenceContributor.registerBundleNameProviders(registrar);
    }

    private static void registerKeyProviders(PsiReferenceRegistrar registrar) {
        XmlAttributeValuePattern pattern = I18nReferenceContributor.createPattern(EXTENSION_TAG_NAMES, "key", "groupKey");
        registrar.registerReferenceProvider((ElementPattern)pattern, (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "groupKey", "groupBundle"), 0.0);
        XmlAttributeValuePattern typeNameKeyPattern = I18nReferenceContributor.createPattern(TYPE_NAME_TAG, "resourceKey");
        registrar.registerReferenceProvider((ElementPattern)typeNameKeyPattern, (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "resourceKey", "resourceBundle"), 0.0);
        XmlTagPattern.Capture intentionActionKeyTagPattern = (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName("categoryKey")).withParent((ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName(INTENTION_ACTION_TAG)).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withName("idea-plugin")));
        registrar.registerReferenceProvider((ElementPattern)intentionActionKeyTagPattern, (PsiReferenceProvider)new PropertyKeyReferenceProvider(true, null, INTENTION_ACTION_BUNDLE_TAG));
    }

    private static void registerBundleNameProviders(PsiReferenceRegistrar registrar) {
        PsiReferenceProvider bundleReferenceProvider = new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new MyResourceBundleReference(element)};
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        XmlTagPattern.Capture resourceBundleTagPattern = (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName("resource-bundle")).withParent((ElementPattern)XmlPatterns.xmlTag().withName("idea-plugin"));
        registrar.registerReferenceProvider((ElementPattern)resourceBundleTagPattern, bundleReferenceProvider);
        XmlAttributeValuePattern bundlePattern = I18nReferenceContributor.createPattern(EXTENSION_TAG_NAMES, "bundle", "groupBundle");
        registrar.registerReferenceProvider((ElementPattern)bundlePattern, bundleReferenceProvider, 0.0);
        XmlAttributeValuePattern typeNameBundlePattern = I18nReferenceContributor.createPattern(TYPE_NAME_TAG, "resourceBundle");
        registrar.registerReferenceProvider((ElementPattern)typeNameBundlePattern, bundleReferenceProvider, 0.0);
        XmlTagPattern.Capture intentionActionBundleTagPattern = (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName(INTENTION_ACTION_BUNDLE_TAG)).withParent((ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName(INTENTION_ACTION_TAG)).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withName("idea-plugin")));
        registrar.registerReferenceProvider((ElementPattern)intentionActionBundleTagPattern, bundleReferenceProvider, 0.0);
    }

    private static XmlAttributeValuePattern createPattern(String[] tagNames, String ... attributeNames) {
        return (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue((String[])attributeNames).withSuperParent(2, (ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName(tagNames)).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withName("idea-plugin")));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor", "registerReferenceProviders"));
    }

    private static class MyResourceBundleReference
    extends ResourceBundleReference
    implements EmptyResolveMessageProvider {
        private MyResourceBundleReference(PsiElement element) {
            super(element, false);
        }

        @NotNull
        public Object[] getVariants() {
            Project project = this.myElement.getProject();
            PropertiesReferenceManager referenceManager = PropertiesReferenceManager.getInstance((Project)project);
            ArrayList variants = new ArrayList();
            referenceManager.processPropertiesFiles(GlobalSearchScopesCore.projectProductionScope((Project)project), (baseName, propertiesFile) -> {
                Icon icon = propertiesFile.getContainingFile().getIcon(2);
                String relativePath = ProjectUtil.calcRelativeToProjectPath((VirtualFile)propertiesFile.getVirtualFile(), (Project)project);
                variants.add(LookupElementBuilder.create((Object)propertiesFile, (String)baseName).withIcon(icon).withTailText(" (" + relativePath + ")", true));
                return true;
            }, (BundleNameEvaluator)this);
            Object[] objectArray = variants.toArray(new LookupElement[variants.size()]);
            if (objectArray == null) {
                MyResourceBundleReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            if ("Cannot resolve property bundle" == null) {
                MyResourceBundleReference.$$$reportNull$$$0(1);
            }
            return "Cannot resolve property bundle";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor$MyResourceBundleReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

