/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UBreakExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UContinueExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UForExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.ULoopExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class CutPasteDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("CutPasteId", "Likely cut & paste mistakes", "This lint check looks for cases where you have cut & pasted calls to `findViewById` but have forgotten to update the R.id field. It's possible that your code is simply (redundantly) looking up the field repeatedly, but lint cannot distinguish that from a case where you for example want to initialize fields `prev` and `next` and you cut & pasted `findViewById(R.id.prev)` and forgot to update the second initialization to `R.id.next`.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(CutPasteDetector.class, Scope.JAVA_FILE_SCOPE));
    private PsiMethod lastMethod;
    private Map<String, UCallExpression> ids;
    private Map<String, String> lhs;
    private Map<String, String> callOperands;

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("findViewById");
    }

    @Override
    public void visitMethod(JavaContext context, UCallExpression call, PsiMethod calledMethod) {
        if (call.getUastParent() instanceof UBinaryExpression && !UastExpressionUtils.isAssignment((UElement)call.getUastParent())) {
            return;
        }
        String leftSide = CutPasteDetector.getLhs(call);
        if (leftSide == null) {
            return;
        }
        UMethod method = (UMethod)UastUtils.getParentOfType((UElement)call, UMethod.class, (boolean)false);
        if (method == null) {
            return;
        }
        if (method != this.lastMethod) {
            this.ids = Maps.newHashMap();
            this.lhs = Maps.newHashMap();
            this.callOperands = Maps.newHashMap();
            this.lastMethod = method;
        }
        String callOperand = call.getReceiver() != null ? call.getReceiver().asSourceString() : "";
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        UExpression first = (UExpression)arguments.get(0);
        if (first instanceof UReferenceExpression) {
            UReferenceExpression type;
            UExpression operand;
            UReferenceExpression psiReferenceExpression = (UReferenceExpression)first;
            String id = psiReferenceExpression.getResolvedName();
            UExpression uExpression = operand = first instanceof UQualifiedReferenceExpression ? ((UQualifiedReferenceExpression)first).getReceiver() : null;
            if (operand instanceof UReferenceExpression && "id".equals((type = (UReferenceExpression)operand).getResolvedName())) {
                if (this.ids.containsKey(id)) {
                    if (leftSide.equals(this.lhs.get(id))) {
                        return;
                    }
                    if (!callOperand.equals(this.callOperands.get(id))) {
                        return;
                    }
                    UCallExpression earlierCall = this.ids.get(id);
                    if (!CutPasteDetector.isReachableFrom(method, (UElement)earlierCall, (UElement)call)) {
                        return;
                    }
                    Location location = context.getLocation((UElement)call);
                    Location secondary = context.getLocation((UElement)earlierCall);
                    secondary.setMessage("First usage here");
                    location.setSecondary(secondary);
                    context.report(ISSUE, (UElement)call, location, String.format("The id `%1$s` has already been looked up in this method; possible cut & paste error?", first.asSourceString()));
                } else {
                    this.ids.put(id, call);
                    this.lhs.put(id, leftSide);
                    this.callOperands.put(id, callOperand);
                }
            }
        }
    }

    @Override
    public void afterCheckFile(Context context) {
        this.ids = null;
        this.lhs = null;
        this.callOperands = null;
        this.lastMethod = null;
    }

    private static String getLhs(UCallExpression call) {
        for (UElement parent = call.getUastParent(); parent != null && !(parent instanceof UBlockExpression); parent = parent.getUastParent()) {
            if (parent instanceof ULocalVariable) {
                return ((ULocalVariable)parent).getName();
            }
            if (!UastExpressionUtils.isAssignment((UElement)parent)) continue;
            UExpression left = ((UBinaryExpression)parent).getLeftOperand();
            if (left instanceof UReferenceExpression) {
                return left.asSourceString();
            }
            if (!(left instanceof UArrayAccessExpression)) continue;
            UArrayAccessExpression aa = (UArrayAccessExpression)left;
            return aa.getReceiver().asSourceString();
        }
        return null;
    }

    static boolean isReachableFrom(UMethod method, UElement from, UElement to) {
        ReachabilityVisitor visitor = new ReachabilityVisitor(from, to);
        method.accept((UastVisitor)visitor);
        return visitor.isReachable();
    }

    private static class ReachabilityVisitor
    extends AbstractUastVisitor {
        private final UElement from;
        private final UElement target;
        private boolean isFromReached;
        private boolean isTargetReachable;
        private boolean isFinished;
        private UExpression breakedExpression;
        private UExpression continuedExpression;

        ReachabilityVisitor(UElement from, UElement target) {
            this.from = from;
            this.target = target;
        }

        public boolean visitElement(UElement node) {
            if (this.isFinished || this.breakedExpression != null || this.continuedExpression != null) {
                return true;
            }
            if (node.equals(this.from)) {
                this.isFromReached = true;
            }
            if (node.equals(this.target)) {
                this.isFinished = true;
                if (this.isFromReached) {
                    this.isTargetReachable = true;
                }
                return true;
            }
            if (this.isFromReached) {
                if (node instanceof UReturnExpression) {
                    this.isFinished = true;
                } else if (node instanceof UBreakExpression) {
                    this.breakedExpression = ReachabilityVisitor.getBreakedExpression((UBreakExpression)node);
                } else if (node instanceof UContinueExpression) {
                    UExpression expression = ReachabilityVisitor.getContinuedExpression((UContinueExpression)node);
                    if (expression != null && UastUtils.isChildOf((UElement)this.target, (UElement)expression, (boolean)false)) {
                        this.isTargetReachable = true;
                        this.isFinished = true;
                    } else {
                        this.continuedExpression = expression;
                    }
                } else if (UastUtils.isChildOf((UElement)this.target, (UElement)node, (boolean)false)) {
                    this.isTargetReachable = true;
                    this.isFinished = true;
                }
                return true;
            }
            if (node instanceof UIfExpression) {
                UExpression elseExpression;
                UIfExpression ifExpression = (UIfExpression)node;
                ifExpression.getCondition().accept((UastVisitor)this);
                boolean isFromReached = this.isFromReached;
                UExpression thenExpression = ifExpression.getThenExpression();
                if (thenExpression != null) {
                    thenExpression.accept((UastVisitor)this);
                }
                if ((elseExpression = ifExpression.getElseExpression()) != null && isFromReached == this.isFromReached) {
                    elseExpression.accept((UastVisitor)this);
                }
                return true;
            }
            if (node instanceof ULoopExpression) {
                this.visitLoopExpressionHeader(node);
                boolean isFromReached = this.isFromReached;
                ((ULoopExpression)node).getBody().accept((UastVisitor)this);
                if (isFromReached != this.isFromReached && UastUtils.isChildOf((UElement)this.target, (UElement)node, (boolean)false)) {
                    this.isTargetReachable = true;
                    this.isFinished = true;
                }
                return true;
            }
            return false;
        }

        public void afterVisitElement(UElement node) {
            if (node.equals(this.breakedExpression)) {
                this.breakedExpression = null;
            } else if (node.equals(this.continuedExpression)) {
                this.continuedExpression = null;
            }
        }

        private void visitLoopExpressionHeader(UElement node) {
            if (node instanceof UWhileExpression) {
                ((UWhileExpression)node).getCondition().accept((UastVisitor)this);
            } else if (node instanceof UDoWhileExpression) {
                ((UDoWhileExpression)node).getCondition().accept((UastVisitor)this);
            } else if (node instanceof UForExpression) {
                UForExpression forExpression = (UForExpression)node;
                if (forExpression.getDeclaration() != null) {
                    forExpression.getDeclaration().accept((UastVisitor)this);
                }
                if (forExpression.getCondition() != null) {
                    forExpression.getCondition().accept((UastVisitor)this);
                }
                if (forExpression.getUpdate() != null) {
                    forExpression.getUpdate().accept((UastVisitor)this);
                }
            } else if (node instanceof UForEachExpression) {
                UForEachExpression forEachExpression = (UForEachExpression)node;
                forEachExpression.getForIdentifier().accept((UastVisitor)this);
                forEachExpression.getIteratedValue().accept((UastVisitor)this);
            }
        }

        private static UExpression getBreakedExpression(UBreakExpression node) {
            String label = node.getLabel();
            for (UElement parent = node.getUastParent(); parent != null; parent = parent.getUastParent()) {
                if (label != null) {
                    ULabeledExpression labeledExpression;
                    if (!(parent instanceof ULabeledExpression) || !(labeledExpression = (ULabeledExpression)parent).getLabel().equals(label)) continue;
                    return labeledExpression.getExpression();
                }
                if (!(parent instanceof ULoopExpression) && !(parent instanceof USwitchExpression)) continue;
                return (UExpression)parent;
            }
            return null;
        }

        private static UExpression getContinuedExpression(UContinueExpression node) {
            String label = node.getLabel();
            for (UElement parent = node.getUastParent(); parent != null; parent = parent.getUastParent()) {
                if (label != null) {
                    ULabeledExpression labeledExpression;
                    if (!(parent instanceof ULabeledExpression) || !(labeledExpression = (ULabeledExpression)parent).getLabel().equals(label)) continue;
                    return labeledExpression.getExpression();
                }
                if (!(parent instanceof ULoopExpression)) continue;
                return (UExpression)parent;
            }
            return null;
        }

        public boolean isReachable() {
            return this.isTargetReachable;
        }
    }
}

