/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NegativeMarginDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(NegativeMarginDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("NegativeMargin", "Negative Margins", "Margin values should be positive. Negative values are generally a sign that you are making assumptions about views surrounding the current one, or may be tempted to turn off child clipping to allow a view to escape its parent. Turning off child clipping to do this not only leads to poor graphical performance, it also results in wrong touch event handling since touch events are based strictly on a chain of parent-rect hit tests. Finally, making assumptions about the size of strings can lead to localization problems.", Category.USABILITY, 4, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    private HashMap<String, Location.Handle> mDimenUsage;

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("layout_margin", "layout_marginLeft", "layout_marginTop", "layout_marginRight", "layout_marginBottom", "layout_marginStart", "layout_marginEnd");
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("dimen", "style");
    }

    @Override
    public void visitAttribute(XmlContext context, Attr attribute) {
        String value = attribute.getValue();
        this.checkMarginValue(context, value, attribute, null);
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        block7: {
            String tag;
            block6: {
                Location.Handle handle;
                if (context.getResourceFolderType() != ResourceFolderType.VALUES) {
                    return;
                }
                tag = element.getTagName();
                if (!"dimen".equals(tag)) break block6;
                NodeList itemNodes = element.getChildNodes();
                String name = element.getAttribute("name");
                Location.Handle handle2 = handle = this.mDimenUsage != null ? this.mDimenUsage.get(name) : null;
                if (handle == null) break block7;
                int nodeCount = itemNodes.getLength();
                for (int j = 0; j < nodeCount; ++j) {
                    Node item = itemNodes.item(j);
                    if (item.getNodeType() != 3) continue;
                    String text = item.getNodeValue().trim();
                    this.checkMarginValue(context, text, null, handle);
                }
                break block7;
            }
            assert ("style".equals(tag)) : tag;
            NodeList itemNodes = element.getChildNodes();
            int nodeCount = itemNodes.getLength();
            for (int j = 0; j < nodeCount; ++j) {
                Element itemElement;
                String name;
                Node item = itemNodes.item(j);
                if (item.getNodeType() != 1 || !"item".equals(item.getNodeName()) || !(name = (itemElement = (Element)item).getAttribute("name")).startsWith("android:") || !name.startsWith("layout_margin", "android:".length())) continue;
                NodeList childNodes = item.getChildNodes();
                int n = childNodes.getLength();
                for (int i = 0; i < n; ++i) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() != 3) {
                        return;
                    }
                    this.checkMarginValue(context, child.getNodeValue(), child, null);
                }
            }
        }
    }

    private static boolean isNegativeDimension(String value) {
        return value.trim().startsWith("-");
    }

    private void checkMarginValue(XmlContext context, String value, Node scope, Location.Handle handle) {
        if (NegativeMarginDetector.isNegativeDimension(value)) {
            String message = "Margin values should not be negative";
            if (scope != null) {
                context.report(ISSUE, scope, context.getLocation(scope), message);
            } else {
                assert (handle != null);
                context.report(ISSUE, handle.resolve(), message);
            }
        } else if (value.startsWith("@dimen/") && scope != null) {
            ResourceUrl url = ResourceUrl.parse((String)value);
            if (url == null) {
                return;
            }
            if (context.getClient().supportsProjectResources()) {
                List items;
                Project project;
                LintClient client = context.getClient();
                AbstractResourceRepository resources = client.getResourceRepository(project = context.getProject(), true, true);
                if (resources != null && (items = resources.getResourceItem(url.type, url.name)) != null) {
                    for (ResourceItem item : items) {
                        String dimenValue;
                        ResourceValue resourceValue = item.getResourceValue(false);
                        if (resourceValue == null || (dimenValue = resourceValue.getValue()) == null || !NegativeMarginDetector.isNegativeDimension(dimenValue)) continue;
                        ResourceFile sourceFile = (ResourceFile)item.getSource();
                        assert (sourceFile != null);
                        String message = String.format("Margin values should not be negative (`%1$s` is defined as `%2$s` in `%3$s`", value, dimenValue, LintUtils.getFileNameWithParent(client, sourceFile.getFile()));
                        context.report(ISSUE, scope, context.getLocation(scope), message);
                        break;
                    }
                }
            } else if (!context.getDriver().isSuppressed(context, ISSUE, scope)) {
                if (this.mDimenUsage == null) {
                    this.mDimenUsage = new HashMap();
                }
                this.mDimenUsage.put(url.name, context.createLocationHandle(scope));
            }
        }
    }
}

