/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiVariable;
import java.util.List;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.util.UastExpressionUtils;

public class PermissionFinder {
    private final JavaContext mContext;
    private final Operation mOperation;

    public static Result findRequiredPermissions(JavaContext context, Operation operation, UElement parameter) {
        return new PermissionFinder(context, operation).search(parameter);
    }

    private PermissionFinder(JavaContext context, Operation operation) {
        this.mContext = context;
        this.mOperation = operation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result search(UElement node) {
        PsiVariable variable;
        UExpression lastAssignment;
        if (UastLiteralUtils.isNullLiteral((UElement)node)) {
            return null;
        }
        if (node instanceof UIfExpression) {
            Result result;
            UIfExpression expression = (UIfExpression)node;
            if (expression.getThenExpression() != null && (result = this.search((UElement)expression.getThenExpression())) != null) {
                return result;
            }
            if (expression.getElseExpression() == null || (result = this.search((UElement)expression.getElseExpression())) == null) return null;
            return result;
        }
        if (UastExpressionUtils.isTypeCast((UElement)node)) {
            UBinaryExpressionWithType cast = (UBinaryExpressionWithType)node;
            UExpression operand = cast.getOperand();
            return this.search((UElement)operand);
        }
        if (node instanceof UParenthesizedExpression) {
            UParenthesizedExpression parens = (UParenthesizedExpression)node;
            UExpression expression = parens.getExpression();
            if (expression == null) return null;
            return this.search((UElement)expression);
        }
        if (UastExpressionUtils.isConstructorCall((UElement)node) && this.mOperation == Operation.ACTION) {
            UExpression action;
            List expressions;
            String type;
            UCallExpression call = (UCallExpression)node;
            UReferenceExpression classReference = call.getClassReference();
            String string = type = classReference != null ? UastUtils.getQualifiedName((UReferenceExpression)classReference) : null;
            if (!"android.content.Intent".equals(type) || (expressions = call.getValueArguments()).isEmpty() || (action = (UExpression)expressions.get(0)) == null) return null;
            return this.search((UElement)action);
        }
        if (!(node instanceof UReferenceExpression)) return null;
        PsiElement resolved = ((UReferenceExpression)node).resolve();
        if (resolved instanceof PsiField) {
            PsiField field = (PsiField)resolved;
            if (this.mOperation == Operation.ACTION) {
                PsiAnnotation annotation = this.mContext.getEvaluator().findAnnotation((PsiModifierListOwner)field, "android.support.annotation.RequiresPermission");
                if (annotation != null) {
                    return this.getPermissionRequirement(field, JavaUAnnotation.wrap((PsiAnnotation)annotation));
                }
            } else if (this.mOperation == Operation.READ || this.mOperation == Operation.WRITE) {
                String fqn = this.mOperation == Operation.READ ? "android.support.annotation.RequiresPermission.Read" : "android.support.annotation.RequiresPermission.Write";
                PsiAnnotation annotation = this.mContext.getEvaluator().findAnnotation((PsiModifierListOwner)field, fqn);
                if (annotation != null) {
                    PsiNameValuePair o;
                    PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
                    PsiNameValuePair psiNameValuePair = o = attributes.length == 1 ? attributes[0] : null;
                    if (o == null || !(o.getValue() instanceof PsiAnnotation)) return this.getPermissionRequirement(field, JavaUAnnotation.wrap((PsiAnnotation)annotation));
                    annotation = (PsiAnnotation)o.getValue();
                    if ("android.support.annotation.RequiresPermission".equals(annotation.getQualifiedName())) {
                        return this.getPermissionRequirement(field, JavaUAnnotation.wrap((PsiAnnotation)annotation));
                    }
                }
            } else assert (false) : this.mOperation;
        }
        if (!(resolved instanceof PsiVariable) || (lastAssignment = UastLintUtils.findLastAssignment(variable = (PsiVariable)resolved, node)) == null) return null;
        return this.search((UElement)lastAssignment);
    }

    private Result getPermissionRequirement(PsiField field, UAnnotation annotation) {
        String name;
        PermissionRequirement requirement = PermissionRequirement.create(annotation);
        PsiClass containingClass = field.getContainingClass();
        String string = name = containingClass != null ? containingClass.getName() + "." + field.getName() : field.getName();
        assert (name != null);
        return new Result(this.mOperation, requirement, name);
    }

    public static class Result {
        public final PermissionRequirement requirement;
        public final String name;
        public final Operation operation;

        public Result(Operation operation, PermissionRequirement requirement, String name) {
            this.operation = operation;
            this.requirement = requirement;
            this.name = name;
        }
    }

    public static enum Operation {
        CALL,
        ACTION,
        READ,
        WRITE;


        public String prefix() {
            switch (this) {
                case ACTION: {
                    return "by intent";
                }
                case READ: {
                    return "to read";
                }
                case WRITE: {
                    return "to write";
                }
            }
            return "by";
        }
    }
}

