/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceCycleDetector
extends ResourceXmlDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(ResourceCycleDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue CYCLE = Issue.create("ResourceCycle", "Cycle in resource definitions", "There should be no cycles in resource definitions as this can lead to runtime exceptions.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
    public static final Issue CRASH = Issue.create("AaptCrash", "Potential AAPT crash", "Defining a style which sets `android:id` to a dynamically generated id can cause many versions of `aapt`, the resource packaging tool, to crash. To work around this, declare the id explicitly with `<item type=\"id\" name=\"...\" />` instead.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION).addMoreInfo("https://code.google.com/p/android/issues/detail?id=20479");
    private Map<ResourceType, Multimap<String, String>> mReferences;
    private Map<ResourceType, Multimap<String, Location>> mLocations;
    private Map<ResourceType, List<List<String>>> mChains;

    @Override
    public void beforeCheckProject(Context context) {
        if (context.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
            this.mReferences = Maps.newEnumMap(ResourceType.class);
        }
    }

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.FONT || folderType == ResourceFolderType.COLOR || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.LAYOUT;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("include", "style", "color", "item", "font");
    }

    private void recordReference(ResourceType type, String from, String to) {
        int index;
        if (to.isEmpty() || to.startsWith("@android:")) {
            return;
        }
        assert (this.mReferences != null);
        ListMultimap map = this.mReferences.get(type);
        if (map == null) {
            map = Multimaps.newListMultimap(new TreeMap(), () -> Lists.newArrayListWithExpectedSize((int)6));
            this.mReferences.put(type, (Multimap<String, String>)map);
        }
        if (to.charAt(0) == '@' && (index = to.indexOf(47)) != -1) {
            to = to.substring(index + 1);
        }
        map.put((Object)from, (Object)to);
    }

    private void recordLocation(XmlContext context, Node node, ResourceType type, String from) {
        assert (this.mLocations != null);
        ArrayListMultimap map = this.mLocations.get(type);
        if (map == null) {
            map = ArrayListMultimap.create((int)30, (int)4);
            this.mLocations.put(type, (Multimap<String, Location>)map);
        }
        Location location = context.getLocation(node);
        map.put((Object)from, (Object)location);
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        Attr text;
        String tagName = element.getTagName();
        if (tagName.equals("item")) {
            String drawable;
            if (this.mReferences == null) {
                return;
            }
            ResourceFolderType folderType = context.getResourceFolderType();
            if (folderType == ResourceFolderType.VALUES) {
                Attr typeNode = element.getAttributeNode("type");
                if (typeNode != null) {
                    String typeName = typeNode.getValue();
                    ResourceType type = ResourceType.getEnum((String)typeName);
                    Attr nameNode = element.getAttributeNode("name");
                    if (type != null && nameNode != null) {
                        NodeList childNodes = element.getChildNodes();
                        int n = childNodes.getLength();
                        for (int i = 0; i < n; ++i) {
                            char c;
                            Node child = childNodes.item(i);
                            if (child.getNodeType() != 3) continue;
                            String text2 = child.getNodeValue();
                            int max = text2.length();
                            for (int k = 0; k < max && !Character.isWhitespace(c = text2.charAt(k)) && c == '@' && text2.startsWith(type.getName(), k + 1); ++k) {
                                String to = text2.trim();
                                if (this.mReferences == null) continue;
                                String name = nameNode.getValue();
                                if (this.mLocations != null) {
                                    this.recordLocation(context, child, type, name);
                                    continue;
                                }
                                this.recordReference(type, name, to);
                            }
                        }
                    }
                }
            } else if (folderType == ResourceFolderType.COLOR) {
                String color = element.getAttributeNS("http://schemas.android.com/apk/res/android", "color");
                if (color != null && color.startsWith("@color/")) {
                    String currentColor = LintUtils.getBaseName(context.file.getName());
                    if (this.mLocations != null) {
                        this.recordLocation(context, element, ResourceType.COLOR, currentColor);
                    } else {
                        this.recordReference(ResourceType.COLOR, currentColor, color.substring("@color/".length()));
                    }
                }
            } else if (folderType == ResourceFolderType.DRAWABLE && (drawable = element.getAttributeNS("http://schemas.android.com/apk/res/android", "drawable")) != null && drawable.startsWith("@drawable/")) {
                String currentColor = LintUtils.getBaseName(context.file.getName());
                if (this.mLocations != null) {
                    this.recordLocation(context, element, ResourceType.DRAWABLE, currentColor);
                } else {
                    this.recordReference(ResourceType.DRAWABLE, currentColor, drawable.substring("@drawable/".length()));
                }
            }
        } else if (tagName.equals("style")) {
            int index;
            Object name;
            Attr nameNode = element.getAttributeNode("name");
            Attr parentNode = element.getAttributeNode("parent");
            if (parentNode != null && nameNode != null) {
                name = nameNode.getValue();
                String parent = parentNode.getValue();
                if (parent.endsWith((String)name) && parent.equals("@style/" + (String)name) && context.isEnabled(CYCLE) && context.getDriver().getPhase() == 1) {
                    context.report(CYCLE, parentNode, context.getLocation(parentNode), String.format("Style `%1$s` should not extend itself", name));
                } else if (parent.startsWith("@style/") && parent.startsWith((String)name, "@style/".length()) && parent.startsWith(".", "@style/".length() + ((String)name).length()) && context.isEnabled(CYCLE) && context.getDriver().getPhase() == 1) {
                    context.report(CYCLE, parentNode, context.getLocation(parentNode), String.format("Potential cycle: `%1$s` is the implied parent of `%2$s` and this defines the opposite", name, parent.substring("@style/".length())));
                    return;
                }
                if (this.mReferences != null && !parent.isEmpty()) {
                    if (this.mLocations != null) {
                        this.recordLocation(context, parentNode, ResourceType.STYLE, (String)name);
                    } else {
                        this.recordReference(ResourceType.STYLE, (String)name, parent);
                    }
                }
            } else if (this.mReferences != null && nameNode != null && (index = ((String)(name = nameNode.getValue())).lastIndexOf(46)) > 0) {
                String parent = ((String)name).substring(0, index);
                if (this.mReferences != null) {
                    if (this.mLocations != null) {
                        Attr node = element.getAttributeNode("name");
                        this.recordLocation(context, node, ResourceType.STYLE, (String)name);
                    } else {
                        this.recordReference(ResourceType.STYLE, (String)name, parent);
                    }
                }
            }
            if (context.isEnabled(CRASH) && context.getDriver().getPhase() == 1) {
                for (Element item : XmlUtils.getSubTags((Node)element)) {
                    if (!"android:id".equals(item.getAttribute("name"))) continue;
                    ResourceCycleDetector.checkCrashItem(context, item);
                }
            }
        } else if (tagName.equals("include")) {
            String layout;
            Attr layoutNode = element.getAttributeNode("layout");
            if (layoutNode != null && (layout = layoutNode.getValue()).startsWith("@layout/")) {
                String currentLayout = LintUtils.getBaseName(context.file.getName());
                if (this.mReferences != null) {
                    if (this.mLocations != null) {
                        this.recordLocation(context, layoutNode, ResourceType.LAYOUT, currentLayout);
                    } else {
                        this.recordReference(ResourceType.LAYOUT, currentLayout, layout);
                    }
                }
                if (layout.startsWith(currentLayout, "@layout/".length()) && layout.length() == currentLayout.length() + "@layout/".length() && context.isEnabled(CYCLE) && context.getDriver().getPhase() == 1) {
                    String message = String.format("Layout `%1$s` should not include itself", currentLayout);
                    context.report(CYCLE, layoutNode, context.getLocation(layoutNode), message);
                }
            }
        } else if (tagName.equals("color")) {
            NodeList childNodes = element.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                char c;
                Node child = childNodes.item(i);
                if (child.getNodeType() != 3) continue;
                String text3 = child.getNodeValue();
                int max = text3.length();
                for (int k = 0; k < max && !Character.isWhitespace(c = text3.charAt(k)) && text3.startsWith("@color/", k); ++k) {
                    String color = text3.trim().substring("@color/".length());
                    String name = element.getAttribute("name");
                    if (this.mReferences != null) {
                        if (this.mLocations != null) {
                            this.recordLocation(context, child, ResourceType.COLOR, name);
                        } else {
                            this.recordReference(ResourceType.COLOR, name, color);
                        }
                    }
                    if (!color.equals(name) || !context.isEnabled(CYCLE) || context.getDriver().getPhase() != 1) continue;
                    context.report(CYCLE, child, context.getLocation(child), String.format("Color `%1$s` should not reference itself", color));
                }
            }
        } else if (tagName.equals("font") && (text = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "font")) != null && text.getValue().startsWith("@font/")) {
            String font = text.getValue().trim().substring("@font/".length());
            String currentFont = LintUtils.getBaseName(context.file.getName());
            if (this.mReferences != null) {
                if (this.mLocations != null) {
                    this.recordLocation(context, text, ResourceType.FONT, currentFont);
                } else {
                    this.recordReference(ResourceType.FONT, currentFont, font);
                }
            }
            if (currentFont.equals(font) && context.isEnabled(CYCLE) && context.getDriver().getPhase() == 1) {
                context.report(CYCLE, text, context.getLocation(text), String.format("Font `%1$s` should not reference itself", font));
            }
        }
    }

    private static void checkCrashItem(XmlContext context, Element item) {
        NodeList childNodes = item.getChildNodes();
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            int max = text.length();
            for (int k = 0; k < max; ++k) {
                char c = text.charAt(k);
                if (Character.isWhitespace(c)) {
                    return;
                }
                if (!text.startsWith("@+id/", k)) {
                    return;
                }
                String name = text.trim().substring("@+id/".length());
                String message = "This construct can potentially crash `aapt` during a build. Change `@+id/" + name + "` to `@id/" + name + "` and define the id explicitly using `<item type=\"id\" name=\"" + name + "\"/>` instead.";
                context.report(CRASH, item, context.getLocation(item), message);
            }
        }
    }

    @Override
    public void afterCheckProject(Context context) {
        if (this.mReferences == null) {
            return;
        }
        int phase = context.getDriver().getPhase();
        if (phase == 1) {
            for (Map.Entry<ResourceType, Multimap<String, String>> entry : this.mReferences.entrySet()) {
                ResourceType type = entry.getKey();
                Multimap<String, String> map = entry.getValue();
                this.findCycles(context, type, map);
            }
        } else {
            assert (phase == 2);
            for (Map.Entry<ResourceType, List<List<String>>> entry : this.mChains.entrySet()) {
                ResourceType type = entry.getKey();
                ArrayListMultimap locations = this.mLocations.get(type);
                if (locations == null) {
                    locations = ArrayListMultimap.create();
                }
                List<List<String>> chains = entry.getValue();
                for (List<String> chain : chains) {
                    Location location = null;
                    assert (!chain.isEmpty());
                    int n = chain.size();
                    for (int i = 0; i < n; ++i) {
                        String item = chain.get(i);
                        Collection itemLocations = locations.get((Object)item);
                        if (itemLocations.isEmpty()) continue;
                        Location itemLocation = (Location)itemLocations.iterator().next();
                        String next = chain.get((i + 1) % chain.size());
                        String label = "Reference from @" + type.getName() + "/" + item + " to " + type.getName() + "/" + next + " here";
                        itemLocation.setMessage(label);
                        itemLocation.setSecondary(location);
                        location = itemLocation;
                    }
                    if (location == null) {
                        location = Location.create(context.getProject().getDir());
                    } else {
                        Location curr = location.getSecondary();
                        while (curr != null) {
                            Location next = curr.getSecondary();
                            if (next == location) {
                                curr.setSecondary(null);
                                break;
                            }
                            curr = next;
                        }
                    }
                    String message = String.format("%1$s Resource definition cycle: %2$s", type.getDisplayName(), Joiner.on((String)" => ").join(chain));
                    context.report(CYCLE, location, message);
                }
            }
        }
    }

    private void findCycles(Context context, ResourceType type, Multimap<String, String> map) {
        HashSet visiting = Sets.newHashSet();
        HashSet visited = Sets.newHashSetWithExpectedSize((int)map.size());
        HashSet seen = Sets.newHashSetWithExpectedSize((int)map.size());
        for (String from : map.keySet()) {
            ArrayList list;
            List<String> chain;
            if (seen.contains(from) || (chain = ResourceCycleDetector.dfs(map, from, visiting, visited)) == null || chain.size() <= 2) continue;
            seen.addAll(chain);
            Collections.reverse(chain);
            if (this.mChains == null) {
                this.mChains = Maps.newEnumMap(ResourceType.class);
                this.mLocations = Maps.newEnumMap(ResourceType.class);
                context.getDriver().requestRepeat(this, Scope.RESOURCE_FILE_SCOPE);
            }
            if ((list = this.mChains.get(type)) == null) {
                list = Lists.newArrayList();
                this.mChains.put(type, list);
            }
            list.add(chain);
        }
    }

    private static List<String> dfs(Multimap<String, String> map, String from, Set<String> visiting, Set<String> visited) {
        visiting.add(from);
        visited.add(from);
        Collection targets = map.get((Object)from);
        if (targets != null && !targets.isEmpty()) {
            for (String target : targets) {
                List<Object> chain;
                if (visiting.contains(target)) {
                    chain = Lists.newArrayList();
                    chain.add(target);
                    chain.add(from);
                    return chain;
                }
                if (visited.contains(target) || (chain = ResourceCycleDetector.dfs(map, target, visiting, visited)) == null) continue;
                chain.add(from);
                return chain;
            }
        }
        visiting.remove(from);
        return null;
    }
}

