/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0016J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\b\u0010\u000b\u001a\u00020\tH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/client/api/CompositeIssueRegistry;", "Lcom/android/tools/lint/client/api/IssueRegistry;", "registries", "", "(Ljava/util/List;)V", "issues", "Lcom/android/tools/lint/detector/api/Issue;", "getIssues", "hasLombokLegacyDetectors", "", "hasPsiLegacyDetectors", "isUpToDate", "lint-api"})
public final class CompositeIssueRegistry
extends IssueRegistry {
    private List<Issue> issues;
    private final List<IssueRegistry> registries;

    @Override
    @NotNull
    public List<Issue> getIssues() {
        List<Issue> issues = this.issues;
        if (issues != null) {
            return issues;
        }
        int capacity = 0;
        for (IssueRegistry registry : this.registries) {
            capacity += registry.getIssues().size();
        }
        ArrayList list = new ArrayList(capacity);
        for (IssueRegistry registry : this.registries) {
            list.addAll(registry.getIssues());
        }
        this.issues = list;
        return list;
    }

    @Override
    public boolean isUpToDate() {
        for (IssueRegistry registry : this.registries) {
            if (registry.isUpToDate()) continue;
            return false;
        }
        return true;
    }

    public final boolean hasLombokLegacyDetectors() {
        for (IssueRegistry registry : this.registries) {
            if (registry instanceof JarFileIssueRegistry && ((JarFileIssueRegistry)registry).hasLombokLegacyDetectors()) {
                return true;
            }
            if (!(registry instanceof CompositeIssueRegistry) || !((CompositeIssueRegistry)registry).hasLombokLegacyDetectors()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasPsiLegacyDetectors() {
        for (IssueRegistry registry : this.registries) {
            if (registry instanceof JarFileIssueRegistry && ((JarFileIssueRegistry)registry).hasPsiLegacyDetectors()) {
                return true;
            }
            if (!(registry instanceof CompositeIssueRegistry) || !((CompositeIssueRegistry)registry).hasPsiLegacyDetectors()) continue;
            return true;
        }
        return false;
    }

    public CompositeIssueRegistry(@NotNull List<? extends IssueRegistry> registries) {
        Intrinsics.checkParameterIsNotNull(registries, (String)"registries");
        this.registries = registries;
    }
}

