/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.google.common.annotations.Beta;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c2\u0003J)\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u0018\u001a\u00020\u0004H\u0016R\u0011\u0010\b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/detector/api/Category;", "", "parent", "name", "", "priority", "", "(Lcom/android/tools/lint/detector/api/Category;Ljava/lang/String;I)V", "fullName", "getFullName", "()Ljava/lang/String;", "getName", "getParent", "()Lcom/android/tools/lint/detector/api/Category;", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "Companion", "lint-api"})
@Beta
public final class Category
implements Comparable<Category> {
    @Nullable
    private final Category parent;
    @NotNull
    private final String name;
    private final int priority;
    @JvmField
    @NotNull
    public static final Category LINT;
    @JvmField
    @NotNull
    public static final Category CORRECTNESS;
    @JvmField
    @NotNull
    public static final Category SECURITY;
    @JvmField
    @NotNull
    public static final Category PERFORMANCE;
    @JvmField
    @NotNull
    public static final Category USABILITY;
    @JvmField
    @NotNull
    public static final Category A11Y;
    @JvmField
    @NotNull
    public static final Category I18N;
    @JvmField
    @NotNull
    public static final Category ICONS;
    @JvmField
    @NotNull
    public static final Category TYPOGRAPHY;
    @JvmField
    @NotNull
    public static final Category MESSAGES;
    @JvmField
    @NotNull
    public static final Category CHROME_OS;
    @JvmField
    @NotNull
    public static final Category RTL;
    public static final Companion Companion;

    @NotNull
    public final String getFullName() {
        return this.parent != null ? this.parent.getFullName() + ':' + this.name : this.name;
    }

    @NotNull
    public String toString() {
        return this.getFullName();
    }

    @Override
    public int compareTo(@NotNull Category other) {
        int delta;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (other.priority == this.priority) {
            if (this.parent == other) {
                return 1;
            }
            if (other.parent == this) {
                return -1;
            }
        }
        if ((delta = other.priority - this.priority) != 0) {
            return delta;
        }
        return this.name.compareTo(other.name);
    }

    @Nullable
    public final Category getParent() {
        return this.parent;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public Category(@Nullable Category parent, @NotNull String name, int priority) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.parent = parent;
        this.name = name;
        this.priority = priority;
    }

    static {
        Companion = new Companion(null);
        LINT = Companion.create("Lint", 110);
        CORRECTNESS = Companion.create("Correctness", 100);
        SECURITY = Companion.create("Security", 90);
        PERFORMANCE = Companion.create("Performance", 80);
        USABILITY = Companion.create("Usability", 70);
        A11Y = Companion.create("Accessibility", 60);
        I18N = Companion.create("Internationalization", 50);
        ICONS = Companion.create(USABILITY, "Icons", 73);
        TYPOGRAPHY = Companion.create(USABILITY, "Typography", 76);
        MESSAGES = Companion.create(CORRECTNESS, "Messages", 95);
        CHROME_OS = Companion.create(CORRECTNESS, "Chrome OS", 93);
        RTL = Companion.create(I18N, "Bidirectional Text", 40);
    }

    @Nullable
    public final Category component1() {
        return this.parent;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    private final int component3() {
        return this.priority;
    }

    @NotNull
    public final Category copy(@Nullable Category parent, @NotNull String name, int priority) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new Category(parent, name, priority);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Category copy$default(Category category, Category category2, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            category2 = category.parent;
        }
        if ((n2 & 2) != 0) {
            string = category.name;
        }
        if ((n2 & 4) != 0) {
            n = category.priority;
        }
        return category.copy(category2, string, n);
    }

    public int hashCode() {
        Category category = this.parent;
        String string = this.name;
        return ((category != null ? ((Object)category).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + Integer.hashCode(this.priority);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Category)) break block3;
                Category category = (Category)object;
                if (!Intrinsics.areEqual((Object)this.parent, (Object)category.parent) || !Intrinsics.areEqual((Object)this.name, (Object)category.name) || !(this.priority == category.priority)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Category create(@NotNull String name, int priority) {
        return Companion.create(name, priority);
    }

    @JvmStatic
    @NotNull
    public static final Category create(@Nullable Category parent, @NotNull String name, int priority) {
        return Companion.create(parent, name, priority);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/detector/api/Category$Companion;", "", "()V", "A11Y", "Lcom/android/tools/lint/detector/api/Category;", "CHROME_OS", "CORRECTNESS", "I18N", "ICONS", "LINT", "MESSAGES", "PERFORMANCE", "RTL", "SECURITY", "TYPOGRAPHY", "USABILITY", "create", "parent", "name", "", "priority", "", "lint-api"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Category create(@NotNull String name, int priority) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new Category(null, name, priority);
        }

        @JvmStatic
        @NotNull
        public final Category create(@Nullable Category parent, @NotNull String name, int priority) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new Category(parent, name, priority);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

