/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.ExternalReferenceExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

public class UastLintUtils {
    public static String getQualifiedName(PsiElement element) {
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String containingClassFqName = UastLintUtils.getQualifiedName((PsiElement)containingClass);
            if (containingClassFqName == null) {
                return null;
            }
            return containingClassFqName + "." + ((PsiMethod)element).getName();
        }
        if (element instanceof PsiField) {
            PsiClass containingClass = ((PsiField)element).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String containingClassFqName = UastLintUtils.getQualifiedName((PsiElement)containingClass);
            if (containingClassFqName == null) {
                return null;
            }
            return containingClassFqName + "." + ((PsiField)element).getName();
        }
        return null;
    }

    public static PsiElement resolve(ExternalReferenceExpression expression, UElement context) {
        UDeclaration declaration = (UDeclaration)UastUtils.getParentOfType((UElement)context, UDeclaration.class);
        if (declaration == null) {
            return null;
        }
        return expression.resolve((PsiElement)declaration.getPsi());
    }

    public static String getClassName(PsiClassType type) {
        PsiClass psiClass = type.resolve();
        if (psiClass == null) {
            return type.getClassName();
        }
        return UastLintUtils.getClassName(psiClass);
    }

    public static String getClassName(PsiClass psiClass) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(psiClass.getName());
        for (psiClass = psiClass.getContainingClass(); psiClass != null; psiClass = psiClass.getContainingClass()) {
            stringBuilder.insert(0, psiClass.getName() + ".");
        }
        return stringBuilder.toString();
    }

    public static UExpression findLastAssignment(PsiVariable variable, UElement call) {
        UExpression lastAssignment = null;
        if (variable instanceof UVariable) {
            variable = ((UVariable)variable).getPsi();
        }
        if (!variable.hasModifierProperty("final") && (variable instanceof PsiLocalVariable || variable instanceof PsiParameter)) {
            UMethod containingFunction = UastUtils.getContainingUMethod((UElement)call);
            if (containingFunction != null) {
                UastContext context = UastUtils.getUastContext((UElement)call);
                ConstantEvaluator.LastAssignmentFinder finder = new ConstantEvaluator.LastAssignmentFinder(variable, call, context, null, -1);
                containingFunction.accept((UastVisitor)finder);
                lastAssignment = finder.getLastAssignment();
            }
        } else {
            UastContext context = UastUtils.getUastContext((UElement)call);
            lastAssignment = context.getInitializerBody(variable);
        }
        if (lastAssignment instanceof UExpression) {
            return lastAssignment;
        }
        return null;
    }

    public static String getReferenceName(UReferenceExpression expression) {
        UExpression selector;
        if (expression instanceof USimpleNameReferenceExpression) {
            return ((USimpleNameReferenceExpression)expression).getIdentifier();
        }
        if (expression instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)expression).getSelector()) instanceof USimpleNameReferenceExpression) {
            return ((USimpleNameReferenceExpression)selector).getIdentifier();
        }
        return null;
    }

    public static Object findLastValue(PsiVariable variable, UElement call, UastContext context, ConstantEvaluator evaluator) {
        Object value = null;
        if (!variable.hasModifierProperty("final") && (variable instanceof PsiLocalVariable || variable instanceof PsiParameter)) {
            UMethod containingFunction = UastUtils.getContainingUMethod((UElement)call);
            if (containingFunction != null) {
                ConstantEvaluator.LastAssignmentFinder finder = new ConstantEvaluator.LastAssignmentFinder(variable, call, context, evaluator, 1);
                containingFunction.getUastBody().accept((UastVisitor)finder);
                value = finder.getCurrentValue();
            }
        } else {
            UExpression initializer = context.getInitializerBody(variable);
            if (initializer != null) {
                value = initializer.evaluate();
            }
        }
        return value;
    }

    public static ResourceReference toAndroidReferenceViaResolve(UElement element) {
        return ResourceReference.get(element);
    }

    public static boolean areIdentifiersEqual(UExpression first, UExpression second) {
        String firstIdentifier = UastLintUtils.getIdentifier(first);
        String secondIdentifier = UastLintUtils.getIdentifier(second);
        return firstIdentifier != null && secondIdentifier != null && firstIdentifier.equals(secondIdentifier);
    }

    public static String getIdentifier(UExpression expression) {
        if (expression instanceof ULiteralExpression) {
            expression.asRenderString();
        } else {
            if (expression instanceof USimpleNameReferenceExpression) {
                return ((USimpleNameReferenceExpression)expression).getIdentifier();
            }
            if (expression instanceof UQualifiedReferenceExpression) {
                UQualifiedReferenceExpression qualified = (UQualifiedReferenceExpression)expression;
                String receiverIdentifier = UastLintUtils.getIdentifier(qualified.getReceiver());
                String selectorIdentifier = UastLintUtils.getIdentifier(qualified.getSelector());
                if (receiverIdentifier == null || selectorIdentifier == null) {
                    return null;
                }
                return receiverIdentifier + "." + selectorIdentifier;
            }
        }
        return null;
    }
}

