/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support.utils;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.constants.ThymeleafNamespaceConstants;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.ThymeleafDialects;
import com.intellij.thymeleaf.lang.ThymeleafExpressionsFileType;
import com.intellij.thymeleaf.lang.injectors.ThymeleafExpressionsInjector;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafRenameableImplicitVariable;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.thymeleaf.references.ThymeleafFakeRenameableReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafCommonUtil {
    public static boolean hasThymeleafLibrary(Project project) {
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            DumbService dumbService = DumbService.getInstance((Project)project);
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{dumbService.getModificationTracker()});
            }
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)project).findClass("org.thymeleaf.dialect.IDialect", ProjectScope.getLibrariesScope((Project)project)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    @NotNull
    private static String[] getThymeleafNamespaces(@NotNull Project project) {
        if (project == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(0);
        }
        HashSet uris = ContainerUtil.newHashSet();
        for (ThymeleafDialect dialect : ThymeleafDialects.getDialects(project)) {
            ContainerUtil.addAll((Collection)uris, (Object[])dialect.getNamespaces());
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)uris);
        if (stringArray == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @Nullable
    public static ThymesElExpression findObjectExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(2);
        }
        return ThymeleafCommonUtil.findParentTagExpression(expression, "object");
    }

    @NotNull
    public static Collection<ThymesElExpression> findEachExpressions(@NotNull PsiElement expression) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(3);
        }
        Collection<ThymesElExpression> collection = ThymeleafCommonUtil.findAllParentTagExpressions(expression, "each");
        if (collection == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Nullable
    public static ThymesElExpression findFragmentExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(5);
        }
        return ThymeleafCommonUtil.findParentTagExpression(expression, "fragment");
    }

    @NotNull
    public static Collection<ThymesElExpression> findWithExpressions(@NotNull PsiElement expression) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(6);
        }
        Collection<ThymesElExpression> collection = ThymeleafCommonUtil.findAllParentTagExpressions(expression, "with");
        if (collection == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Nullable
    private static ThymesElExpression findParentTagExpression(@NotNull PsiElement expression, @NotNull String attrName) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(8);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(9);
        }
        CommonProcessors.FindFirstProcessor findFirst = new CommonProcessors.FindFirstProcessor();
        ThymeleafCommonUtil.processParentTagExpressions(expression, attrName, (Processor<ThymesElExpression>)findFirst);
        return (ThymesElExpression)findFirst.getFoundValue();
    }

    @NotNull
    private static Collection<ThymesElExpression> findAllParentTagExpressions(@NotNull PsiElement expression, @NotNull String attrName) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(10);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(11);
        }
        CommonProcessors.CollectProcessor findFirst = new CommonProcessors.CollectProcessor();
        ThymeleafCommonUtil.processParentTagExpressions(expression, attrName, (Processor<ThymesElExpression>)findFirst);
        Collection collection = findFirst.getResults();
        if (collection == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private static boolean processParentTagExpressions(@NotNull PsiElement expression, @NotNull String attrName, @NotNull Processor<ThymesElExpression> processor) {
        XmlTag xmlTag;
        XmlAttribute contextAttribute;
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(13);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(15);
        }
        if ((contextAttribute = ThymeleafCommonUtil.getContextAttribute(expression)) != null && (xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)contextAttribute, XmlTag.class)) != null) {
            XmlTag parentTag;
            XmlTag xmlTag2 = parentTag = attrName.equals(ThymeleafCommonUtil.getLocalName(contextAttribute)) ? xmlTag.getParentTag() : xmlTag;
            while (parentTag != null) {
                ThymesElExpression thymesElExpression;
                XmlAttribute attribute = ThymeleafCommonUtil.getAttribute(attrName, parentTag);
                if (attribute != null && (thymesElExpression = ThymeleafCommonUtil.getAttributeExpression(attribute)) != null && !processor.process((Object)thymesElExpression)) {
                    return false;
                }
                parentTag = parentTag.getParentTag();
            }
        }
        return true;
    }

    @Nullable
    public static XmlAttribute getContextAttribute(@NotNull PsiElement expression) {
        PsiElement context;
        PsiFile containingFile;
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(16);
        }
        if ((containingFile = expression.getContainingFile()) != null && (context = containingFile.getContext()) != null) {
            return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
        }
        return null;
    }

    private static String getLocalName(@NotNull XmlAttribute contextAttribute) {
        String attrNameHtml5;
        if (contextAttribute == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(17);
        }
        return (attrNameHtml5 = ThymeleafExpressionsInjector.getThymeleafAttrNameHtml5(contextAttribute)) != null ? attrNameHtml5 : contextAttribute.getLocalName();
    }

    @Nullable
    private static XmlAttribute getAttribute(@NotNull String attrName, @NotNull XmlTag xmlTag) {
        XmlAttribute attribute;
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(18);
        }
        if (xmlTag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(19);
        }
        if ((attribute = ThymeleafCommonUtil.findThymeleafAttribute(xmlTag, attrName)) != null) {
            return attribute;
        }
        String prefixByNamespace = ThymeleafCommonUtil.getPrefixByThymeleafNamespace(xmlTag);
        if (prefixByNamespace != null) {
            return xmlTag.getAttribute("data-" + prefixByNamespace + "-" + attrName);
        }
        return null;
    }

    @Nullable
    public static ThymesElExpression getAttributeExpression(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(20);
        }
        Ref ref = Ref.create();
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)attribute.getProject());
        XmlAttributeValue valueElement = attribute.getValueElement();
        if (valueElement != null) {
            manager.enumerate((PsiElement)valueElement, (injectedPsi, places) -> {
                if (injectedPsi.getFileType() instanceof ThymeleafExpressionsFileType) {
                    PsiElement[] children;
                    for (PsiElement child : children = injectedPsi.getChildren()) {
                        if (!(child instanceof ThymesElExpression)) continue;
                        ref.set((Object)((ThymesElExpression)child));
                        break;
                    }
                }
            });
        }
        return (ThymesElExpression)ref.get();
    }

    public static Map<String, ThymeleafVariable> getInitVariables(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(21);
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)psiMethod, () -> {
            if (psiMethod == null) {
                ThymeleafCommonUtil.$$$reportNull$$$0(30);
            }
            ConcurrentMap set = ContainerUtil.newConcurrentMap();
            MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)GlobalSearchScope.allScope((Project)psiMethod.getProject()), (boolean)true).forEach(psiReference -> {
                Pair evaluatedExpression;
                PsiExpression[] expressions;
                PsiMethodCallExpression methodCallExpression;
                if (set == null) {
                    ThymeleafCommonUtil.$$$reportNull$$$0(31);
                }
                if ((methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class)) != null && (expressions = methodCallExpression.getArgumentList().getExpressions()).length == 2 && (evaluatedExpression = StringExpressionHelper.evaluateExpression((PsiElement)expressions[0])) != null) {
                    PsiElement psiExpression = (PsiElement)evaluatedExpression.getFirst();
                    String name = (String)evaluatedExpression.getSecond();
                    PsiType type = expressions[1].getType();
                    if (name != null && type != null) {
                        if (psiExpression instanceof PsiLiteral) {
                            RenameableFakePsiElement renamebaleElement = ThymeleafFakeRenameableReferenceProvider.getOrCreateRenamebaleFakeElement((PsiLiteral)psiExpression);
                            set.put(name, new ThymeleafRenameableImplicitVariable(name, type, renamebaleElement));
                        } else {
                            set.put(name, new ThymeleafVariable(name, type, psiExpression));
                        }
                    }
                }
                return true;
            });
            return CachedValueProvider.Result.create((Object)set, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    @Nullable
    public static String getPrefixByThymeleafNamespace(@NotNull XmlTag tag) {
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(22);
        }
        for (String uri : ThymeleafCommonUtil.getThymeleafNamespaces(tag.getProject())) {
            String prefixByNamespace = tag.getPrefixByNamespace(uri);
            if (prefixByNamespace == null) continue;
            return prefixByNamespace;
        }
        return null;
    }

    @Nullable
    public static String getPrefixByThymeleafNamespace(@NotNull XmlTag tag, String ... uris) {
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(23);
        }
        if (uris == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(24);
        }
        for (String uri : uris) {
            String prefixByNamespace = tag.getPrefixByNamespace(uri);
            if (prefixByNamespace == null) continue;
            return prefixByNamespace;
        }
        return null;
    }

    public static boolean isThymeleafPrefix(XmlTag context, String prefixByQualifiedName) {
        return ThymeleafCommonUtil.isThymeleafNamespace(context.getNamespaceByPrefix(prefixByQualifiedName), context.getProject());
    }

    public static boolean isThymeleafNamespace(@NotNull String ns, @Nullable Project project) {
        if (ns == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(25);
        }
        if (project != null && !DumbService.isDumb((Project)project)) {
            for (String uri : ThymeleafCommonUtil.getThymeleafNamespaces(project)) {
                if (!uri.equals(ns)) continue;
                return true;
            }
        }
        return ThymeleafDialects.getImplicitNamespaces().contains(ns);
    }

    @Nullable
    public static XmlAttribute findThymeleafAttribute(@NotNull XmlTag tag, @NotNull String attrName) {
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(26);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(27);
        }
        return ThymeleafCommonUtil.findThymeleafAttribute(tag, attrName, ThymeleafNamespaceConstants.THYMELEAF_URIS);
    }

    @Nullable
    public static XmlAttribute findThymeleafAttribute(@NotNull XmlTag tag, @NotNull String attrName, String ... uris) {
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(28);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(29);
        }
        for (String uri : uris) {
            XmlAttribute attribute = tag.getAttribute(attrName, uri);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextAttribute";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 22: 
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uris";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThymeleafNamespaces";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findEachExpressions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findWithExpressions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllParentTagExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThymeleafNamespaces";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findObjectExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findEachExpressions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFragmentExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findWithExpressions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findParentTagExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAllParentTagExpressions";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processParentTagExpressions";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContextAttribute";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLocalName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInitVariables";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixByThymeleafNamespace";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isThymeleafNamespace";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findThymeleafAttribute";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getInitVariables$3";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

