/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.model.xml.AlternativeClass;
import com.intellij.cdi.model.xml.Alternatives;
import com.intellij.cdi.model.xml.Beans;
import com.intellij.cdi.model.xml.DecoratorClass;
import com.intellij.cdi.model.xml.Decorators;
import com.intellij.cdi.model.xml.InterceptorClass;
import com.intellij.cdi.model.xml.Interceptors;
import com.intellij.cdi.model.xml.StereotypeClass;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiDomBeansInspection
extends BasicDomElementsInspection<Beans> {
    public CdiDomBeansInspection() {
        super(Beans.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<Beans> element, DomElementAnnotationHolder holder) {
        Beans beans = (Beans)element.getRootElement();
        CdiDomBeansInspection.checkAlternatives(element, holder, beans);
        for (Decorators decorators : beans.getDecoratorses()) {
            for (DecoratorClass decoratorClass : decorators.getClasses()) {
                CdiDomBeansInspection.checkAnnotatedClass(decoratorClass, holder, "javax.decorator.Decorator");
            }
        }
        for (Interceptors interceptors : beans.getInterceptorses()) {
            for (InterceptorClass interceptorClass : interceptors.getClasses()) {
                CdiDomBeansInspection.checkAnnotatedClass(interceptorClass, holder, "javax.interceptor.Interceptor");
            }
        }
        super.checkFileElement(element, holder);
    }

    private static void checkAlternatives(DomFileElement<Beans> element, DomElementAnnotationHolder holder, Beans beans) {
        Module module = element.getModule();
        for (Alternatives alternatives : beans.getAlternativeses()) {
            CdiDomBeansInspection.checkAlternativeClasses(holder, module, alternatives);
            CdiDomBeansInspection.checkStereotypes(holder, module, alternatives);
        }
    }

    private static void checkAlternativeClasses(DomElementAnnotationHolder holder, Module module, Alternatives alternatives) {
        MultiMap duplicatedMap = new MultiMap();
        for (AlternativeClass alternativeClass : alternatives.getClasses()) {
            PsiClass aClass = (PsiClass)alternativeClass.getValue();
            if (aClass != null) {
                duplicatedMap.putValue((Object)aClass, (Object)alternativeClass);
                if (module != null && CdiInjectionUtils.isVetoedClass(module, aClass)) {
                    holder.createProblem((DomElement)alternativeClass, CdiInspectionBundle.message("alternative.bean.should.not.be.vetoed", new Object[0]), new LocalQuickFix[0]);
                }
            }
            CdiDomBeansInspection.checkAnnotatedClass(alternativeClass, holder, (Condition<PsiClass>)((Condition)aClass1 -> CdiCommonUtils.isAlternative((PsiMember)aClass1)), "javax.enterprise.inject.Alternative");
        }
        for (Map.Entry entry : duplicatedMap.entrySet()) {
            Collection duplicated = (Collection)entry.getValue();
            if (duplicated.size() <= 1) continue;
            for (AlternativeClass alternative : duplicated) {
                holder.createProblem((DomElement)alternative, CdiInspectionBundle.message("CdiDomBeansInspection.duplicated.alternative.classes", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkStereotypes(@NotNull DomElementAnnotationHolder holder, @Nullable Module module, @NotNull Alternatives alternatives) {
        if (holder == null) {
            CdiDomBeansInspection.$$$reportNull$$$0(0);
        }
        if (alternatives == null) {
            CdiDomBeansInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            return;
        }
        Collection<PsiClass> stereotypeAnnotationClasses = CdiCommonUtils.getAlternativeStereotypeAnnotationClasses(module);
        MultiMap duplicatedStereotypeMap = new MultiMap();
        for (StereotypeClass stereotypeClass : alternatives.getStereotypes()) {
            PsiClass psiClass = (PsiClass)stereotypeClass.getValue();
            if (psiClass != null) {
                duplicatedStereotypeMap.putValue((Object)psiClass, (Object)stereotypeClass);
            }
            if (stereotypeAnnotationClasses.contains(psiClass)) continue;
            holder.createProblem((DomElement)stereotypeClass, CdiInspectionBundle.message("CdiDomBeansInspection.class.must.be", "@Alternative stereotype annotation"), new LocalQuickFix[0]);
        }
        for (Map.Entry entry : duplicatedStereotypeMap.entrySet()) {
            Collection duplicated = (Collection)entry.getValue();
            if (duplicated.size() <= 1) continue;
            for (StereotypeClass stereotypeClass : duplicated) {
                holder.createProblem((DomElement)stereotypeClass, CdiInspectionBundle.message("CdiDomBeansInspection.duplicated.stereotype.classes", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkAnnotatedClass(@NotNull GenericDomValue<PsiClass> aClass, @NotNull DomElementAnnotationHolder holder, @NotNull String annotation) {
        if (aClass == null) {
            CdiDomBeansInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            CdiDomBeansInspection.$$$reportNull$$$0(3);
        }
        if (annotation == null) {
            CdiDomBeansInspection.$$$reportNull$$$0(4);
        }
        CdiDomBeansInspection.checkAnnotatedClass(aClass, holder, (Condition<PsiClass>)((Condition)c -> {
            if (annotation == null) {
                CdiDomBeansInspection.$$$reportNull$$$0(9);
            }
            return AnnotationUtil.isAnnotated((PsiModifierListOwner)c, (String)annotation, (int)1);
        }), annotation);
    }

    private static void checkAnnotatedClass(@NotNull GenericDomValue<PsiClass> aClass, @NotNull DomElementAnnotationHolder holder, @NotNull Condition<PsiClass> annoCondition, final @NotNull String annotation) {
        PsiClass psiClass;
        if (aClass == null) {
            CdiDomBeansInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            CdiDomBeansInspection.$$$reportNull$$$0(6);
        }
        if (annoCondition == null) {
            CdiDomBeansInspection.$$$reportNull$$$0(7);
        }
        if (annotation == null) {
            CdiDomBeansInspection.$$$reportNull$$$0(8);
        }
        if ((psiClass = (PsiClass)aClass.getValue()) != null && !annoCondition.value((Object)psiClass)) {
            holder.createProblem(aClass, CdiInspectionBundle.message("CdiDomBeansInspection.class.must.be", StringUtil.getShortName((String)annotation)), new LocalQuickFix[]{new LocalQuickFix(){

                @NotNull
                public String getName() {
                    String string = CdiInspectionBundle.message("CdiDomBeansInspection.add.annotation", StringUtil.getShortName((String)annotation));
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    if ("CDI Quick Fixes" == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return "CDI Quick Fixes";
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    PsiModifierList list;
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (descriptor == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if ((list = psiClass.getModifierList()) != null) {
                        list.addAnnotation(annotation);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 2: 
                        case 3: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/cdi/highlighting/CdiDomBeansInspection$1";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/cdi/highlighting/CdiDomBeansInspection$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "applyFix";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alternatives";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoCondition";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/highlighting/CdiDomBeansInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStereotypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAnnotatedClass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$checkAnnotatedClass$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

