/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiUnproxyableBeanTypesInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        boolean isPassivatingScopedClass;
        if (module == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(0);
        }
        if (isPassivatingScopedClass = CdiManagedBeanValidationUtils.isPassivisingScopeDeclared((PsiModifierListOwner)aClass)) {
            CdiUnproxyableBeanTypesInspection.checkPassivatingScopedBeanIsSerializable((PsiElement)aClass.getNameIdentifier(), aClass, holder);
        }
        Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints(aClass);
        for (InjectionPointDescriptor injectionPoint : injectionPoints) {
            PsiFile ipContainingFile = injectionPoint.getOwner().getContainingFile();
            if (ipContainingFile == null || !ipContainingFile.equals(aClass.getContainingFile())) continue;
            CdiUnproxyableBeanTypesInspection.checkInjectionPoint(injectionPoint, holder, module, isPassivatingScopedClass);
        }
        CdiUnproxyableBeanTypesInspection.checkPassivatingScopeProducers(aClass, holder);
    }

    private static void checkPassivatingScopeProducers(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder) {
        if (aClass == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(2);
        }
        for (PsiMethod psiMethod : CdiCommonUtils.getProducerMethods(aClass)) {
            PsiType returnType;
            if (!aClass.equals(psiMethod.getContainingClass()) || !CdiManagedBeanValidationUtils.isPassivisingScopeDeclared((PsiModifierListOwner)psiMethod) || !((returnType = psiMethod.getReturnType()) instanceof PsiClassType)) continue;
            CdiUnproxyableBeanTypesInspection.checkPassivatingScopedBeanIsSerializable((PsiElement)psiMethod.getNameIdentifier(), ((PsiClassType)returnType).resolve(), holder);
        }
        for (PsiField psiField : CdiCommonUtils.getProducerFields(aClass)) {
            PsiType type;
            if (!aClass.equals(psiField.getContainingClass()) || !CdiManagedBeanValidationUtils.isPassivisingScopeDeclared((PsiModifierListOwner)psiField) || !((type = psiField.getType()) instanceof PsiClassType)) continue;
            CdiUnproxyableBeanTypesInspection.checkPassivatingScopedBeanIsSerializable((PsiElement)psiField.getNameIdentifier(), ((PsiClassType)type).resolve(), holder);
        }
    }

    private static void checkPassivatingScopedBeanIsSerializable(@Nullable PsiElement psiElement, @Nullable PsiClass aClass, ProblemsHolder holder) {
        if (psiElement == null || aClass == null) {
            return;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.io.Serializable")) {
            holder.registerProblem(psiElement, CdiInspectionBundle.message("CdiUnproxyableBeanTypesInspection.passivating.scoped.bean.must.be.serialisable", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkInjectionPoint(@NotNull InjectionPointDescriptor injectionPoint, ProblemsHolder holder, Module module, boolean isPassivatingScopedClass) {
        Set<CdiBeanDescriptor> injectedBeans;
        if (injectionPoint == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(3);
        }
        if ((injectedBeans = CdiInjectionUtils.getInjectedBeans(injectionPoint)).size() == 1) {
            PsiClass injectedClass;
            CdiBeanDescriptor descriptor = injectedBeans.iterator().next();
            PsiType type = descriptor.getType();
            if (type == null) {
                return;
            }
            CdiUnproxyableBeanTypesInspection.checkProxyable(injectionPoint, holder, module, descriptor, type);
            if (isPassivatingScopedClass && type instanceof PsiClassType && (injectedClass = ((PsiClassType)type).resolve()) != null && !CdiUnproxyableBeanTypesInspection.isApplicationScoped(injectedClass) && !CdiUnproxyableBeanTypesInspection.isRequestScoped(injectedClass) && !InheritanceUtil.isInheritor((PsiClass)injectedClass, (String)"java.io.Serializable")) {
                holder.registerProblem((PsiElement)injectionPoint.getOwner(), CdiInspectionBundle.message("CdiUnproxyableBeanTypesInspection.injected.in.passivating.scoped.bean.must.be.serialisable", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static boolean isRequestScoped(PsiClass injectedClass) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)injectedClass, (String)"javax.enterprise.context.RequestScoped", (int)1);
    }

    private static boolean isApplicationScoped(PsiClass injectedClass) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)injectedClass, (String)"javax.enterprise.context.ApplicationScoped", (int)1);
    }

    private static void checkProxyable(InjectionPointDescriptor injectionPoint, ProblemsHolder holder, Module module, CdiBeanDescriptor descriptor, PsiType type) {
        PsiClass scopeType = descriptor.getScopeType();
        if (scopeType == null) {
            return;
        }
        Collection<PsiClass> normalScopeAnnotations = CdiCommonUtils.getNormalScopeTypesClasses(module);
        if (normalScopeAnnotations.contains(scopeType) && !CdiCommonUtils.isProxyable(type)) {
            holder.registerProblem((PsiElement)injectionPoint.getOwner(), CdiInspectionBundle.message("CdiUnproxyableBeanTypesInspection.unproxyable.type.detected", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.unproxyable.bean.types.inconsistency.errors", new Object[0]);
        if (string == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiUnproxyableBeanTypesInspection" == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(5);
        }
        return "CdiUnproxyableBeanTypesInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(6);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPoint";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiUnproxyableBeanTypesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiUnproxyableBeanTypesInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkPassivatingScopeProducers";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkInjectionPoint";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

