/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.manager;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiExtensionBeanDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.specialization.CdiSpecializes;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiManager {
    public static final List<String> BUILD_IN_CLASSES = Arrays.asList("javax.enterprise.inject.spi.BeanManager", "javax.enterprise.context.control.RequestContextController", "javax.enterprise.inject.spi.InterceptionFactory", "javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpSession", "javax.jms.JMSContext", "javax.batch.runtime.context.JobContext", "javax.batch.runtime.context.StepContext", "java.security.Principal", "javax.servlet.ServletContext", "javax.transaction.UserTransaction", "javax.validation.ValidationFactory", "javax.validation.Validator", "javax.faces.flow.builder.FlowBuilder", "javax.persistence.EntityManager", "javax.faces.context.FacesContext");
    private static final Set<String> IGNORED_BINDING_ANNOTATIONS = new HashSet<String>();
    private final Module myModule;

    public CdiManager(@NotNull Module module) {
        if (module == null) {
            CdiManager.$$$reportNull$$$0(0);
        }
        this.myModule = module;
    }

    public static CdiManager getService(@NotNull Module module) {
        if (module == null) {
            CdiManager.$$$reportNull$$$0(1);
        }
        return (CdiManager)ModuleServiceManager.getService((Module)module, CdiManager.class);
    }

    @NotNull
    public Set<CdiBeanDescriptor> resolveBeanByType(@NotNull PsiModifierListOwner psiMember, @NotNull Module module, PsiType type) {
        if (psiMember == null) {
            CdiManager.$$$reportNull$$$0(2);
        }
        if (module == null) {
            CdiManager.$$$reportNull$$$0(3);
        }
        PsiAnnotation[] bindingTypes = CdiCommonUtils.getQualifierAnnotations(psiMember);
        if (type instanceof PsiArrayType) {
            Set<CdiBeanDescriptor> set = this.resolveProducesBeans(type, CdiCommonUtils.getQualifierClasses(this.getModule()), bindingTypes);
            if (set == null) {
                CdiManager.$$$reportNull$$$0(4);
            }
            return set;
        }
        PsiClass originalPsiClass = CdiCommonUtils.getOriginalPsiClass(type, module);
        if (originalPsiClass != null) {
            PsiClass containingClass;
            Set<CdiBeanDescriptor> descriptors = this.resolveBeanByClass(originalPsiClass, bindingTypes);
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"javax.decorator.Delegate", (int)1) && (containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiMember, PsiClass.class, (boolean)false)) != null) {
                Set<CdiBeanDescriptor> set = CdiManager.filterDecoratorDescriptors(descriptors, containingClass);
                if (set == null) {
                    CdiManager.$$$reportNull$$$0(5);
                }
                return set;
            }
            Set<CdiBeanDescriptor> set = descriptors;
            if (set == null) {
                CdiManager.$$$reportNull$$$0(6);
            }
            return set;
        }
        Set<CdiBeanDescriptor> set = Collections.emptySet();
        if (set == null) {
            CdiManager.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static Set<CdiBeanDescriptor> filterDecoratorDescriptors(@NotNull Set<CdiBeanDescriptor> descriptors, @NotNull PsiClass aClass) {
        if (descriptors == null) {
            CdiManager.$$$reportNull$$$0(8);
        }
        if (aClass == null) {
            CdiManager.$$$reportNull$$$0(9);
        }
        com.intellij.util.containers.hash.HashSet nonDecorators = new com.intellij.util.containers.hash.HashSet();
        for (CdiBeanDescriptor descriptor : descriptors) {
            if (aClass.equals(descriptor.getIdentifyingElement())) continue;
            nonDecorators.add(descriptor);
        }
        return nonDecorators;
    }

    @NotNull
    public Set<CdiBeanDescriptor> resolveBeanByClass(@Nullable PsiClass psiClass, PsiAnnotation ... bindings) {
        if (psiClass == null) {
            Set<CdiBeanDescriptor> set = Collections.emptySet();
            if (set == null) {
                CdiManager.$$$reportNull$$$0(10);
            }
            return set;
        }
        com.intellij.util.containers.HashSet descriptors = new com.intellij.util.containers.HashSet();
        Collection<PsiClass> allBindingTypesClasses = CdiCommonUtils.getQualifierClasses(this.getModule());
        Set<? extends CdiBeanDescriptor> cdiBeanDescriptors = this.resolvePsiClassBeans(psiClass, allBindingTypesClasses, bindings);
        for (CdiBeanDescriptor cdiBeanDescriptor : cdiBeanDescriptors) {
            CdiBeanDescriptor specializes = this.getSpecializes(cdiBeanDescriptor);
            descriptors.add(specializes == null ? cdiBeanDescriptor : specializes);
        }
        descriptors.addAll(this.resolveProducesBeans((PsiType)JavaPsiFacade.getElementFactory((Project)this.getModule().getProject()).createType(psiClass), allBindingTypesClasses, bindings));
        descriptors.addAll(CdiManager.resolveExtensionBeanDescriptors(psiClass));
        Set<CdiBeanDescriptor> set = CdiManager.filterTypedCandidates(psiClass, (Set<CdiBeanDescriptor>)descriptors);
        if (set == null) {
            CdiManager.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    private static Set<CdiExtensionBeanDescriptor> resolveExtensionBeanDescriptors(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiManager.$$$reportNull$$$0(12);
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
        Set<CdiExtensionBeanDescriptor> set = CdiCommonUtils.collectExtensionBeanDescriptors(psiClass.getProject()).stream().filter(descriptor -> {
            for (PsiType psiType : descriptor.getSupportedTypes()) {
                if (!psiClassType.isAssignableFrom(psiType)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        if (set == null) {
            CdiManager.$$$reportNull$$$0(13);
        }
        return set;
    }

    @Nullable
    public CdiBeanDescriptor getSpecializes(@NotNull CdiBeanDescriptor candidate) {
        if (candidate == null) {
            CdiManager.$$$reportNull$$$0(14);
        }
        if (candidate instanceof ManagedBeanDescriptor) {
            PsiClass candidateClass = (PsiClass)((ManagedBeanDescriptor)candidate).getIdentifyingElement();
            for (CdiSpecializes specializes : CdiJamModel.getModel(this.getModule()).getSpecializeses()) {
                PsiClass specializedClass;
                if (!(specializes instanceof CdiSpecializes.ClassMapping) || !candidateClass.equals(specializedClass = ((CdiSpecializes.ClassMapping)specializes).getSpecializedMember())) continue;
                return CdiDescriptorsFactory.createCdiBeanDescriptor((PsiClass)((CdiSpecializes.ClassMapping)specializes).getPsiElement());
            }
        }
        return null;
    }

    private static Set<CdiBeanDescriptor> filterTypedCandidates(@NotNull PsiClass psiClass, @NotNull Set<CdiBeanDescriptor> descriptors) {
        if (psiClass == null) {
            CdiManager.$$$reportNull$$$0(15);
        }
        if (descriptors == null) {
            CdiManager.$$$reportNull$$$0(16);
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return descriptors;
        }
        HashSet<CdiBeanDescriptor> filtered = new HashSet<CdiBeanDescriptor>();
        block0: for (CdiBeanDescriptor descriptor : descriptors) {
            PsiAnnotation annotation = CdiManager.getAnnotation(descriptor, "javax.enterprise.inject.Typed");
            if (annotation != null) {
                List values = AnnotationModelUtil.getPsiClassArrayValue((PsiAnnotation)annotation, (String)"value");
                if (values.isEmpty()) continue;
                for (AnnotationGenericValue genericValue : values) {
                    PsiClass typedClass = (PsiClass)genericValue.getValue();
                    if (typedClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)typedClass, (PsiClass)psiClass, (boolean)true)) continue;
                    filtered.add(descriptor);
                    continue block0;
                }
                continue;
            }
            filtered.add(descriptor);
        }
        return filtered;
    }

    @Nullable
    private static PsiAnnotation getAnnotation(@NotNull CdiBeanDescriptor descriptor, String anno) {
        Object identifyingElement;
        if (descriptor == null) {
            CdiManager.$$$reportNull$$$0(17);
        }
        return (identifyingElement = descriptor.getIdentifyingElement()) instanceof PsiMember ? AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiModifierListOwner)identifyingElement), (String[])new String[]{anno}) : null;
    }

    private Set<CdiBeanDescriptor> resolveProducesBeans(@NotNull PsiType psiType, Collection<PsiClass> allBindingTypesClasses, PsiAnnotation[] bindings) {
        if (psiType == null) {
            CdiManager.$$$reportNull$$$0(18);
        }
        com.intellij.util.containers.HashSet candidates = new com.intellij.util.containers.HashSet();
        Processor processor = arg_0 -> this.lambda$resolveProducesBeans$1(psiType, bindings, (Set)candidates, arg_0);
        PsiClass producesAnnoClass = JavaPsiFacade.getInstance((Project)this.getModule().getProject()).findClass("javax.enterprise.inject.Produces", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.getModule()));
        if (producesAnnoClass != null) {
            Query query = AnnotatedMembersSearch.search((PsiClass)producesAnnoClass, (SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.getModule()));
            query.forEach(processor);
        }
        return new com.intellij.util.containers.HashSet((Collection)ContainerUtil.mapNotNull((Collection)candidates, member -> CdiDescriptorsFactory.createProducerCdiBeanDescriptor(member)));
    }

    private boolean isAssignable(PsiType productType, PsiType psiType) {
        if (productType instanceof PsiArrayType) {
            return psiType.isAssignableFrom(productType);
        }
        PsiClass originalProductClass = CdiCommonUtils.getOriginalPsiClass(productType, this.getModule());
        if (originalProductClass != null) {
            PsiClassType originalProductType = JavaPsiFacade.getElementFactory((Project)this.getModule().getProject()).createType(originalProductClass);
            return psiType.isAssignableFrom((PsiType)originalProductType);
        }
        return false;
    }

    @Nullable
    private static PsiType getProductType(@Nullable PsiMember candidate) {
        if (candidate instanceof PsiField) {
            return ((PsiField)candidate).getType();
        }
        if (candidate instanceof PsiMethod) {
            return ((PsiMethod)candidate).getReturnType();
        }
        return null;
    }

    private Set<? extends CdiBeanDescriptor> resolvePsiClassBeans(@NotNull PsiClass psiClass, Collection<PsiClass> allBindingTypesClasses, PsiAnnotation[] bindings) {
        String qualifiedName;
        if (psiClass == null) {
            CdiManager.$$$reportNull$$$0(19);
        }
        if ("java.lang.Object".equals(qualifiedName = psiClass.getQualifiedName())) {
            return this.resolveJavaLangObjectBeans(psiClass, allBindingTypesClasses, bindings);
        }
        if (bindings.length == 0 && BUILD_IN_CLASSES.contains(qualifiedName) || "javax.enterprise.inject.spi.InjectionPoint".equals(qualifiedName)) {
            return Collections.singleton(CdiDescriptorsFactory.createCdiBeanDescriptor(psiClass));
        }
        com.intellij.util.containers.HashSet candidates = new com.intellij.util.containers.HashSet();
        Processor processor = arg_0 -> CdiManager.lambda$resolvePsiClassBeans$3(bindings, (Set)candidates, arg_0);
        processor.process((Object)psiClass);
        Query classQuery = ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.getModule()), (boolean)true);
        classQuery.forEach(processor);
        if (bindings.length == 0 && CdiManager.isAppropriateCandidate(psiClass)) {
            candidates.add(psiClass);
        }
        return new com.intellij.util.containers.HashSet((Collection)ContainerUtil.mapNotNull((Collection)candidates, psiClass1 -> CdiDescriptorsFactory.createCdiBeanDescriptor(psiClass1)));
    }

    private Set<? extends CdiBeanDescriptor> resolveJavaLangObjectBeans(@NotNull PsiClass psiClass, Collection<PsiClass> allBindingTypesClasses, PsiAnnotation[] bindings) {
        if (psiClass == null) {
            CdiManager.$$$reportNull$$$0(20);
        }
        if (bindings.length == 0) {
            return Collections.singleton(CdiDescriptorsFactory.createCdiBeanDescriptor(psiClass));
        }
        com.intellij.util.containers.HashSet candidates = new com.intellij.util.containers.HashSet();
        Processor processor = arg_0 -> CdiManager.lambda$resolveJavaLangObjectBeans$5(psiClass, bindings, (Set)candidates, arg_0);
        PsiClass annotationClass = this.getAnnotationClass(bindings);
        if (annotationClass != null) {
            Query query = AnnotatedElementsSearch.searchPsiClasses((PsiClass)annotationClass, (SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.getModule()));
            query.forEach(processor);
        }
        return new com.intellij.util.containers.HashSet((Collection)ContainerUtil.mapNotNull((Collection)candidates, psiClass1 -> CdiDescriptorsFactory.createCdiBeanDescriptor(psiClass1)));
    }

    @Nullable
    private PsiClass getAnnotationClass(PsiAnnotation[] bindings) {
        for (PsiAnnotation binding : bindings) {
            String qualifiedName = binding.getQualifiedName();
            PsiClass aClass = JavaPsiFacade.getInstance((Project)this.getModule().getProject()).findClass(qualifiedName, GlobalSearchScope.allScope((Project)this.getModule().getProject()));
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    private static boolean isAppropriateCandidate(PsiClass candidate) {
        return CdiManagedBeanValidationUtils.isConcreteClass(candidate) && CdiManagedBeanValidationUtils.hasAppropriateConstructor(candidate) && !CdiManagedBeanValidationUtils.isNonStaticInner(candidate);
    }

    public static boolean hasAnnotated(@Nullable PsiModifierListOwner candidate, PsiAnnotation[] bindings) {
        if (candidate == null) {
            return false;
        }
        if (CdiManager.isDefaultAnnotations(bindings)) {
            return CdiManager.hasImplicitDefaultAnnotation(candidate);
        }
        for (PsiAnnotation bindingAnnotation : bindings) {
            String qualifiedName = bindingAnnotation.getQualifiedName();
            if (qualifiedName == null) {
                return false;
            }
            if (qualifiedName.equals("javax.enterprise.inject.Any")) continue;
            PsiAnnotation candidateAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)candidate, (String[])new String[]{qualifiedName});
            if (candidateAnnotation == null) {
                return false;
            }
            for (Pair<String, PsiAnnotationMemberValue> pair : CdiManager.getNonBindingAttributes(bindingAnnotation)) {
                if (CdiManager.hasAttributeValue(candidateAnnotation, (String)pair.getFirst(), (PsiAnnotationMemberValue)pair.getSecond())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isDefaultAnnotations(PsiAnnotation[] bindings) {
        for (PsiAnnotation binding : bindings) {
            if (IGNORED_BINDING_ANNOTATIONS.contains(binding.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Set<Pair<String, PsiAnnotationMemberValue>> getNonBindingAttributes(PsiAnnotation annotation) {
        PsiElement resolved;
        HashSet<Pair<String, PsiAnnotationMemberValue>> pairs = new HashSet<Pair<String, PsiAnnotationMemberValue>>();
        PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
        if (referenceElement != null && (resolved = referenceElement.resolve()) != null) {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = ((PsiClass)resolved).getMethods()) {
                if (!PsiUtil.isAnnotationMethod((PsiElement)psiMethod) || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"javax.enterprise.inject.NonBinding", (int)0) || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"javax.enterprise.util.Nonbinding", (int)0)) continue;
                String attributeName = psiMethod.getName();
                pairs.add((Pair<String, PsiAnnotationMemberValue>)Pair.create((Object)attributeName, (Object)annotation.findAttributeValue(attributeName)));
            }
        }
        HashSet<Pair<String, PsiAnnotationMemberValue>> hashSet = pairs;
        if (hashSet == null) {
            CdiManager.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    private static boolean hasAttributeValue(@NotNull PsiAnnotation candidateAnnotation, @Nullable String name, @Nullable PsiAnnotationMemberValue value) {
        if (candidateAnnotation == null) {
            CdiManager.$$$reportNull$$$0(22);
        }
        PsiAnnotationMemberValue candidateValue = candidateAnnotation.findAttributeValue(name);
        if (value instanceof PsiReference) {
            if (candidateValue instanceof PsiReference) {
                PsiElement element1 = ((PsiReference)value).resolve();
                PsiElement element2 = ((PsiReference)candidateValue).resolve();
                return element1 != null && element2 != null && element1.equals(element2);
            }
        } else {
            Object attrValue = JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)value, Object.class);
            Object candidateAttrValue = JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)candidateValue, Object.class);
            return attrValue != null && candidateAttrValue != null && attrValue.equals(candidateAttrValue);
        }
        return false;
    }

    private static boolean hasImplicitDefaultAnnotation(PsiModifierListOwner candidate) {
        PsiAnnotation[] qualifierAnnotations;
        for (PsiAnnotation binding : qualifierAnnotations = CdiCommonUtils.getQualifierAnnotations(candidate)) {
            String qualifiedName = binding.getQualifiedName();
            if (IGNORED_BINDING_ANNOTATIONS.contains(qualifiedName) || "javax.inject.Named".equals(qualifiedName)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Set<CdiBeanDescriptor> resolveBeanByName(String beanName) {
        return null;
    }

    public Module getModule() {
        return this.myModule;
    }

    private static /* synthetic */ boolean lambda$resolveJavaLangObjectBeans$5(@NotNull PsiClass psiClass, PsiAnnotation[] bindings, Set candidates, PsiClass candidate) {
        if (psiClass == null) {
            CdiManager.$$$reportNull$$$0(23);
        }
        if (CdiManager.isAppropriateCandidate(candidate) && InheritanceUtil.isInheritorOrSelf((PsiClass)candidate, (PsiClass)psiClass, (boolean)true) && CdiManager.hasAnnotated((PsiModifierListOwner)candidate, bindings)) {
            candidates.add(candidate);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$resolvePsiClassBeans$3(PsiAnnotation[] bindings, Set candidates, PsiClass candidate) {
        if (CdiManager.isAppropriateCandidate(candidate) && CdiManager.hasAnnotated((PsiModifierListOwner)candidate, bindings)) {
            candidates.add(candidate);
        }
        return true;
    }

    private /* synthetic */ boolean lambda$resolveProducesBeans$1(@NotNull PsiType psiType, PsiAnnotation[] bindings, Set candidates, PsiMember candidate) {
        PsiType productType;
        if (psiType == null) {
            CdiManager.$$$reportNull$$$0(24);
        }
        if ((productType = CdiManager.getProductType(candidate)) != null && this.isAssignable(productType, psiType) && CdiManager.hasAnnotated((PsiModifierListOwner)candidate, bindings)) {
            candidates.add(candidate);
        }
        return true;
    }

    static {
        IGNORED_BINDING_ANNOTATIONS.add("javax.enterprise.inject.Default");
        IGNORED_BINDING_ANNOTATIONS.add("javax.enterprise.inject.Any");
        IGNORED_BINDING_ANNOTATIONS.add("javax.enterprise.inject.New");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/manager/CdiManager";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/manager/CdiManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBeanByType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBeanByClass";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveExtensionBeanDescriptors";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonBindingAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveBeanByType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 21: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterDecoratorDescriptors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveExtensionBeanDescriptors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSpecializes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterTypedCandidates";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveProducesBeans";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolvePsiClassBeans";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveJavaLangObjectBeans";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasAttributeValue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveJavaLangObjectBeans$5";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveProducesBeans$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

