/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.utils;

import com.intellij.cdi.beans.CdiExtensionBeanDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.cdi.utils.CdiVersion;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.AnnotatedPackagesSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiCommonUtils {
    private static final Key<CachedValue<Collection<PsiClass>>> MODULE_NORMAL_SCOPE_TYPES_ANNOTATIONS = new Key("MODULE_NORMAL_SCOPE_TYPES_ANNOTATIONS");
    private static final Key<CachedValue<Collection<PsiClass>>> MODULE_SCOPE_TYPES_ANNOTATIONS = new Key("MODULE_SCOPE_TYPES_ANNOTATIONS");
    private static final Key<CachedValue<Collection<PsiClass>>> MODULE_DEPLOYMENT_TYPES_ANNOTATIONS = new Key("MODULE_DEPLOYMENT_TYPES_ANNOTATIONS");
    private static final Key<CachedValue<Collection<PsiClass>>> MODULE_STEREOTYPES_ANNOTATIONS = new Key("MODULE_STEREOTYPES_ANNOTATIONS");
    private static final Key<CachedValue<Collection<PsiPackage>>> VETOED_PACKAGES = new Key("VETOED_PACKAGES");
    private static final Key<CachedValue<Boolean>> MANAGED_BEAN = new Key("SIMPLE_WEB_BEAN");

    private CdiCommonUtils() {
    }

    @NotNull
    public static Collection<PsiClass> getQualifierClasses(PsiModifierListOwner modifierListOwner) {
        Set<PsiClass> set = CdiCommonUtils.getQualifierClasses(modifierListOwner, ModuleUtilCore.findModuleForPsiElement((PsiElement)modifierListOwner));
        if (set == null) {
            CdiCommonUtils.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public static Set<PsiClass> getQualifierClasses(PsiModifierListOwner modifierListOwner, @Nullable Module module) {
        com.intellij.util.containers.HashSet bindingTypes = new com.intellij.util.containers.HashSet();
        for (PsiClass anno : CdiCommonUtils.getQualifierClasses(module)) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)anno.getQualifiedName(), (int)1)) continue;
            bindingTypes.add(anno);
        }
        com.intellij.util.containers.HashSet hashSet = bindingTypes;
        if (hashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public static PsiAnnotation[] getQualifierAnnotations(PsiModifierListOwner psiModifierListOwner) {
        Collection<String> strings = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getQualifierClasses(psiModifierListOwner));
        PsiAnnotation[] psiAnnotationArray = AnnotationUtil.findAnnotations((PsiModifierListOwner)psiModifierListOwner, strings);
        if (psiAnnotationArray == null) {
            CdiCommonUtils.$$$reportNull$$$0(2);
        }
        return psiAnnotationArray;
    }

    @NotNull
    public static Set<PsiClass> getInterceptorBindingTypesClasses(PsiModifierListOwner modifierListOwner, @Nullable Module module) {
        com.intellij.util.containers.HashSet bindingTypes = new com.intellij.util.containers.HashSet();
        for (PsiClass anno : CdiCommonUtils.getInterceptorBindingTypesClasses(module)) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)anno.getQualifiedName(), (int)1)) continue;
            bindingTypes.add(anno);
        }
        com.intellij.util.containers.HashSet hashSet = bindingTypes;
        if (hashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<PsiClass> getQualifierClasses(@Nullable Module module) {
        Collection<Object> collection = module == null ? Collections.emptyList() : MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)"javax.inject.Qualifier", (boolean)false);
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getInterceptorBindingTypesClasses(@Nullable Module module) {
        Collection<Object> collection = module == null ? Collections.emptyList() : MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)"javax.interceptor.InterceptorBinding", (boolean)false);
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getBindingTypesQualifiedNames(Module module) {
        Collection<String> collection = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getQualifierClasses(module));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getNormalScopeTypesClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(7);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, MODULE_NORMAL_SCOPE_TYPES_ANNOTATIONS, (String)"javax.enterprise.context.NormalScope");
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getNormalScopeQualifiedNames(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(9);
        }
        Collection<String> collection = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getNormalScopeTypesClasses(module));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getScopeTypesClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(11);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, MODULE_SCOPE_TYPES_ANNOTATIONS, (String)"javax.inject.Scope");
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getScopeQualifiedNames(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(13);
        }
        Collection<String> collection = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getScopeTypesClasses(module));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getDeploymentTypesClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(15);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, MODULE_DEPLOYMENT_TYPES_ANNOTATIONS, (String)"javax.enterprise.inject.deployment.DeploymentType");
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getStereotypeAnnotationNames(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(17);
        }
        Collection<String> collection = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getStereotypeAnnotationClasses(module));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getStereotypeAnnotationClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(19);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, MODULE_STEREOTYPES_ANNOTATIONS, (String)"javax.enterprise.inject.Stereotype");
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiPackage> getVetoedPackages(@NotNull Module module) {
        CachedValue cachedValue;
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(21);
        }
        if ((cachedValue = (CachedValue)module.getUserData(VETOED_PACKAGES)) == null) {
            cachedValue = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> {
                if (module == null) {
                    CdiCommonUtils.$$$reportNull$$$0(79);
                }
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.enterprise.inject.Vetoed", scope);
                Set packages = psiClass == null ? Collections.emptySet() : AnnotatedPackagesSearch.search((PsiClass)psiClass, (SearchScope)scope).findAll();
                return CachedValueProvider.Result.create(packages, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }, false);
            module.putUserData(VETOED_PACKAGES, (Object)cachedValue);
        }
        Collection collection = (Collection)cachedValue.getValue();
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(22);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getAlternativeStereotypeAnnotationClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(23);
        }
        com.intellij.util.containers.hash.HashSet alternativeStereotypeAnnotations = new com.intellij.util.containers.hash.HashSet();
        for (PsiClass psiClass : MetaAnnotationUtil.getAnnotatedTypes((Module)module, MODULE_STEREOTYPES_ANNOTATIONS, (String)"javax.enterprise.inject.Stereotype")) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.enterprise.inject.Alternative", (int)1)) continue;
            alternativeStereotypeAnnotations.add(psiClass);
        }
        com.intellij.util.containers.hash.HashSet hashSet = alternativeStereotypeAnnotations;
        if (hashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(24);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<PsiClass> getStereotypeAnnotationClasses(Module module, String ... encapsulatedClasses) {
        if (encapsulatedClasses.length == 0) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                CdiCommonUtils.$$$reportNull$$$0(25);
            }
            return list;
        }
        ArrayList<PsiClass> stereotypes = new ArrayList<PsiClass>();
        for (PsiClass stereotypeAnnoPsiClass : CdiCommonUtils.getStereotypeAnnotationClasses(module)) {
            if (!stereotypeAnnoPsiClass.isAnnotationType() || !AnnotationUtil.isAnnotated((PsiModifierListOwner)stereotypeAnnoPsiClass, Arrays.asList(encapsulatedClasses), (int)0)) continue;
            stereotypes.add(stereotypeAnnoPsiClass);
        }
        ArrayList<PsiClass> arrayList = stereotypes;
        if (arrayList == null) {
            CdiCommonUtils.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getQualifiedNames(Iterable<PsiClass> annotations) {
        List list = ContainerUtil.mapNotNull(annotations, psiClass -> psiClass.getQualifiedName());
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(27);
        }
        return list;
    }

    public static boolean isManagedBean(@NotNull PsiClass psiClass) {
        Boolean value;
        CachedValue cachedValue;
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(28);
        }
        if ((cachedValue = (CachedValue)psiClass.getUserData(MANAGED_BEAN)) == null) {
            cachedValue = CachedValuesManager.getManager((Project)psiClass.getProject()).createCachedValue(() -> {
                if (psiClass == null) {
                    CdiCommonUtils.$$$reportNull$$$0(78);
                }
                return new CachedValueProvider.Result((Object)CdiManagedBeanValidationUtils.isManagedBean(psiClass), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }, false);
            psiClass.putUserData(MANAGED_BEAN, (Object)cachedValue);
        }
        return (value = (Boolean)cachedValue.getValue()) != null && value != false;
    }

    public static boolean isCdiInstalled(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.enterprise.inject.Instance", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }

    public static boolean isCdiInstalled(@Nullable Module module, @NotNull CdiVersion version) {
        if (version == null) {
            CdiCommonUtils.$$$reportNull$$$0(29);
        }
        if (module == null || module.isDisposed()) {
            return false;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        if (version == CdiVersion.CDI_1_1) {
            return facade.findClass("javax.enterprise.inject.Vetoed", scope) != null;
        }
        if (version == CdiVersion.CDI_1_0) {
            return facade.findClass("javax.enterprise.inject.Instance", scope) != null;
        }
        return false;
    }

    public static boolean isEnterpraiseCdiBean(PsiClass aClass) {
        return false;
    }

    public static List<String> getAnnotations(Class clazz) {
        ArrayList<String> annotations = new ArrayList<String>();
        try {
            for (Field field : clazz.getFields()) {
                Object value = field.get(null);
                if (!(value instanceof String)) continue;
                annotations.add((String)value);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        return annotations;
    }

    public static boolean isDecorator(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(30);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.decorator.Decorator", (int)0);
    }

    public static boolean isInterceptor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(31);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.interceptor.Interceptor", (int)0);
    }

    public static boolean isAlternative(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            CdiCommonUtils.$$$reportNull$$$0(32);
        }
        if (CdiCommonUtils.isAlternativeAnnotated(psiMember)) {
            return true;
        }
        return psiMember instanceof PsiClass && CdiCommonUtils.hasAlternativeProducers((PsiClass)psiMember);
    }

    public static boolean isAlternativeAnnotated(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            CdiCommonUtils.$$$reportNull$$$0(33);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"javax.enterprise.inject.Alternative", (int)0)) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMember);
        return module != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getAlternativeStereotypeAnnotationClasses(module)), (int)0);
    }

    public static boolean hasAlternativeProducers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(34);
        }
        for (PsiField field : CdiCommonUtils.getProducerFields(psiClass)) {
            if (!CdiCommonUtils.isAlternativeAnnotated((PsiMember)field)) continue;
            return true;
        }
        for (PsiMethod psiMethod : CdiCommonUtils.getProducerMethods(psiClass)) {
            if (!CdiCommonUtils.isAlternativeAnnotated((PsiMember)psiMethod)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiClass getOriginalPsiClass(PsiType type, @NotNull Module module) {
        String name;
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(35);
        }
        if (type instanceof PsiClassType) {
            PsiType genericPsiType;
            List<PsiType> psiTypes;
            PsiClassType psiClassType = (PsiClassType)type;
            PsiClassType providerClass = CdiCommonUtils.getProviderClass(psiClassType);
            if (providerClass != null && (psiTypes = CdiCommonUtils.resolveGenerics(providerClass)).size() == 1 && (genericPsiType = psiTypes.get(0)) instanceof PsiClassType) {
                return ((PsiClassType)genericPsiType).resolve();
            }
            return psiClassType.resolve();
        }
        if (type instanceof PsiPrimitiveType && !StringUtil.isEmptyOrSpaces((String)(name = ((PsiPrimitiveType)type).getBoxedTypeName()))) {
            return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(name, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        }
        return null;
    }

    @Nullable
    private static PsiClassType getProviderClass(@NotNull PsiClassType psiClassType) {
        PsiClass psiClass;
        if (psiClassType == null) {
            CdiCommonUtils.$$$reportNull$$$0(36);
        }
        if ((psiClass = psiClassType.resolve()) == null) {
            return null;
        }
        if ("javax.inject.Provider".equals(psiClass.getQualifiedName())) {
            return psiClassType;
        }
        for (PsiType type : psiClassType.getSuperTypes()) {
            PsiClass superClass;
            if (!(type instanceof PsiClassType) || (superClass = ((PsiClassType)type).resolve()) == null || !"javax.inject.Provider".equals(superClass.getQualifiedName())) continue;
            return (PsiClassType)type;
        }
        return null;
    }

    public static List<PsiType> resolveGenerics(PsiClassType classType) {
        ArrayList<PsiType> generics = new ArrayList<PsiType>();
        PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (psiClass != null && substitutor != null) {
            for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
                generics.add(substitutor.substitute(typeParameter));
            }
        }
        return generics;
    }

    public static boolean isProxyable(@NotNull PsiType psiType) {
        if (psiType == null) {
            CdiCommonUtils.$$$reportNull$$$0(37);
        }
        if (psiType instanceof PsiPrimitiveType) {
            return false;
        }
        if (psiType instanceof PsiArrayType) {
            return false;
        }
        if (psiType instanceof PsiClassType) {
            return CdiCommonUtils.isClassProxyable(((PsiClassType)psiType).resolve());
        }
        return false;
    }

    public static boolean isClassProxyable(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (psiClass.isInterface()) {
            return true;
        }
        if (!CdiCommonUtils.hasAppropriateConstructor(psiClass)) {
            return false;
        }
        PsiModifierList list = psiClass.getModifierList();
        if (list != null && (list.hasModifierProperty("private") || list.hasModifierProperty("final"))) {
            return false;
        }
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (!psiMethod.getModifierList().hasModifierProperty("final")) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAppropriateConstructor(@NotNull PsiClass psiClass) {
        PsiMethod[] methods;
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(38);
        }
        if ((methods = psiClass.getConstructors()).length == 0) {
            return true;
        }
        for (PsiMethod psiMethod : methods) {
            if (psiMethod.getParameterList().getParametersCount() != 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<PsiMethod> getProducerMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(39);
        }
        List<PsiMethod> list = CdiCommonUtils.getProducerMethods(psiClass, true);
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(40);
        }
        return list;
    }

    @NotNull
    public static List<PsiField> getProducerFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(41);
        }
        List<PsiField> list = CdiCommonUtils.getProducerFields(psiClass, true);
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(42);
        }
        return list;
    }

    @NotNull
    public static List<PsiMethod> getProducerMethods(@NotNull PsiClass psiClass, boolean withSupers) {
        PsiMethod[] methods;
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(43);
        }
        ArrayList<PsiMethod> producers = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : methods = withSupers ? psiClass.getAllMethods() : psiClass.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"javax.enterprise.inject.Produces", (int)1)) continue;
            producers.add(psiMethod);
        }
        ArrayList<PsiMethod> arrayList = producers;
        if (arrayList == null) {
            CdiCommonUtils.$$$reportNull$$$0(44);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiField> getProducerFields(@NotNull PsiClass psiClass, boolean withSupers) {
        PsiField[] fields;
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(45);
        }
        ArrayList<PsiField> producers = new ArrayList<PsiField>();
        for (PsiField psiField : fields = withSupers ? psiClass.getAllFields() : psiClass.getFields()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiField, (String)"javax.enterprise.inject.Produces", (int)0)) continue;
            producers.add(psiField);
        }
        ArrayList<PsiField> arrayList = producers;
        if (arrayList == null) {
            CdiCommonUtils.$$$reportNull$$$0(46);
        }
        return arrayList;
    }

    public static List<PsiMember> getPsiTypeProducers(@NotNull Module module, @NotNull PsiType psiType) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(47);
        }
        if (psiType == null) {
            CdiCommonUtils.$$$reportNull$$$0(48);
        }
        ArrayList<PsiMember> producers = new ArrayList<PsiMember>();
        for (CdiProduces jamProduces : CdiJamModel.getModel(module).getProduces()) {
            PsiType productType = jamProduces.getProductType();
            if (productType == null || !productType.isAssignableFrom(psiType)) continue;
            producers.add((PsiMember)jamProduces.getPsiElement());
        }
        return producers;
    }

    @NotNull
    public static List<PsiMethod> getDisposerMethods(@NotNull PsiClass psiClass) {
        PsiMethod[] methods;
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(49);
        }
        ArrayList<PsiMethod> disposerMethods = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : methods = psiClass.getAllMethods()) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)"javax.enterprise.inject.Disposes", (int)0)) continue;
                disposerMethods.add(psiMethod);
            }
        }
        ArrayList<PsiMethod> arrayList = disposerMethods;
        if (arrayList == null) {
            CdiCommonUtils.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiMethod> getObservesMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(51);
        }
        ArrayList<PsiMethod> observesMethods = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : psiClass.getAllMethods()) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, Arrays.asList("javax.enterprise.event.Observes", "javax.enterprise.event.ObservesAsync"), (int)0)) continue;
                observesMethods.add(psiMethod);
            }
        }
        ArrayList<PsiMethod> arrayList = observesMethods;
        if (arrayList == null) {
            CdiCommonUtils.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    public static boolean isClassContainsCdiAnnotations(PsiClass psiClass, Module module) {
        List<String> annos = CdiCommonUtils.collectCdiBeansAnnotations(module);
        return CdiCommonUtils.isClassContainsCdiAnnotations(psiClass, annos);
    }

    public static boolean isClassContainsCdiAnnotations(@NotNull PsiClass psiClass, @NotNull List<String> annos) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(53);
        }
        if (annos == null) {
            CdiCommonUtils.$$$reportNull$$$0(54);
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, annos) != null) {
            return true;
        }
        for (PsiField psiField : psiClass.getFields()) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, annos) == null) continue;
            return true;
        }
        for (PsiField psiField : psiClass.getMethods()) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, annos) != null) {
                return true;
            }
            for (PsiParameter parameter : psiField.getParameterList().getParameters()) {
                if (AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, annos) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> collectCdiBeansAnnotations(Module module) {
        List<String> annotations = CdiCommonUtils.getAnnotations(CdiAnnoConstants.class);
        annotations.addAll(CdiCommonUtils.getBindingTypesQualifiedNames(module));
        annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getNormalScopeTypesClasses(module)));
        annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getDeploymentTypesClasses(module)));
        annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getStereotypeAnnotationClasses(module)));
        annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getScopeTypesClasses(module)));
        return annotations;
    }

    public static boolean hasImplicitArchive(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(55);
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                CdiCommonUtils.$$$reportNull$$$0(77);
            }
            return new CachedValueProvider.Result((Object)CdiCommonUtils.hasBeanDefinedClasses(module), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    public static boolean hasBeanDefinedClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(56);
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        for (String anno : CdiCommonUtils.getBeanDefiningAnnotations(module)) {
            if (!CdiCommonUtils.hasAnnotatedMembers(javaPsiFacade, searchScope, anno)) continue;
            return true;
        }
        if (CdiCommonUtils.hasAnnotatedMembers(javaPsiFacade, searchScope, "javax.ejb.Stateful")) {
            return true;
        }
        return CdiCommonUtils.hasAnnotatedMembers(javaPsiFacade, searchScope, "javax.ejb.Stateless");
    }

    public static boolean hasAnnotatedMembers(@NotNull JavaPsiFacade javaPsiFacade, @NotNull GlobalSearchScope searchScope, @NotNull String anno) {
        PsiClass annoClass;
        if (javaPsiFacade == null) {
            CdiCommonUtils.$$$reportNull$$$0(57);
        }
        if (searchScope == null) {
            CdiCommonUtils.$$$reportNull$$$0(58);
        }
        if (anno == null) {
            CdiCommonUtils.$$$reportNull$$$0(59);
        }
        return (annoClass = javaPsiFacade.findClass(anno, searchScope)) != null && AnnotatedMembersSearch.search((PsiClass)annoClass, (SearchScope)searchScope).findFirst() != null;
    }

    @NotNull
    public static Set<String> getBeanDefiningAnnotations(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(60);
        }
        LinkedHashSet annotations = ContainerUtil.newLinkedHashSet();
        annotations.addAll(CdiCommonUtils.getNormalScopeQualifiedNames(module));
        annotations.add("javax.decorator.Decorator");
        annotations.add("javax.interceptor.Interceptor");
        annotations.addAll(CdiCommonUtils.getStereotypeAnnotationNames(module));
        annotations.add("javax.enterprise.context.Dependent");
        LinkedHashSet linkedHashSet = annotations;
        if (linkedHashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(61);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<CdiExtensionBeanDescriptor> collectExtensionBeanDescriptors(@NotNull Project project) {
        if (project == null) {
            CdiCommonUtils.$$$reportNull$$$0(62);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                CdiCommonUtils.$$$reportNull$$$0(76);
            }
            HashSet descriptors = ContainerUtil.newHashSet();
            Collection<CdiObserves> afterBeanDiscoveryObserves = CdiCommonUtils.getAfterBeanDiscoveryObserves(project, GlobalSearchScope.allScope((Project)project));
            if (afterBeanDiscoveryObserves.size() > 0) {
                for (CdiObserves observe : afterBeanDiscoveryObserves) {
                    ContainerUtil.addAllNotNull((Collection)descriptors, CdiCommonUtils.collectBeanDescriptors(observe));
                }
            }
            return CachedValueProvider.Result.create((Object)descriptors, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
        if (set == null) {
            CdiCommonUtils.$$$reportNull$$$0(63);
        }
        return set;
    }

    @NotNull
    private static Set<CdiExtensionBeanDescriptor> collectBeanDescriptors(@NotNull CdiObserves observe) {
        PsiClass aClass;
        PsiMethod method;
        if (observe == null) {
            CdiCommonUtils.$$$reportNull$$$0(64);
        }
        if ((method = observe.getPsiMethod()) != null && (aClass = JavaPsiFacade.getInstance((Project)method.getProject()).findClass("javax.enterprise.inject.spi.AfterBeanDiscovery", method.getResolveScope())) != null) {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = aClass.findMethodsByName("addBean", true)) {
                if (psiMethod.getParameterList().getParametersCount() != 0) continue;
                Set<CdiExtensionBeanDescriptor> set = CdiCommonUtils.searchAddBeanExpressions(psiMethod, (SearchScope)new LocalSearchScope((PsiElement)method));
                if (set == null) {
                    CdiCommonUtils.$$$reportNull$$$0(65);
                }
                return set;
            }
        }
        Set<CdiExtensionBeanDescriptor> set = Collections.emptySet();
        if (set == null) {
            CdiCommonUtils.$$$reportNull$$$0(66);
        }
        return set;
    }

    @NotNull
    private static Set<CdiExtensionBeanDescriptor> searchAddBeanExpressions(@NotNull PsiMethod fireEventMethod, @NotNull SearchScope searchScope) {
        if (fireEventMethod == null) {
            CdiCommonUtils.$$$reportNull$$$0(67);
        }
        if (searchScope == null) {
            CdiCommonUtils.$$$reportNull$$$0(68);
        }
        LinkedHashSet set = ContainerUtil.newLinkedHashSet();
        MethodReferencesSearch.search((PsiMethod)fireEventMethod, (SearchScope)searchScope, (boolean)true).forEach(psiReference -> {
            PsiMethodCallExpression methodCallExpression;
            if (set == null) {
                CdiCommonUtils.$$$reportNull$$$0(75);
            }
            if ((methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class)) != null) {
                set.add(CdiExtensionBeanDescriptor.create(methodCallExpression));
            }
            return true;
        });
        LinkedHashSet linkedHashSet = set;
        if (linkedHashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(69);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<CdiObserves> getAfterBeanDiscoveryObserves(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            CdiCommonUtils.$$$reportNull$$$0(70);
        }
        if (scope == null) {
            CdiCommonUtils.$$$reportNull$$$0(71);
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                CdiCommonUtils.$$$reportNull$$$0(73);
            }
            if (scope == null) {
                CdiCommonUtils.$$$reportNull$$$0(74);
            }
            List observes = JamService.getJamService((Project)project).getJamParameterElements(CdiObserves.OBSERVES_JAM_KEY, "javax.enterprise.event.Observes", scope);
            Set observesSet = observes.stream().filter(cdiObserves -> InheritanceUtil.isInheritor((PsiType)cdiObserves.getType(), (String)"javax.enterprise.inject.spi.AfterBeanDiscovery")).collect(Collectors.toSet());
            return CachedValueProvider.Result.create(observesSet, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(72);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/utils/CdiCommonUtils";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 35: 
            case 47: 
            case 55: 
            case 56: 
            case 60: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 49: 
            case 51: 
            case 53: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClassType";
                break;
            }
            case 37: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annos";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaPsiFacade";
                break;
            }
            case 58: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 62: 
            case 70: 
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observe";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fireEventMethod";
                break;
            }
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierClasses";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotations";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterceptorBindingTypesClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingTypesQualifiedNames";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/utils/CdiCommonUtils";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalScopeTypesClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalScopeQualifiedNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeTypesClasses";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeQualifiedNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentTypesClasses";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getStereotypeAnnotationNames";
                break;
            }
            case 20: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getStereotypeAnnotationClasses";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getVetoedPackages";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlternativeStereotypeAnnotationClasses";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
            case 40: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerMethods";
                break;
            }
            case 42: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerFields";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposerMethods";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getObservesMethods";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanDefiningAnnotations";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExtensionBeanDescriptors";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBeanDescriptors";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "searchAddBeanExpressions";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterBeanDiscoveryObserves";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNormalScopeTypesClasses";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNormalScopeQualifiedNames";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getScopeTypesClasses";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getScopeQualifiedNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentTypesClasses";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeAnnotationNames";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeAnnotationClasses";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getVetoedPackages";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeStereotypeAnnotationClasses";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isManagedBean";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isCdiInstalled";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isDecorator";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isInterceptor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isAlternative";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isAlternativeAnnotated";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasAlternativeProducers";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalPsiClass";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getProviderClass";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isProxyable";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "hasAppropriateConstructor";
                break;
            }
            case 39: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getProducerMethods";
                break;
            }
            case 41: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getProducerFields";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getPsiTypeProducers";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getDisposerMethods";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getObservesMethods";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isClassContainsCdiAnnotations";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "hasImplicitArchive";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "hasBeanDefinedClasses";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotatedMembers";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getBeanDefiningAnnotations";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "collectExtensionBeanDescriptors";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "collectBeanDescriptors";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "searchAddBeanExpressions";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getAfterBeanDiscoveryObserves";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAfterBeanDiscoveryObserves$7";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "lambda$searchAddBeanExpressions$5";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectExtensionBeanDescriptors$4";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasImplicitArchive$3";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isManagedBean$2";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getVetoedPackages$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

