/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.converter;

import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.SystemProperties;
import java.time.LocalDate;
import java.time.Month;
import org.jetbrains.annotations.NotNull;

public class MigrateToCloudToolsNotification
implements StartupActivity,
DumbAware {
    public void runActivity(@NotNull Project project) {
        ProjectFacetManager facetManager;
        if (project == null) {
            MigrateToCloudToolsNotification.$$$reportNull$$$0(0);
        }
        if ((facetManager = ProjectFacetManager.getInstance((Project)project)).hasFacets(AppEngineFacet.ID) && MigrateToCloudToolsNotification.isAppEngineSdkDeprecated()) {
            String text = "<html><body><p>It looks like your project is using the App Engine SDK. While the App Engine SDK is still supported, Google recommends that you migrate to the <a href=\"https://cloud.google.com/sdk/\">Google Cloud SDK</a>. The Cloud SDK provides new features such as <a href=\"https://cloud.google.com/appengine/docs/flexible/\">App Engine Flexible</a> support and <a href=\"https://cloud.google.com/debugger/\">Google Cloud Debugger</a> integration.</p><p><a href=\"https://cloud.google.com/tools/intellij/docs/migrate\">Learn more about migrating to the new Cloud tools</a>.</p></body></html>";
            Notification notification = new Notification("Migrate to Google Cloud SDK", "App Engine SDK Detected", text, NotificationType.WARNING, (NotificationListener)new NotificationListener.UrlOpeningListener(false));
            notification.notify(project);
        }
    }

    private static boolean isAppEngineSdkDeprecated() {
        return SystemProperties.getBooleanProperty((String)"idea.enable.migration.to.google.cloud.sdk", (boolean)LocalDate.now().isAfter(LocalDate.of(2017, Month.MAY, 5)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/appengine/converter/MigrateToCloudToolsNotification", "runActivity"));
    }
}

