/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.MouseAdapterComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.ActivityAction;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.adtui.model.event.StackedEventType;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;

public class StackedEventComponent
extends MouseAdapterComponent {
    private static final Color DISABLED_ACTION = new JBColor(14409698, 6184800);
    private static final Color ENABLED_ACTION = new JBColor(6609078, 1224865);
    private static final int CHARACTERS_TO_SHRINK_BY = 1;
    private static final int SEGMENT_SPACING = 5;
    private static final float DEFAULT_LINE_THICKNESS = 0.5f;
    private static final float EXPANDED_LINE_THICKNESS = 1.2f;
    private static final float FONT_PADDING = 10.0f;
    private static final int FONT_SPACING = 7;
    @NotNull
    private final EventModel<StackedEventType> myModel;
    private HashMap<EventAction<StackedEventType>, EventRenderData> myActionToDrawLocationMap;
    private List<EventRenderData> myActivities;
    private boolean myRender;

    public StackedEventComponent(@NotNull EventModel<StackedEventType> model) {
        if (model == null) {
            StackedEventComponent.$$$reportNull$$$0(0);
        }
        super(0.5, 1.2f);
        this.myActionToDrawLocationMap = new HashMap();
        this.myActivities = new ArrayList<EventRenderData>();
        this.myModel = model;
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.myModel.addDependency(this.myAspectObserver).onChange(EventModel.Aspect.EVENT, this::modelChanged);
        this.myRender = true;
    }

    private void modelChanged() {
        this.myRender = true;
        this.opaqueRepaint();
    }

    private void renderActivity() {
        double min = this.myModel.getRangedSeries().getXRange().getMin();
        double max = this.myModel.getRangedSeries().getXRange().getMax();
        this.myActivities.clear();
        this.myActionToDrawLocationMap.clear();
        List<SeriesData<EventAction<StackedEventType>>> series = this.myModel.getRangedSeries().getSeries();
        int size = series.size();
        for (int i = 0; i < size; ++i) {
            SeriesData<EventAction<StackedEventType>> seriesData = series.get(i);
            ActivityAction data = (ActivityAction)seriesData.value;
            double endTime = data.getEndUs() == 0L ? max : (double)data.getEndUs();
            double normalizedEndPosition = (endTime - min) / (max - min);
            double normalizedStartPosition = ((double)data.getStartUs() - min) / (max - min);
            if (normalizedStartPosition < 0.0) {
                normalizedStartPosition = 0.0;
            }
            Rectangle2D.Float rect = this.setRectangleData(data, data.getStartUs(), endTime, min, max, 0.3f, 0.2f);
            this.myActivities.add(new EventRenderData(data, rect));
        }
        this.myActivities.sort((erd1, erd2) -> {
            if (erd1.getAction().getEndUs() == 0L && erd2.getAction().getEndUs() != 0L) {
                return -1;
            }
            if (erd1.getAction().getEndUs() != 0L && erd2.getAction().getEndUs() == 0L) {
                return 1;
            }
            if (erd1.getAction().getEndUs() != 0L && erd2.getAction().getEndUs() != 0L) {
                return erd1.getAction().getEndUs() - erd2.getAction().getEndUs() >= 0L ? 1 : -1;
            }
            return erd1.getAction().getStartUs() - erd2.getAction().getStartUs() >= 0L ? 1 : -1;
        });
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.myRender) {
            this.renderActivity();
            this.myRender = false;
        }
        g2d.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(11.0f));
        this.drawActivity(g2d, dim);
    }

    private void drawActivity(Graphics2D g2d, Dimension dim) {
        int scaleFactor = dim.width;
        AffineTransform scale = AffineTransform.getScaleInstance(scaleFactor, dim.height - 5);
        double min = this.myModel.getRangedSeries().getXRange().getMin();
        double max = this.myModel.getRangedSeries().getXRange().getMax();
        FontMetrics metrics = g2d.getFontMetrics();
        ListIterator<EventRenderData> itor = this.myActivities.listIterator();
        while (itor.hasNext()) {
            EventRenderData renderData = itor.next();
            EventAction<StackedEventType> event = renderData.getAction();
            g2d.setColor(event.getEndUs() == 0L ? ENABLED_ACTION : DISABLED_ACTION);
            Shape shape = scale.createTransformedShape(renderData.getPath());
            g2d.fill(shape);
            String text = "";
            if (event.getType() != StackedEventType.NONE) {
                text = ((ActivityAction)event).getData();
            }
            double normalizedStartPosition = ((double)event.getStartUs() - min) / (max - min);
            double lifetime = event.getEndUs();
            if (event.getEndUs() == 0L) {
                lifetime = max;
            }
            double normalizedEndPosition = (lifetime - min) / (max - min);
            float startPosition = (float)normalizedStartPosition * (float)scaleFactor;
            float endPosition = (float)normalizedEndPosition * (float)scaleFactor;
            boolean ellipsis = true;
            if (startPosition <= 10.0f) {
                startPosition = 10.0f;
            }
            if (ellipsis && (text = AdtUiUtils.getFittedString(metrics, text, endPosition - startPosition, 1)).isEmpty()) continue;
            g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
            float normalizedLineHeight = this.getRectangle(event).height - 0.5f;
            g2d.drawString(text, startPosition, 7.0f - normalizedLineHeight * (float)dim.getHeight());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/StackedEventComponent", "<init>"));
    }

    private static class EventRenderData {
        private final EventAction<StackedEventType> mAction;
        private final Rectangle2D mPath;

        public EventAction<StackedEventType> getAction() {
            return this.mAction;
        }

        public Rectangle2D getPath() {
            return this.mPath;
        }

        public EventRenderData(EventAction<StackedEventType> action, Rectangle2D path) {
            this.mAction = action;
            this.mPath = path;
        }
    }
}

