/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public final class AdtUiUtils {
    public static final JBFont DEFAULT_FONT = JBFont.create((Font)new Font(null, 0, 10));
    public static final Color DEFAULT_FONT_COLOR = JBColor.foreground();
    public static final Color DEFAULT_BORDER_COLOR = new JBColor((Color)Gray._201, (Color)Gray._40);
    public static final Border DEFAULT_TOP_BORDER = BorderFactory.createMatteBorder(1, 0, 0, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_LEFT_BORDER = BorderFactory.createMatteBorder(0, 1, 0, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_BOTTOM_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_RIGHT_BORDER = BorderFactory.createMatteBorder(0, 0, 0, 1, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_HORIZONTAL_BORDERS = BorderFactory.createMatteBorder(1, 0, 1, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_VERTICAL_BORDERS = BorderFactory.createMatteBorder(0, 1, 0, 1, DEFAULT_BORDER_COLOR);
    public static final GridBagConstraints GBC_FULL = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 256, 1, new Insets(0, 0, 0, 0), 0, 0);

    private AdtUiUtils() {
    }

    public static String getFittedString(FontMetrics metrics, String text, float availableSpace, int characterToShrink) {
        int textWidth = metrics.stringWidth(text);
        int ellipsysWidth = metrics.stringWidth("...");
        if ((float)textWidth <= availableSpace) {
            return text;
        }
        if (availableSpace < (float)ellipsysWidth) {
            return "";
        }
        while ((float)textWidth > availableSpace) {
            text = text.substring(0, Math.max(0, text.length() - characterToShrink));
            textWidth = metrics.stringWidth(text) + ellipsysWidth;
        }
        return text + "...";
    }

    public static int unscale(int i) {
        return Math.round((float)i / JBUI.scale((float)1.0f));
    }
}

