/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.os.FileUtils;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import libcore.io.Libcore;

class DexLoadReporter
implements BaseDexClassLoader.Reporter {
    private static final String TAG = "DexLoadReporter";
    private static final DexLoadReporter INSTANCE = new DexLoadReporter();
    private static final boolean DEBUG = false;
    @GuardedBy(value="mDataDirs")
    private final Set<String> mDataDirs = new HashSet<String>();

    private DexLoadReporter() {
    }

    static DexLoadReporter getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerAppDataDir(String packageName, String dataDir) {
        if (dataDir != null) {
            Set<String> set = this.mDataDirs;
            synchronized (set) {
                this.mDataDirs.add(dataDir);
            }
        }
    }

    @Override
    public void report(List<BaseDexClassLoader> classLoadersChain, List<String> classPaths) {
        if (classLoadersChain.size() != classPaths.size()) {
            Slog.wtf(TAG, "Bad call to DexLoadReporter: argument size mismatch");
            return;
        }
        if (classPaths.isEmpty()) {
            Slog.wtf(TAG, "Bad call to DexLoadReporter: empty dex paths");
            return;
        }
        String[] dexPathsForRegistration = classPaths.get(0).split(File.pathSeparator);
        if (dexPathsForRegistration.length == 0) {
            return;
        }
        this.notifyPackageManager(classLoadersChain, classPaths);
        this.registerSecondaryDexForProfiling(dexPathsForRegistration);
    }

    private void notifyPackageManager(List<BaseDexClassLoader> classLoadersChain, List<String> classPaths) {
        ArrayList<String> classLoadersNames = new ArrayList<String>(classPaths.size());
        for (BaseDexClassLoader bdc : classLoadersChain) {
            classLoadersNames.add(bdc.getClass().getName());
        }
        String packageName = ActivityThread.currentPackageName();
        try {
            ActivityThread.getPackageManager().notifyDexLoad(packageName, classLoadersNames, classPaths, VMRuntime.getRuntime().vmInstructionSet());
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Failed to notify PM about dex load for package " + packageName, re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSecondaryDexForProfiling(String[] dexPaths) {
        if (!SystemProperties.getBoolean("dalvik.vm.dexopt.secondary", false)) {
            return;
        }
        String[] stringArray = this.mDataDirs;
        synchronized (this.mDataDirs) {
            String[] dataDirs = this.mDataDirs.toArray(new String[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (String dexPath : dexPaths) {
                this.registerSecondaryDexForProfiling(dexPath, dataDirs);
            }
            return;
        }
    }

    private void registerSecondaryDexForProfiling(String dexPath, String[] dataDirs) {
        File realDexPath;
        if (!this.isSecondaryDexFile(dexPath, dataDirs)) {
            return;
        }
        try {
            realDexPath = new File(Libcore.os.realpath(dexPath));
        }
        catch (ErrnoException ex) {
            Slog.e(TAG, "Failed to get the real path of secondary dex " + dexPath + ":" + ex.getMessage());
            return;
        }
        File secondaryProfileDir = new File(realDexPath.getParent(), "oat");
        File secondaryProfile = new File(secondaryProfileDir, realDexPath.getName() + ".cur.prof");
        if (!secondaryProfileDir.exists() && !secondaryProfileDir.mkdir()) {
            Slog.e(TAG, "Could not create the profile directory: " + secondaryProfile);
            return;
        }
        try {
            boolean bl = secondaryProfile.createNewFile();
        }
        catch (IOException ex) {
            Slog.e(TAG, "Failed to create profile for secondary dex " + dexPath + ":" + ex.getMessage());
            return;
        }
        VMRuntime.registerAppInfo(secondaryProfile.getPath(), new String[]{dexPath});
    }

    private boolean isSecondaryDexFile(String dexPath, String[] dataDirs) {
        for (String dataDir : dataDirs) {
            if (!FileUtils.contains(dataDir, dexPath)) continue;
            return true;
        }
        return false;
    }
}

